/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class ArrayCellReplacementVarInformation {
    private final TermVariable mArrayInstance;
    private final TermVariable mArrayRepresentative;
    private final ArrayIndex mIndex;
    private final ArrayIndex mIndexRepresentative;
    private final VarType mVarType;
    private final ModifiableTransFormula mTransFormulaLR;
    private IReplacementVarOrConst mReplacementVar;

    public ArrayCellReplacementVarInformation(TermVariable termVariable, TermVariable termVariable2, ArrayIndex arrayIndex, ArrayIndex arrayIndex2, VarType varType, ModifiableTransFormula modifiableTransFormula) {
        this.mArrayInstance = termVariable;
        this.mArrayRepresentative = termVariable2;
        this.mIndex = arrayIndex;
        this.mIndexRepresentative = arrayIndex2;
        this.mVarType = varType;
        this.mTransFormulaLR = modifiableTransFormula;
    }

    public TermVariable getArrayInstance() {
        return this.mArrayInstance;
    }

    public TermVariable getArrayRepresentative() {
        return this.mArrayRepresentative;
    }

    public ArrayIndex getIndex() {
        return this.mIndex;
    }

    public ArrayIndex getIndexRepresentative() {
        return this.mIndexRepresentative;
    }

    public VarType getVarType() {
        return this.mVarType;
    }

    public IReplacementVarOrConst getReplacementVar() {
        return this.mReplacementVar;
    }

    public void setReplacementVar(IReplacementVarOrConst iReplacementVarOrConst) {
        this.mReplacementVar = iReplacementVarOrConst;
    }

    public Map<TermVariable, IProgramVar> termVariableToRankVarMappingForIndex() {
        HashMap<TermVariable, IProgramVar> hashMap = new HashMap<TermVariable, IProgramVar>();
        for (Term term : this.mIndex) {
            TermVariable[] termVariableArray = term.getFreeVars();
            int n = termVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable termVariable = termVariableArray[n2];
                IProgramVar iProgramVar = (IProgramVar)this.mTransFormulaLR.getInVarsReverseMapping().get(termVariable);
                if (iProgramVar != null) {
                    hashMap.put(termVariable, iProgramVar);
                } else {
                    IProgramVar iProgramVar2 = (IProgramVar)this.mTransFormulaLR.getOutVarsReverseMapping().get(termVariable);
                    if (iProgramVar2 != null) {
                        hashMap.put(termVariable, iProgramVar2);
                    } else {
                        throw new AssertionError((Object)"must be an auxVar!?! rare case, not yet implemented");
                    }
                }
                ++n2;
            }
        }
        return hashMap;
    }

    public IProgramVar getArrayRankVar() {
        IProgramVar iProgramVar = (IProgramVar)this.mTransFormulaLR.getInVarsReverseMapping().get(this.mArrayInstance);
        if (iProgramVar == null) {
            iProgramVar = (IProgramVar)this.mTransFormulaLR.getOutVarsReverseMapping().get(this.mArrayInstance);
        }
        if (iProgramVar == null) {
            throw new AssertionError((Object)"unknown array cell");
        }
        return iProgramVar;
    }

    public static enum VarType {
        InVar,
        OutVar;

    }
}

