/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifierStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.ContainsQuantifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.CheckClosedTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PosetUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class PredicateUnifier
implements IPredicateUnifier {
    private static final boolean DUMP_UNEXPLOITED_ELIMININATION_POSSIBILITIES = false;
    protected final ManagedScript mMgdScript;
    private final BasicPredicateFactory mPredicateFactory;
    private final Map<Term, IPredicate> mTerm2Predicates;
    private final LinkedHashSet<IPredicate> mKnownPredicates = new LinkedHashSet();
    private final Map<IPredicate, IPredicate> mDeprecatedPredicates = new HashMap<IPredicate, IPredicate>();
    private final CoverageRelation mCoverageRelation = new CoverageRelation();
    protected final ILogger mLogger;
    protected final IUltimateServiceProvider mServices;
    private final Script mScript;
    private final MonolithicImplicationChecker mImplicationChecker;
    private final IIcfgSymbolTable mSymbolTable;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final IPredicate mTruePredicate;
    private final IPredicate mFalsePredicate;
    private final PredicateUnifierStatisticsGenerator mPredicateUnifierBenchmarkGenerator = new PredicateUnifierStatisticsGenerator();

    public PredicateUnifier(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, IIcfgSymbolTable iIcfgSymbolTable, SmtUtils.SimplificationTechnique simplificationTechnique, IPredicate ... iPredicateArray) {
        IPredicate iPredicate;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mMgdScript = managedScript;
        this.mPredicateFactory = basicPredicateFactory;
        this.mScript = managedScript.getScript();
        this.mSymbolTable = iIcfgSymbolTable;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mImplicationChecker = new MonolithicImplicationChecker(this.mServices, this.mMgdScript);
        this.mTerm2Predicates = new HashMap<Term, IPredicate>();
        Term term = this.mScript.term("true", new Term[0]);
        IPredicate iPredicate2 = null;
        Term term2 = this.mScript.term("false", new Term[0]);
        IPredicate iPredicate3 = null;
        IPredicate[] iPredicateArray2 = iPredicateArray;
        int n = iPredicateArray.length;
        int n2 = 0;
        while (n2 < n) {
            iPredicate = iPredicateArray2[n2];
            if (iPredicate.getFormula().equals(term)) {
                iPredicate2 = iPredicate;
            } else if (iPredicate.getFormula().equals(term2)) {
                iPredicate3 = iPredicate;
            }
            ++n2;
        }
        this.mTruePredicate = iPredicate2 == null ? this.constructNewPredicate(this.mScript.term("true", new Term[0]), null) : iPredicate2;
        this.mFalsePredicate = iPredicate3 == null ? this.constructNewPredicate(this.mScript.term("false", new Term[0]), null) : iPredicate3;
        this.declareTruePredicateAndFalsePredicate();
        iPredicateArray2 = iPredicateArray;
        n = iPredicateArray.length;
        n2 = 0;
        while (n2 < n) {
            iPredicate = iPredicateArray2[n2];
            if (iPredicate != this.mFalsePredicate && iPredicate != this.mTruePredicate) {
                this.declarePredicate(iPredicate);
            }
            ++n2;
        }
        iLogger.info((Object)"Initialized classic predicate unifier");
    }

    @Override
    public IPredicate getTruePredicate() {
        return this.mTruePredicate;
    }

    @Override
    public IPredicate getFalsePredicate() {
        return this.mFalsePredicate;
    }

    private void declareTruePredicateAndFalsePredicate() {
        Map<IPredicate, IncrementalPlicationChecker.Validity> map = Collections.emptyMap();
        Map<IPredicate, IncrementalPlicationChecker.Validity> map2 = Collections.emptyMap();
        this.addNewPredicate(this.mTruePredicate, this.mTruePredicate.getFormula(), this.mTruePredicate.getFormula(), map, map2);
        Map<IPredicate, IncrementalPlicationChecker.Validity> map3 = Collections.singletonMap(this.mTruePredicate, IncrementalPlicationChecker.Validity.VALID);
        Map<IPredicate, IncrementalPlicationChecker.Validity> map4 = Collections.singletonMap(this.mTruePredicate, IncrementalPlicationChecker.Validity.INVALID);
        this.addNewPredicate(this.mFalsePredicate, this.mFalsePredicate.getFormula(), this.mFalsePredicate.getFormula(), map3, map4);
    }

    @Override
    public boolean isRepresentative(IPredicate iPredicate) {
        IPredicate iPredicate2 = this.mTerm2Predicates.get(iPredicate.getFormula());
        return iPredicate == iPredicate2;
    }

    void declarePredicate(IPredicate iPredicate) {
        PredicateComparison predicateComparison = new PredicateComparison(iPredicate.getFormula(), iPredicate.getVars(), null, null);
        if (predicateComparison.isEquivalentToExistingPredicateWithLeqQuantifiers()) {
            IPredicate iPredicate2 = predicateComparison.getEquivalantLeqQuantifiedPredicate();
            if (iPredicate2 != iPredicate) {
                this.mLogger.fatal((Object)("Have " + String.valueOf(iPredicate2)));
                this.mLogger.fatal((Object)("Want " + String.valueOf(iPredicate)));
                throw new AssertionError((Object)"There is already an equivalent predicate");
            }
        } else if (predicateComparison.isEquivalentToExistingPredicatesWithGtQuantifiers()) {
            if (predicateComparison.getEquivalantGtQuantifiedPredicates().size() != 1 || !predicateComparison.getEquivalantGtQuantifiedPredicates().contains(iPredicate)) {
                throw new AssertionError((Object)"There is already an equivalent predicate");
            }
        } else {
            this.addNewPredicate(iPredicate, iPredicate.getFormula(), iPredicate.getFormula(), predicateComparison.getImpliedPredicates(), predicateComparison.getExpliedPredicates());
        }
        this.mPredicateUnifierBenchmarkGenerator.incrementDeclaredPredicates();
    }

    @Override
    public IPredicate getOrConstructPredicateForConjunction(Collection<IPredicate> collection) {
        IPredicate iPredicate22;
        Set<IPredicate> set = PosetUtils.filterMinimalElements(collection, this.mCoverageRelation.getPartialComparator()).collect(Collectors.toSet());
        if (set.size() == 1) {
            return (IPredicate)set.iterator().next();
        }
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap2 = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        for (IPredicate iPredicate22 : set) {
            for (IPredicate iPredicate3 : this.getCoverageRelation().getCoveringPredicates(iPredicate22)) {
                hashMap.put(iPredicate3, IncrementalPlicationChecker.Validity.VALID);
            }
            for (IPredicate iPredicate3 : ((CoverageRelation)this.getCoverageRelation()).getNonCoveredPredicates(iPredicate22)) {
                hashMap2.put(iPredicate3, IncrementalPlicationChecker.Validity.INVALID);
            }
        }
        iPredicate22 = this.mPredicateFactory.and(set);
        return this.getOrConstructPredicate(iPredicate22.getFormula(), hashMap, hashMap2, iPredicate22, iPredicate -> this.postProcessPredicateForConjunction((IPredicate)iPredicate, set));
    }

    @Override
    public IPredicate getOrConstructPredicateForDisjunction(Collection<IPredicate> collection) {
        IPredicate iPredicate22;
        Set<IPredicate> set = PosetUtils.filterMaximalElements(collection, this.mCoverageRelation.getPartialComparator()).collect(Collectors.toSet());
        if (set.size() == 1) {
            return (IPredicate)set.iterator().next();
        }
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap2 = new HashMap<IPredicate, IncrementalPlicationChecker.Validity>();
        for (IPredicate iPredicate22 : set) {
            for (IPredicate iPredicate3 : this.mKnownPredicates) {
                IncrementalPlicationChecker.Validity validity = this.getCoverageRelation().isCovered(iPredicate3, iPredicate22);
                if (validity == IncrementalPlicationChecker.Validity.VALID) {
                    hashMap2.put(iPredicate3, IncrementalPlicationChecker.Validity.VALID);
                }
                if ((validity = this.getCoverageRelation().isCovered(iPredicate22, iPredicate3)) != IncrementalPlicationChecker.Validity.INVALID) continue;
                hashMap.put(iPredicate3, IncrementalPlicationChecker.Validity.INVALID);
            }
        }
        iPredicate22 = this.mPredicateFactory.or(set);
        return this.getOrConstructPredicate(iPredicate22.getFormula(), hashMap, hashMap2, iPredicate22, iPredicate -> this.postProcessPredicateForDisjunction((IPredicate)iPredicate, set));
    }

    private boolean varsIsSupersetOfFreeTermVariables(Term term, Set<IProgramVar> set) {
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            IProgramVar iProgramVar = this.mSymbolTable.getProgramVar(termVariable);
            if (iProgramVar == null) {
                throw new AssertionError((Object)("Variable " + String.valueOf(termVariable) + " has no corresponding BoogieVar, hence seems to be some auxiliary variable and may not occur unquantified in the formula of a predicate"));
            }
            if (!set.contains(iProgramVar)) {
                throw new AssertionError((Object)("Variable " + String.valueOf(termVariable) + " does not occur in vars"));
            }
            ++n2;
        }
        return true;
    }

    @Override
    public IPredicate getOrConstructPredicate(IPredicate iPredicate2) {
        if (this.mKnownPredicates.contains(iPredicate2)) {
            return iPredicate2;
        }
        return this.getOrConstructPredicate(iPredicate2.getFormula(), null, null, iPredicate2, iPredicate -> iPredicate);
    }

    @Override
    public IPredicate getOrConstructPredicate(Term term) {
        return this.getOrConstructPredicate(term, null, null, null, iPredicate -> iPredicate);
    }

    protected IPredicate postProcessPredicateForConjunction(IPredicate iPredicate, Set<IPredicate> set) {
        return iPredicate;
    }

    protected IPredicate postProcessPredicateForDisjunction(IPredicate iPredicate, Set<IPredicate> set) {
        return iPredicate;
    }

    private IPredicate getOrConstructPredicate(Term term, HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap, HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap2, IPredicate iPredicate, UnaryOperator<IPredicate> unaryOperator) {
        Object object;
        IPredicate iPredicate2;
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns(term, this.mMgdScript, this.mSymbolTable);
        this.mPredicateUnifierBenchmarkGenerator.continueTime();
        this.mPredicateUnifierBenchmarkGenerator.incrementGetRequests();
        assert (this.varsIsSupersetOfFreeTermVariables(term, termVarsFuns.getVars()));
        Term term2 = PredicateUnifier.stripAnnotation(term);
        IPredicate iPredicate3 = this.mTerm2Predicates.get(term2);
        if (iPredicate3 != null) {
            if (this.mDeprecatedPredicates.containsKey(iPredicate3)) {
                iPredicate3 = this.mDeprecatedPredicates.get(iPredicate3);
            }
            this.mPredicateUnifierBenchmarkGenerator.incrementSyntacticMatches();
            this.mPredicateUnifierBenchmarkGenerator.stopTime();
            return iPredicate3;
        }
        iPredicate3 = new CommuhashNormalForm(this.mServices, this.mScript).transform(term2);
        Object object2 = this.mTerm2Predicates.get(iPredicate3);
        if (object2 != null) {
            if (this.mDeprecatedPredicates.containsKey(object2)) {
                object2 = this.mDeprecatedPredicates.get(object2);
            }
            this.mPredicateUnifierBenchmarkGenerator.incrementSyntacticMatches();
            this.mPredicateUnifierBenchmarkGenerator.stopTime();
            return object2;
        }
        object2 = new PredicateComparison((Term)iPredicate3, termVarsFuns.getVars(), hashMap, hashMap2);
        if (((PredicateComparison)object2).isEquivalentToExistingPredicateWithLeqQuantifiers()) {
            this.mPredicateUnifierBenchmarkGenerator.incrementSemanticMatches();
            this.mPredicateUnifierBenchmarkGenerator.stopTime();
            return ((PredicateComparison)object2).getEquivalantLeqQuantifiedPredicate();
        }
        assert (!SmtUtils.isTrueLiteral((Term)iPredicate3)) : "illegal predicate: true";
        assert (!SmtUtils.isFalseLiteral((Term)iPredicate3)) : "illegal predicate: false";
        assert (!this.mTerm2Predicates.containsKey(iPredicate3));
        if (((PredicateComparison)object2).isIntricatePredicate()) {
            iPredicate2 = iPredicate3;
        } else {
            try {
                object = SmtUtils.simplify((ManagedScript)this.mMgdScript, (Term)iPredicate3, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
                iPredicate2 = new CommuhashNormalForm(this.mServices, this.mScript).transform((Term)object);
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "unifying predicates"));
                throw toolchainCanceledException;
            }
        }
        object = (IPredicate)unaryOperator.apply(this.constructNewPredicate((Term)iPredicate2, iPredicate));
        if (((PredicateComparison)object2).isEquivalentToExistingPredicatesWithGtQuantifiers()) {
            for (IPredicate iPredicate4 : ((PredicateComparison)object2).getEquivalantGtQuantifiedPredicates()) {
                this.mDeprecatedPredicates.put(iPredicate4, (IPredicate)object);
            }
            this.mPredicateUnifierBenchmarkGenerator.incrementDeprecatedPredicates();
        }
        this.addNewPredicate((IPredicate)object, term, (Term)iPredicate2, ((PredicateComparison)object2).getImpliedPredicates(), ((PredicateComparison)object2).getExpliedPredicates());
        assert (new CheckClosedTerm().isClosed(object.getClosedFormula()));
        assert (this.varsIsSupersetOfFreeTermVariables(object.getFormula(), object.getVars()));
        this.mPredicateUnifierBenchmarkGenerator.incrementConstructedPredicates();
        this.mPredicateUnifierBenchmarkGenerator.stopTime();
        return object;
    }

    protected IPredicate constructNewPredicate(Term term, IPredicate iPredicate) {
        return this.mPredicateFactory.newPredicate(term);
    }

    private static Term stripAnnotation(Term term) {
        Term term2;
        if (term instanceof AnnotatedTerm) {
            AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
            Annotation[] annotationArray = annotatedTerm.getAnnotations();
            if (annotationArray.length != 1 || !":quoted".equals(annotationArray[0].getKey())) {
                throw new UnsupportedOperationException();
            }
            term2 = annotatedTerm.getSubterm();
        } else {
            term2 = term;
        }
        return term2;
    }

    private void addNewPredicate(IPredicate iPredicate, Term term, Term term2, Map<IPredicate, IncrementalPlicationChecker.Validity> map, Map<IPredicate, IncrementalPlicationChecker.Validity> map2) {
        this.mTerm2Predicates.put(term, iPredicate);
        this.mTerm2Predicates.put(term2, iPredicate);
        this.mCoverageRelation.addPredicate(iPredicate, map, map2);
        assert (!this.mKnownPredicates.contains(iPredicate)) : "predicate already known";
        this.mKnownPredicates.add(iPredicate);
    }

    private static boolean thisIsLessQuantifiedThanOther(Term term, Term term2) {
        ContainsQuantifier containsQuantifier = new ContainsQuantifier();
        containsQuantifier.containsQuantifier(term);
        ContainsQuantifier containsQuantifier2 = new ContainsQuantifier();
        containsQuantifier2.containsQuantifier(term2);
        return containsQuantifier.getFirstQuantifierFound() == 1 && containsQuantifier2.getFirstQuantifierFound() == 0;
    }

    @Override
    public String collectPredicateUnifierStatistics() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PredicateUnifierStatisticsGenerator.PredicateUnifierStatisticsType.getInstance().prettyprintBenchmarkData(this.mPredicateUnifierBenchmarkGenerator));
        stringBuilder.append(this.mCoverageRelation.getCoverageRelationStatistics());
        return stringBuilder.toString();
    }

    @Override
    public boolean isIntricatePredicate(IPredicate iPredicate) {
        IncrementalPlicationChecker.Validity validity = this.getCoverageRelation().isCovered(this.mTruePredicate, iPredicate);
        IncrementalPlicationChecker.Validity validity2 = this.getCoverageRelation().isCovered(iPredicate, this.mFalsePredicate);
        return validity == IncrementalPlicationChecker.Validity.UNKNOWN || validity2 == IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public Set<IPredicate> cannibalize(boolean bl, Term term) {
        Term[] termArray = SmtUtils.cannibalize((ManagedScript)this.mMgdScript, (IUltimateServiceProvider)this.mServices, (boolean)bl, (Term)term);
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray2[n2];
            IPredicate iPredicate = this.getOrConstructPredicate(term2);
            hashSet.add(iPredicate);
            ++n2;
        }
        return hashSet;
    }

    @Override
    public Set<IPredicate> cannibalizeAll(boolean bl, Collection<IPredicate> collection) {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (IPredicate iPredicate : collection) {
            hashSet.addAll(this.cannibalize(bl, iPredicate.getFormula()));
        }
        return hashSet;
    }

    @Override
    public IPredicateCoverageChecker getCoverageRelation() {
        return this.mCoverageRelation;
    }

    @Override
    public IStatisticsDataProvider getPredicateUnifierBenchmark() {
        return this.mPredicateUnifierBenchmarkGenerator;
    }

    @Override
    public BasicPredicateFactory getPredicateFactory() {
        return this.mPredicateFactory;
    }

    @Override
    public IPredicate constructNewPredicate(Term term, Map<IPredicate, IncrementalPlicationChecker.Validity> map, Map<IPredicate, IncrementalPlicationChecker.Validity> map2) {
        if (this.mTerm2Predicates.get(term) != null) {
            throw new AssertionError((Object)("PredicateUnifier already knows a predicate for " + String.valueOf(term)));
        }
        if (map.size() != this.mKnownPredicates.size()) {
            throw new AssertionError((Object)"Inconsistent number of IPredicates known by PredicateUnifier and number of provided implications");
        }
        if (map2.size() != this.mKnownPredicates.size()) {
            throw new AssertionError((Object)"Inconsistent number of IPredicates known by PredicateUnifier and number of provided explications");
        }
        IPredicate iPredicate = this.constructNewPredicate(term, null);
        this.addNewPredicate(iPredicate, term, term, map, map2);
        this.mPredicateUnifierBenchmarkGenerator.incrementDeclaredPredicates();
        return iPredicate;
    }

    public class CoverageRelation
    implements IPredicateCoverageChecker {
        private final NestedMap2<IPredicate, IPredicate, IncrementalPlicationChecker.Validity> mLhs2RhsValidity = new NestedMap2();
        private final HashRelation<IPredicate, IPredicate> mImpliedPredicates = new HashRelation();
        private final HashRelation<IPredicate, IPredicate> mExpliedPredicates = new HashRelation();
        private final HashRelation<IPredicate, IPredicate> mNotImpliedPredicates = new HashRelation();
        private final HashRelation<IPredicate, IPredicate> mNotExpliedPredicates = new HashRelation();

        void addPredicate(IPredicate iPredicate, Map<IPredicate, IncrementalPlicationChecker.Validity> map, Map<IPredicate, IncrementalPlicationChecker.Validity> map2) {
            assert (!PredicateUnifier.this.mKnownPredicates.contains(iPredicate)) : "predicate already known";
            assert (this.coverageMapIsComplete());
            for (IPredicate iPredicate2 : PredicateUnifier.this.mKnownPredicates) {
                IncrementalPlicationChecker.Validity validity = map.get(iPredicate2);
                assert (validity != null) : "unknown implies for " + String.valueOf(iPredicate2);
                IncrementalPlicationChecker.Validity validity2 = map2.get(iPredicate2);
                assert (validity2 != null) : "unknown explies for " + String.valueOf(iPredicate2);
                IncrementalPlicationChecker.Validity validity3 = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.put((Object)iPredicate, (Object)iPredicate2, (Object)validity);
                assert (validity3 == null) : "entry existed !";
                IncrementalPlicationChecker.Validity validity4 = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.put((Object)iPredicate2, (Object)iPredicate, (Object)validity2);
                assert (validity4 == null) : "entry existed !";
                if (validity == IncrementalPlicationChecker.Validity.VALID) {
                    this.mImpliedPredicates.addPair((Object)iPredicate, (Object)iPredicate2);
                    this.mExpliedPredicates.addPair((Object)iPredicate2, (Object)iPredicate);
                } else if (validity == IncrementalPlicationChecker.Validity.INVALID) {
                    this.mNotImpliedPredicates.addPair((Object)iPredicate, (Object)iPredicate2);
                    this.mNotExpliedPredicates.addPair((Object)iPredicate2, (Object)iPredicate);
                }
                if (validity2 == IncrementalPlicationChecker.Validity.VALID) {
                    this.mImpliedPredicates.addPair((Object)iPredicate2, (Object)iPredicate);
                    this.mExpliedPredicates.addPair((Object)iPredicate, (Object)iPredicate2);
                    continue;
                }
                if (validity != IncrementalPlicationChecker.Validity.INVALID) continue;
                this.mNotImpliedPredicates.addPair((Object)iPredicate2, (Object)iPredicate);
                this.mNotExpliedPredicates.addPair((Object)iPredicate, (Object)iPredicate2);
            }
            this.mImpliedPredicates.addPair((Object)iPredicate, (Object)iPredicate);
            this.mExpliedPredicates.addPair((Object)iPredicate, (Object)iPredicate);
            assert (this.coverageMapIsComplete());
        }

        @Override
        public IncrementalPlicationChecker.Validity isCovered(IPredicate iPredicate, IPredicate iPredicate2) {
            if (iPredicate.equals(iPredicate2)) {
                return IncrementalPlicationChecker.Validity.VALID;
            }
            IncrementalPlicationChecker.Validity validity = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.get((Object)iPredicate, (Object)iPredicate2);
            if (validity == null) {
                throw new AssertionError((Object)("at least one of both input predicates is unknown: " + String.valueOf(iPredicate) + " or " + String.valueOf(iPredicate2)));
            }
            return validity;
        }

        @Override
        public Set<IPredicate> getCoveringPredicates(IPredicate iPredicate) {
            return this.mImpliedPredicates.getImage((Object)iPredicate);
        }

        public Set<IPredicate> getNonCoveringPredicates(IPredicate iPredicate) {
            return this.mNotImpliedPredicates.getImage((Object)iPredicate);
        }

        @Override
        public Set<IPredicate> getCoveredPredicates(IPredicate iPredicate) {
            return this.mExpliedPredicates.getImage((Object)iPredicate);
        }

        public Set<IPredicate> getNonCoveredPredicates(IPredicate iPredicate) {
            return this.mNotExpliedPredicates.getImage((Object)iPredicate);
        }

        public CoverageRelationStatistics getCoverageRelationStatistics() {
            return new CoverageRelationStatistics(this.mLhs2RhsValidity);
        }

        private boolean coverageMapIsComplete() {
            boolean bl = true;
            for (IPredicate iPredicate : PredicateUnifier.this.mKnownPredicates) {
                for (IPredicate iPredicate2 : PredicateUnifier.this.mKnownPredicates) {
                    if (iPredicate == iPredicate2) continue;
                    IncrementalPlicationChecker.Validity validity = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.get((Object)iPredicate, (Object)iPredicate2);
                    assert (validity != null) : "value missing for pair " + String.valueOf(iPredicate) + ", " + String.valueOf(iPredicate2);
                    if (validity != null) continue;
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public IPartialComparator<IPredicate> getPartialComparator() {
            return (iPredicate, iPredicate2) -> {
                IncrementalPlicationChecker.Validity validity;
                if (iPredicate.equals(iPredicate2)) {
                    return IPartialComparator.ComparisonResult.EQUAL;
                }
                IncrementalPlicationChecker.Validity validity2 = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.get(iPredicate, iPredicate2);
                if (validity2 == null) {
                    this.throwAssertionErrorWithMessage((IPredicate)iPredicate, (IPredicate)iPredicate2);
                }
                if ((validity = (IncrementalPlicationChecker.Validity)this.mLhs2RhsValidity.get(iPredicate2, iPredicate)) == null) {
                    this.throwAssertionErrorWithMessage((IPredicate)iPredicate, (IPredicate)iPredicate2);
                }
                if (validity2 == IncrementalPlicationChecker.Validity.VALID) {
                    if (validity == IncrementalPlicationChecker.Validity.VALID) {
                        return IPartialComparator.ComparisonResult.EQUAL;
                    }
                    return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
                }
                if (validity == IncrementalPlicationChecker.Validity.VALID) {
                    return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
                }
                return IPartialComparator.ComparisonResult.INCOMPARABLE;
            };
        }

        private void throwAssertionErrorWithMessage(IPredicate iPredicate, IPredicate iPredicate2) throws AssertionError {
            if (!this.mLhs2RhsValidity.keySet().contains(iPredicate)) {
                throw new AssertionError((Object)("PredicateUnifier does not know the following predicate " + String.valueOf(iPredicate)));
            }
            if (!this.mLhs2RhsValidity.keySet().contains(iPredicate2)) {
                throw new AssertionError((Object)("PredicateUnifier does not know the following predicate " + String.valueOf(iPredicate2)));
            }
            throw new AssertionError((Object)"PredicateUnifier is in inconsistent state");
        }

        @Override
        public HashRelation<IPredicate, IPredicate> getCopyOfImplicationRelation() {
            return new HashRelation(this.mImpliedPredicates);
        }
    }

    public static class CoverageRelationStatistics {
        private final int mValidCoverageRelations;
        private final int mInvalidCoverageRelations;
        private final int mUnknownCoverageRelations;
        private final int mNotCheckedCoverageRelations;

        public CoverageRelationStatistics(NestedMap2<IPredicate, IPredicate, IncrementalPlicationChecker.Validity> nestedMap2) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (Triple triple : nestedMap2.entrySet()) {
                switch ((IncrementalPlicationChecker.Validity)triple.getThird()) {
                    case INVALID: {
                        ++n;
                        break;
                    }
                    case NOT_CHECKED: {
                        ++n4;
                        break;
                    }
                    case UNKNOWN: {
                        ++n3;
                        break;
                    }
                    case VALID: {
                        ++n2;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            this.mValidCoverageRelations = n2;
            this.mInvalidCoverageRelations = n;
            this.mUnknownCoverageRelations = n3;
            this.mNotCheckedCoverageRelations = n4;
        }

        public String toString() {
            return String.format("CoverageRelationStatistics Valid=%s, Invalid=%s, Unknown=%s, NotChecked=%s, Total=%s", this.mValidCoverageRelations, this.mInvalidCoverageRelations, this.mUnknownCoverageRelations, this.mNotCheckedCoverageRelations, this.mValidCoverageRelations + this.mInvalidCoverageRelations + this.mUnknownCoverageRelations + this.mNotCheckedCoverageRelations);
        }
    }

    private final class PredicateComparison {
        private final Term mTerm;
        private final Term mClosedTerm;
        private final boolean mTermContainsQuantifiers;
        private final HashMap<IPredicate, IncrementalPlicationChecker.Validity> mImpliedPredicates;
        private final HashMap<IPredicate, IncrementalPlicationChecker.Validity> mExpliedPredicates;
        private final IPredicate mEquivalentLeqQuantifiedPredicate;
        private final Set<IPredicate> mEquivalentGtQuantifiedPredicates;
        private boolean mIsIntricatePredicate;

        PredicateComparison(Term term, Set<IProgramVar> set, HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap, HashMap<IPredicate, IncrementalPlicationChecker.Validity> hashMap2) {
            if (hashMap == null) {
                if (hashMap2 != null) {
                    throw new IllegalArgumentException("both or none null");
                }
                this.mImpliedPredicates = new HashMap();
                this.mExpliedPredicates = new HashMap();
            } else {
                this.mImpliedPredicates = hashMap;
                this.mExpliedPredicates = hashMap2;
            }
            this.mTerm = term;
            this.mClosedTerm = PredicateUtils.computeClosedFormula(term, set, PredicateUnifier.this.mMgdScript);
            this.mTermContainsQuantifiers = !QuantifierUtils.isQuantifierFree((Term)term);
            this.mEquivalentGtQuantifiedPredicates = new HashSet<IPredicate>();
            PredicateUnifier.this.mScript.echo(new QuotedObject("begin unification"));
            this.mEquivalentLeqQuantifiedPredicate = this.compare();
            PredicateUnifier.this.mScript.echo(new QuotedObject("end unification"));
        }

        public Term getClosedTerm() {
            if (this.mEquivalentLeqQuantifiedPredicate != null) {
                throw new IllegalAccessError("not accessible, we found an equivalent predicate");
            }
            return this.mClosedTerm;
        }

        public HashMap<IPredicate, IncrementalPlicationChecker.Validity> getImpliedPredicates() {
            if (this.mEquivalentLeqQuantifiedPredicate != null) {
                throw new IllegalAccessError("not accessible, we found an equivalent predicate");
            }
            return this.mImpliedPredicates;
        }

        public HashMap<IPredicate, IncrementalPlicationChecker.Validity> getExpliedPredicates() {
            if (this.mEquivalentLeqQuantifiedPredicate != null) {
                throw new IllegalAccessError("not accessible, we found an equivalent predicate");
            }
            return this.mExpliedPredicates;
        }

        public IPredicate getEquivalantLeqQuantifiedPredicate() {
            if (this.mEquivalentLeqQuantifiedPredicate == null) {
                throw new IllegalAccessError("accessible only if equivalent to existing predicate");
            }
            return this.mEquivalentLeqQuantifiedPredicate;
        }

        public Set<IPredicate> getEquivalantGtQuantifiedPredicates() {
            if (this.mEquivalentGtQuantifiedPredicates.isEmpty()) {
                throw new IllegalAccessError("accessible only if equivalent to existing predicate");
            }
            return this.mEquivalentGtQuantifiedPredicates;
        }

        public boolean isIntricatePredicate() {
            if (this.mEquivalentLeqQuantifiedPredicate != null) {
                throw new IllegalAccessError("not accessible, we found an equivalent predicate");
            }
            return this.mIsIntricatePredicate;
        }

        public boolean isEquivalentToExistingPredicateWithLeqQuantifiers() {
            return this.mEquivalentLeqQuantifiedPredicate != null;
        }

        public boolean isEquivalentToExistingPredicatesWithGtQuantifiers() {
            return !this.mEquivalentGtQuantifiedPredicates.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        private IPredicate compare() {
            IncrementalPlicationChecker.Validity validity = PredicateUnifier.this.mImplicationChecker.checkImplication(this.mTerm, this.mClosedTerm, false, PredicateUnifier.this.mFalsePredicate.getFormula(), PredicateUnifier.this.mFalsePredicate.getClosedFormula(), false);
            switch (validity) {
                case VALID: {
                    return PredicateUnifier.this.mFalsePredicate;
                }
                case INVALID: {
                    this.mImpliedPredicates.put(PredicateUnifier.this.mFalsePredicate, IncrementalPlicationChecker.Validity.INVALID);
                    break;
                }
                case UNKNOWN: {
                    PredicateUnifier.this.mLogger.warn((Object)new DebugMessage("unable to prove that {0} is different from false", new Object[]{this.mClosedTerm}));
                    this.mImpliedPredicates.put(PredicateUnifier.this.mFalsePredicate, IncrementalPlicationChecker.Validity.UNKNOWN);
                    this.mIsIntricatePredicate = true;
                    break;
                }
                case NOT_CHECKED: {
                    throw new AssertionError((Object)"we wanted it checked");
                }
                default: {
                    throw new AssertionError((Object)"unknown case");
                }
            }
            this.mExpliedPredicates.put(PredicateUnifier.this.mFalsePredicate, IncrementalPlicationChecker.Validity.VALID);
            IncrementalPlicationChecker.Validity validity2 = PredicateUnifier.this.mImplicationChecker.checkImplication(PredicateUnifier.this.mTruePredicate.getFormula(), PredicateUnifier.this.mTruePredicate.getClosedFormula(), false, this.mTerm, this.mClosedTerm, false);
            switch (validity2) {
                case VALID: {
                    return PredicateUnifier.this.mTruePredicate;
                }
                case INVALID: {
                    this.mExpliedPredicates.put(PredicateUnifier.this.mTruePredicate, IncrementalPlicationChecker.Validity.INVALID);
                    break;
                }
                case UNKNOWN: {
                    PredicateUnifier.this.mLogger.warn((Object)new DebugMessage("unable to prove that {0} is different from true", new Object[]{this.mClosedTerm}));
                    this.mExpliedPredicates.put(PredicateUnifier.this.mTruePredicate, IncrementalPlicationChecker.Validity.UNKNOWN);
                    this.mIsIntricatePredicate = true;
                    break;
                }
                case NOT_CHECKED: {
                    throw new AssertionError((Object)"we wanted it checked");
                }
                default: {
                    throw new AssertionError((Object)"unknown case");
                }
            }
            this.mImpliedPredicates.put(PredicateUnifier.this.mTruePredicate, IncrementalPlicationChecker.Validity.VALID);
            if (this.mIsIntricatePredicate) {
                for (IPredicate iPredicate : PredicateUnifier.this.mKnownPredicates) {
                    if (iPredicate == PredicateUnifier.this.mTruePredicate || iPredicate == PredicateUnifier.this.mFalsePredicate) continue;
                    this.mImpliedPredicates.put(iPredicate, IncrementalPlicationChecker.Validity.NOT_CHECKED);
                    this.mExpliedPredicates.put(iPredicate, IncrementalPlicationChecker.Validity.NOT_CHECKED);
                }
                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementIntricatePredicates();
                return null;
            }
            for (IPredicate iPredicate : PredicateUnifier.this.mKnownPredicates) {
                boolean bl;
                void object2;
                IncrementalPlicationChecker.Validity validity3;
                if (iPredicate == PredicateUnifier.this.mTruePredicate || iPredicate == PredicateUnifier.this.mFalsePredicate) continue;
                if (PredicateUnifier.this.isIntricatePredicate(iPredicate)) {
                    this.mImpliedPredicates.put(iPredicate, IncrementalPlicationChecker.Validity.NOT_CHECKED);
                    this.mExpliedPredicates.put(iPredicate, IncrementalPlicationChecker.Validity.NOT_CHECKED);
                    continue;
                }
                this.checkTimeout(this.mClosedTerm);
                Term term = iPredicate.getClosedFormula();
                IncrementalPlicationChecker.Validity validity32 = this.mImpliedPredicates.get(iPredicate);
                if (validity32 == null) {
                    validity32 = PredicateUnifier.this.mImplicationChecker.checkImplication(this.mTerm, this.mClosedTerm, false, iPredicate.getFormula(), iPredicate.getClosedFormula(), false);
                    if (validity32 == IncrementalPlicationChecker.Validity.VALID) {
                        for (IPredicate iPredicate2 : PredicateUnifier.this.getCoverageRelation().getCoveringPredicates(iPredicate)) {
                            if (iPredicate2 == iPredicate) continue;
                            var9_22 = this.mImpliedPredicates.put(iPredicate2, IncrementalPlicationChecker.Validity.VALID);
                            if (var9_22 == null || var9_22 == IncrementalPlicationChecker.Validity.UNKNOWN) {
                                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementImplicationChecksByTransitivity();
                                continue;
                            }
                            assert (var9_22 == IncrementalPlicationChecker.Validity.VALID) : "implication result by transitivity: " + String.valueOf(IncrementalPlicationChecker.Validity.VALID) + " old implication result: " + String.valueOf(var9_22);
                        }
                    } else if (validity32 == IncrementalPlicationChecker.Validity.INVALID) {
                        for (IPredicate iPredicate3 : PredicateUnifier.this.getCoverageRelation().getCoveredPredicates(iPredicate)) {
                            if (iPredicate3 == iPredicate) continue;
                            var9_22 = this.mImpliedPredicates.put(iPredicate3, IncrementalPlicationChecker.Validity.INVALID);
                            if (var9_22 == null || var9_22 == IncrementalPlicationChecker.Validity.UNKNOWN) {
                                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementImplicationChecksByTransitivity();
                                continue;
                            }
                            assert (var9_22 == IncrementalPlicationChecker.Validity.INVALID) : "implication result by transitivity: " + String.valueOf(IncrementalPlicationChecker.Validity.INVALID) + " old implication result: " + String.valueOf(var9_22);
                        }
                    }
                    this.mImpliedPredicates.put(iPredicate, validity32);
                }
                if ((validity3 = this.mExpliedPredicates.get(iPredicate)) == null) {
                    IncrementalPlicationChecker.Validity validity4 = PredicateUnifier.this.mImplicationChecker.checkImplication(iPredicate.getFormula(), iPredicate.getClosedFormula(), false, this.mTerm, this.mClosedTerm, false);
                    if (validity4 == IncrementalPlicationChecker.Validity.VALID) {
                        for (IPredicate iPredicate4 : PredicateUnifier.this.getCoverageRelation().getCoveredPredicates(iPredicate)) {
                            if (iPredicate4 == iPredicate) continue;
                            var10_23 = this.mExpliedPredicates.put(iPredicate4, IncrementalPlicationChecker.Validity.VALID);
                            if (var10_23 == null || var10_23 == IncrementalPlicationChecker.Validity.UNKNOWN) {
                                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementImplicationChecksByTransitivity();
                                continue;
                            }
                            assert (var10_23 == IncrementalPlicationChecker.Validity.VALID) : "explication result by transitivity: " + String.valueOf(IncrementalPlicationChecker.Validity.VALID) + " old explication result: " + String.valueOf(var10_23);
                        }
                    } else if (validity4 == IncrementalPlicationChecker.Validity.INVALID) {
                        for (IPredicate iPredicate5 : PredicateUnifier.this.getCoverageRelation().getCoveringPredicates(iPredicate)) {
                            if (iPredicate5 == iPredicate) continue;
                            var10_23 = this.mExpliedPredicates.put(iPredicate5, IncrementalPlicationChecker.Validity.INVALID);
                            if (var10_23 == null || var10_23 == IncrementalPlicationChecker.Validity.UNKNOWN) {
                                PredicateUnifier.this.mPredicateUnifierBenchmarkGenerator.incrementImplicationChecksByTransitivity();
                                continue;
                            }
                            assert (var10_23 == IncrementalPlicationChecker.Validity.INVALID) : "explication result by transitivity: " + String.valueOf(IncrementalPlicationChecker.Validity.INVALID) + " old explication result: " + String.valueOf(var10_23);
                        }
                    }
                    this.mExpliedPredicates.put(iPredicate, validity4);
                }
                if (validity32 != IncrementalPlicationChecker.Validity.VALID || object2 != IncrementalPlicationChecker.Validity.VALID) continue;
                if (PredicateUnifier.this.mDeprecatedPredicates.containsKey(iPredicate)) {
                    return PredicateUnifier.this.mDeprecatedPredicates.get(iPredicate);
                }
                boolean bl2 = bl = !QuantifierUtils.isQuantifierFree((Term)iPredicate.getFormula());
                if (!bl || this.mTermContainsQuantifiers && !PredicateUnifier.thisIsLessQuantifiedThanOther(this.mClosedTerm, term)) {
                    return iPredicate;
                }
                this.mEquivalentGtQuantifiedPredicates.add(iPredicate);
            }
            return null;
        }

        private void checkTimeout(Term term) {
            if (!PredicateUnifier.this.mServices.getProgressMonitorService().continueProcessing()) {
                String string = this.generateQuantifierInformation(term);
                throw new ToolchainCanceledException(this.getClass(), "comparing new predicate (" + string + ") to " + PredicateUnifier.this.mKnownPredicates.size() + " known predicates");
            }
        }

        private String generateQuantifierInformation(Term term) {
            Object object;
            Term term2 = new PrenexNormalForm(PredicateUnifier.this.mMgdScript).transform(term);
            if (term2 instanceof QuantifiedFormula) {
                QuantifierSequence quantifierSequence = new QuantifierSequence(PredicateUnifier.this.mMgdScript, term2);
                object = "quantified with " + (quantifierSequence.getNumberOfQuantifierBlocks() - 1) + "quantifier alternations";
            } else {
                object = "quantifier-free";
            }
            return object;
        }
    }
}

