/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.predicates.IterativePredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.DefaultTransFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetaTraceTransformer<L extends IIcfgTransition<?>> {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final List<L> mCounterexample;
    private final IPredicateUnifier mPredUnifier;
    private final IUltimateServiceProvider mServices;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPredTransformer;
    private final CfgSmtToolkit mToolkit;
    private final Map<IIcfgCallTransition<?>, IPredicate> mCallPred;

    public MetaTraceTransformer(ILogger iLogger, ManagedScript managedScript, List<L> list, IPredicateUnifier iPredicateUnifier, IUltimateServiceProvider iUltimateServiceProvider, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, CfgSmtToolkit cfgSmtToolkit) {
        this.mLogger = iLogger;
        this.mScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mCounterexample = list;
        this.mPredUnifier = iPredicateUnifier;
        this.mPredTransformer = predicateTransformer;
        this.mToolkit = cfgSmtToolkit;
        this.mCallPred = new HashMap();
    }

    public IPredicate[] getInductiveLoopInterpolants(IPredicate[] iPredicateArray, Map<IcfgLocation, List<UnmodifiableTransFormula>> map, Map<IcfgLocation, Pair<Integer, Integer>> map2, MetaTraceApplicationMethod metaTraceApplicationMethod) {
        MetaTraceApplicationMethod metaTraceApplicationMethod2 = metaTraceApplicationMethod;
        IPredicate[] iPredicateArray2 = new IPredicate[this.mCounterexample.size() - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < iPredicateArray2.length) {
            IcfgLocation icfgLocation = ((IIcfgTransition)this.mCounterexample.get(n2)).getTarget();
            if (map.containsKey(icfgLocation)) {
                Object object;
                IPredicate iPredicate;
                Term term;
                var10_10 = map2.get(icfgLocation);
                var11_11 = new ArrayList((Collection)map.get(icfgLocation));
                var12_12 = new ArrayList();
                int n3 = 2 * var11_11.size();
                if (var11_11.size() > 1) {
                    int n4 = n;
                    int n5 = 0;
                    while (n4 < n3 + n) {
                        var17_19 = iPredicateArray[n4];
                        UnmodifiableTransFormula unmodifiableTransFormula = (UnmodifiableTransFormula)var11_11.get(n5);
                        Term term2 = (Term)this.mPredTransformer.strongestPostcondition((IAbstractPredicate)var17_19, (ITransitionRelation)unmodifiableTransFormula);
                        var12_12.add(term2);
                        ++n5;
                        n4 += 3;
                    }
                    term = SmtUtils.and((Script)this.mScript.getScript(), (Collection)var12_12);
                } else {
                    iPredicate = iPredicateArray[n];
                    object = (UnmodifiableTransFormula)var11_11.get(0);
                    var17_19 = (Term)this.mPredTransformer.strongestPostcondition((IAbstractPredicate)iPredicate, (ITransitionRelation)object);
                    term = var17_19;
                }
                n = n + n3 - 1;
                term = SmtUtils.simplify((ManagedScript)this.mScript, (Term)term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
                iPredicateArray2[n2] = iPredicate = this.mPredUnifier.getOrConstructPredicate(term);
                object = ++n2 + (Integer)var10_10.getSecond() - (Integer)var10_10.getFirst();
                switch (metaTraceApplicationMethod2) {
                    case ONLY_AT_FIRST_LOOP_ENTRY: {
                        iPredicateArray2 = this.getInductiveFirstEntryOnlyPost(iPredicateArray2, n2, (Integer)object);
                        break;
                    }
                    case INVARIANT: {
                        iPredicateArray2 = this.getInductiveInvariant(iPredicateArray2, n2, (Integer)object);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                n2 = (Integer)object - 1;
            } else {
                if (SmtUtils.isFalseLiteral((Term)iPredicateArray[n].getFormula()) && n2 != 0) {
                    var11_11 = iPredicateArray2[n2 - 1];
                    var12_12 = (Term)this.mPredTransformer.strongestPostcondition((IAbstractPredicate)var11_11, (ITransitionRelation)((IIcfgTransition)this.mCounterexample.get(n2)).getTransformula());
                    var10_10 = this.mPredUnifier.getOrConstructPredicate(var12_12);
                } else {
                    var10_10 = iPredicateArray[n];
                }
                iPredicateArray2[n2] = var10_10;
            }
            ++n;
            ++n2;
        }
        return iPredicateArray2;
    }

    private IPredicate[] getInductiveFirstEntryOnlyIterativePredTransformer(IPredicate[] iPredicateArray, Integer n, Integer n2, IPredicate iPredicate, IPredicate iPredicate2) {
        List<L> list = this.mCounterexample.subList(n, n2);
        NestedWord nestedWord = TraceCheckUtils.toNestedWord(list);
        DefaultTransFormulas defaultTransFormulas = new DefaultTransFormulas((Word)nestedWord, iPredicate, iPredicate2, Collections.emptySortedMap(), this.mToolkit.getOldVarsAssignmentCache(), false);
        IterativePredicateTransformer iterativePredicateTransformer = new IterativePredicateTransformer(this.mPredUnifier.getPredicateFactory(), this.mScript, this.mToolkit.getModifiableGlobalsTable(), this.mServices, nestedWord, iPredicate, iPredicate2, Collections.emptySortedMap(), this.mPredUnifier.getTruePredicate(), SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, this.mToolkit.getSymbolTable());
        List list2 = iterativePredicateTransformer.computeStrongestPostconditionSequence((NestedFormulas)defaultTransFormulas, Collections.emptyList()).getPredicates();
        int n3 = n + 1;
        iPredicateArray[n.intValue()] = iPredicate;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            IPredicate iPredicate3;
            iPredicateArray[n3] = iPredicate3 = (IPredicate)iterator.next();
            ++n3;
        }
        iPredicateArray[n2.intValue()] = iPredicate2;
        return iPredicateArray;
    }

    private IPredicate[] getInductiveFirstEntryOnlyPost(IPredicate[] iPredicateArray, Integer n, Integer n2) {
        int n3 = n;
        while (n3 < n2) {
            Term term;
            Object object;
            UnmodifiableTransFormula unmodifiableTransFormula;
            IIcfgCallTransition iIcfgCallTransition;
            IIcfgTransition iIcfgTransition = (IIcfgTransition)this.mCounterexample.get(n3);
            IPredicate iPredicate = iPredicateArray[n3 - 1];
            UnmodifiableTransFormula unmodifiableTransFormula2 = iIcfgTransition.getTransformula();
            if (iIcfgTransition instanceof IIcfgCallTransition) {
                iIcfgCallTransition = (IIcfgCallTransition)iIcfgTransition;
                unmodifiableTransFormula = iIcfgCallTransition.getLocalVarsAssignment();
                object = this.mToolkit.getOldVarsAssignmentCache().getGlobalVarsAssignment(iIcfgCallTransition.getSucceedingProcedure());
                UnmodifiableTransFormula unmodifiableTransFormula3 = this.mToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(iIcfgCallTransition.getSucceedingProcedure());
                Set set = this.mToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(iIcfgCallTransition.getSucceedingProcedure());
                term = (Term)this.mPredTransformer.strongestPostconditionCall((IAbstractPredicate)iPredicate, (ITransitionRelation)unmodifiableTransFormula, (ITransitionRelation)object, (ITransitionRelation)unmodifiableTransFormula3, set);
                this.mCallPred.put(iIcfgCallTransition, this.mPredUnifier.getOrConstructPredicate(term));
                this.mLogger.debug((Object)"Dealt with Call");
            }
            if (iIcfgTransition instanceof IIcfgReturnTransition) {
                iIcfgCallTransition = (IIcfgReturnTransition)iIcfgTransition;
                unmodifiableTransFormula = this.mToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(iIcfgCallTransition.getPrecedingProcedure());
                object = this.mToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(iIcfgCallTransition.getPrecedingProcedure());
                term = (Term)this.mPredTransformer.strongestPostconditionReturn((IAbstractPredicate)iPredicate, (IAbstractPredicate)this.mPredUnifier.getTruePredicate(), (ITransitionRelation)iIcfgCallTransition.getTransformula(), (ITransitionRelation)iIcfgCallTransition.getCorrespondingCall().getTransformula(), (ITransitionRelation)unmodifiableTransFormula, (Set)object);
                this.mLogger.debug((Object)"Dealt with Return");
            } else {
                term = (Term)this.mPredTransformer.strongestPostcondition((IAbstractPredicate)iPredicate, (ITransitionRelation)unmodifiableTransFormula2);
            }
            iPredicateArray[n3] = this.mPredUnifier.getOrConstructPredicate(term);
            this.mLogger.debug((Object)"Generated Interpolant");
            ++n3;
        }
        return iPredicateArray;
    }

    private IPredicate[] getInductiveInvariant(IPredicate[] iPredicateArray, Integer n, Integer n2) {
        IPredicate iPredicate = iPredicateArray[n - 1];
        int n3 = n;
        while (n3 < n2) {
            iPredicateArray[n3] = this.mPredUnifier.getOrConstructPredicate(iPredicate);
            ++n3;
        }
        return iPredicateArray;
    }

    public static enum MetaTraceApplicationMethod {
        ONLY_AT_FIRST_LOOP_ENTRY,
        ON_EACH_LOOP_ENTRY,
        INVARIANT;

    }
}

