/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DataRaceAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithFiniteTrace;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DataRaceFoundResult<ELEM extends IElement, TE extends IElement, E>
extends AbstractResultAtElement<ELEM>
implements IResultWithFiniteTrace<TE, E> {
    private final IProgramExecution<TE, E> mProgramExecution;
    private final String mProgramExecutionAsString;
    private final List<ILocation> mFailurePath;
    private final DataRaceAnnotation mRaceAnnotation;
    private final HashRelation<DataRaceAnnotation.Race, DataRaceAnnotation.Race> mPossibleConflicts;

    public DataRaceFoundResult(ELEM ELEM, String string, IBacktranslationService iBacktranslationService, IProgramExecution<TE, E> iProgramExecution) {
        super(ELEM, string);
        this.mRaceAnnotation = DataRaceAnnotation.getAnnotation(ELEM);
        assert (this.mRaceAnnotation != null);
        this.mPossibleConflicts = this.findPossibleViolations(this.mRaceAnnotation, iProgramExecution);
        assert (this.mPossibleConflicts.size() > 0);
        this.mProgramExecution = iProgramExecution;
        this.mProgramExecutionAsString = iBacktranslationService.translateProgramExecution(this.mProgramExecution).toString();
        this.mFailurePath = ResultUtil.getLocationSequence(iProgramExecution);
    }

    private HashRelation<DataRaceAnnotation.Race, DataRaceAnnotation.Race> findPossibleViolations(DataRaceAnnotation dataRaceAnnotation, IProgramExecution<TE, E> iProgramExecution) {
        HashRelation hashRelation = new HashRelation();
        int n = iProgramExecution.getLength() - 2;
        while (n >= 0) {
            DataRaceAnnotation dataRaceAnnotation2 = DataRaceAnnotation.getAnnotation((IElement)iProgramExecution.getTraceElement(n).getStep());
            if (dataRaceAnnotation2 != null) {
                for (DataRaceAnnotation.Race race : dataRaceAnnotation.getRaces()) {
                    for (DataRaceAnnotation.Race race2 : dataRaceAnnotation2.getRaces()) {
                        Optional<Boolean> optional = race.isConflictingAccess(race2);
                        if (optional.orElse(false).booleanValue()) {
                            HashRelation hashRelation2 = new HashRelation();
                            hashRelation2.addPair((Object)race, (Object)race2);
                            return hashRelation2;
                        }
                        if (!optional.isEmpty()) continue;
                        hashRelation.addPair((Object)race, (Object)race2);
                    }
                }
            }
            --n;
        }
        return hashRelation;
    }

    public String getShortDescription() {
        return "Data race detected";
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getShortDescription());
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("The following path leads to a data race: ");
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append(this.mProgramExecutionAsString);
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        if (this.mPossibleConflicts.size() == 1) {
            Map.Entry entry = (Map.Entry)this.mPossibleConflicts.getSetOfPairs().iterator().next();
            DataRaceFoundResult.formatDefiniteRace(stringBuilder, (DataRaceAnnotation.Race)entry.getKey(), (DataRaceAnnotation.Race)entry.getValue());
        } else {
            stringBuilder.append("Now there is a data race, but we were unable to determine exactly which statements and variables are involved.");
            for (Map.Entry entry : this.mPossibleConflicts.entrySet()) {
                DataRaceFoundResult.formatPossibleRace(stringBuilder, (DataRaceAnnotation.Race)entry.getKey(), (Set)entry.getValue());
            }
        }
        return stringBuilder.toString();
    }

    private static void formatDefiniteRace(StringBuilder stringBuilder, DataRaceAnnotation.Race race, DataRaceAnnotation.Race race2) {
        stringBuilder.append("Now there is a data race ");
        if (race.isUndeterminedRace()) {
            stringBuilder.append("(on the heap)");
        } else {
            stringBuilder.append("on ");
            stringBuilder.append(race2.getVariable());
        }
        stringBuilder.append(" between ");
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("\t");
        stringBuilder.append(race2.getOriginalLocation());
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("and");
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("\t");
        stringBuilder.append(race.getOriginalLocation());
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
    }

    private static void formatPossibleRace(StringBuilder stringBuilder, DataRaceAnnotation.Race race, Set<DataRaceAnnotation.Race> set) {
        assert (!set.isEmpty());
        stringBuilder.append(" There could be a race between");
        if (set.size() == 1) {
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            stringBuilder.append("\t");
            stringBuilder.append(set.iterator().next().getOriginalLocation());
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        } else {
            stringBuilder.append(" one of the statements");
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            for (DataRaceAnnotation.Race race2 : set) {
                stringBuilder.append("\t* ");
                stringBuilder.append(race2.getOriginalLocation());
                stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            }
        }
        stringBuilder.append("and");
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("\t");
        stringBuilder.append(race.getOriginalLocation());
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
    }

    public List<ILocation> getFailurePath() {
        return this.mFailurePath;
    }

    public IProgramExecution<TE, E> getProgramExecution() {
        return this.mProgramExecution;
    }
}

