/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;

public class BoogieCallGraph {
    private HashRelation<String, String> mCallGraph;

    public BoogieCallGraph(Unit unit) {
        this(unit.getDeclarations());
    }

    public BoogieCallGraph(Declaration[] declarationArray) {
        this.constructCallGraph(declarationArray);
    }

    public Set<String> computeCallClosure(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.mCallGraph.getDomain().contains(string)) {
            ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
            arrayDeque.add(string);
            hashSet.add(string);
            while (!arrayDeque.isEmpty()) {
                String string2 = (String)arrayDeque.remove();
                Set set = this.mCallGraph.getImage((Object)string2);
                for (String string3 : set) {
                    boolean bl = hashSet.add(string3);
                    if (!bl) continue;
                    arrayDeque.add(string3);
                }
            }
        }
        return hashSet;
    }

    private void constructCallGraph(Declaration[] declarationArray) {
        Declaration[] declarationArray2 = declarationArray;
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Procedure procedure;
            Declaration declaration = declarationArray2[n2];
            if (declaration instanceof Procedure && (procedure = (Procedure)declaration).getBody() != null) {
                this.processStatementList(procedure.getIdentifier(), procedure.getBody().getBlock());
            }
            ++n2;
        }
    }

    private void processStatementList(String string, Statement[] statementArray) {
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            if (!(statement instanceof GotoStatement) && !(statement instanceof Label)) {
                if (statement instanceof CallStatement) {
                    this.processCallStatement(string, (CallStatement)statement);
                } else if (!(statement instanceof AssignmentStatement || statement instanceof AssumeStatement || statement instanceof AssertStatement || statement instanceof HavocStatement || statement instanceof ReturnStatement || statement instanceof BreakStatement)) {
                    if (statement instanceof IfStatement) {
                        this.processStatementList(string, ((IfStatement)statement).getThenPart());
                        this.processStatementList(string, ((IfStatement)statement).getElsePart());
                    } else if (statement instanceof WhileStatement) {
                        this.processStatementList(string, ((WhileStatement)statement).getBody());
                    } else if (!(statement instanceof ForkStatement) && !(statement instanceof JoinStatement)) {
                        if (statement instanceof AtomicStatement) {
                            this.processStatementList(string, ((AtomicStatement)statement).getBody());
                        } else {
                            throw new AssertionError((Object)("Unsuppored " + String.valueOf(statement)));
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void processCallStatement(String string, CallStatement callStatement) {
        this.mCallGraph.addPair((Object)string, (Object)callStatement.getMethodName());
    }
}

