/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.HashSet;
import java.util.Set;

public class DownStateConsistencyCheck<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private static final String DOWN_STATES_INCONSISTENT = "The down states are inconsistent.";
    private final IDoubleDeckerAutomaton<LETTER, STATE> mOperand;
    private final boolean mResult;

    public DownStateConsistencyCheck(AutomataLibraryServices automataLibraryServices, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iDoubleDeckerAutomaton;
        this.mResult = this.consistentForAll();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    private boolean consistentForAll() throws AutomataOperationCanceledException {
        boolean bl = this.consistentForInitials();
        for (Object STATE : this.mOperand.getStates()) {
            if (this.isCancellationRequested()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            boolean bl2 = bl = bl && this.consistentForState(STATE);
        }
        return bl;
    }

    private boolean consistentForInitials() {
        boolean bl = true;
        for (Object e : this.mOperand.getInitialStates()) {
            Set<STATE> set = this.mOperand.getDownStates(e);
            boolean bl2 = bl = bl && set.contains(this.mOperand.getEmptyStackState());
        }
        assert (bl) : "The down states are inconsistent.";
        return bl;
    }

    private boolean consistentForState(STATE STATE) {
        Set<STATE> set = this.mOperand.getDownStates(STATE);
        boolean bl = this.getIsComparison(STATE, set);
        bl = bl && this.checkIfDownStatesArePassedToSuccessors(STATE, set);
        boolean bl2 = bl = bl && this.checkIfEachDownStateIsJustified(STATE, set);
        assert (bl) : "The down states are inconsistent.";
        return bl;
    }

    private boolean checkIfEachDownStateIsJustified(STATE STATE, Set<STATE> set) {
        Set<STATE> set2;
        HashSet<STATE> hashSet = new HashSet<STATE>(set);
        for (IncomingInternalTransition iTransitionlet : this.mOperand.internalPredecessors(STATE)) {
            set2 = this.mOperand.getDownStates(iTransitionlet.getPred());
            hashSet.removeAll(set2);
        }
        for (IncomingCallTransition incomingCallTransition : this.mOperand.callPredecessors(STATE)) {
            hashSet.remove(incomingCallTransition.getPred());
        }
        for (IncomingReturnTransition incomingReturnTransition : this.mOperand.returnPredecessors(STATE)) {
            set2 = this.mOperand.getDownStates(incomingReturnTransition.getLinPred());
            if (set2.contains(incomingReturnTransition.getHierPred())) {
                Set<STATE> set3 = this.mOperand.getDownStates(incomingReturnTransition.getHierPred());
                hashSet.removeAll(set3);
                continue;
            }
            throw new AssertionError((Object)"unreachable return");
        }
        if (this.mOperand.isInitial(STATE)) {
            hashSet.remove(this.mOperand.getEmptyStackState());
        }
        if (!hashSet.isEmpty()) {
            this.mLogger.warn((Object)("State " + String.valueOf(STATE) + " has unjustified down states " + String.valueOf(hashSet)));
        }
        return hashSet.isEmpty();
    }

    private boolean checkIfDownStatesArePassedToSuccessors(STATE STATE, Set<STATE> set) {
        Set<STATE> set2;
        boolean bl = true;
        for (OutgoingInternalTransition iOutgoingTransitionlet : this.mOperand.internalSuccessors(STATE)) {
            set2 = this.mOperand.getDownStates(iOutgoingTransitionlet.getSucc());
            boolean bl2 = bl = bl && set2.containsAll(set);
            assert (bl) : "The down states are inconsistent.";
        }
        for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE)) {
            set2 = this.mOperand.getDownStates(outgoingCallTransition.getSucc());
            boolean bl3 = bl = bl && set2.contains(STATE);
            assert (bl) : "The down states are inconsistent.";
        }
        for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessors(STATE)) {
            set2 = this.mOperand.getDownStates(outgoingReturnTransition.getSucc());
            Set<STATE> set3 = this.mOperand.getDownStates(outgoingReturnTransition.getHierPred());
            if (!set.contains(outgoingReturnTransition.getHierPred())) continue;
            boolean bl4 = bl = bl && set2.containsAll(set3);
            assert (bl) : "The down states are inconsistent.";
        }
        for (SummaryReturnTransition summaryReturnTransition : this.mOperand.summarySuccessors(STATE)) {
            set2 = this.mOperand.getDownStates(summaryReturnTransition.getSucc());
            boolean bl5 = bl = bl && set2.containsAll(set);
            assert (bl) : "The down states are inconsistent.";
        }
        return bl;
    }

    private boolean getIsComparison(STATE STATE, Set<STATE> set) {
        return this.getIsComparison1(STATE, set) && this.getIsComparison2(STATE, set);
    }

    private boolean getIsComparison1(STATE STATE, Set<STATE> set) {
        boolean bl = true;
        for (STATE STATE2 : set) {
            boolean bl2 = bl = bl && this.mOperand.isDoubleDecker(STATE, STATE2);
        }
        return bl;
    }

    private boolean getIsComparison2(STATE STATE, Set<STATE> set) {
        boolean bl = true;
        for (Object STATE2 : this.mOperand.getStates()) {
            if (!this.mOperand.isDoubleDecker(STATE, STATE2)) continue;
            boolean bl2 = bl = bl && set.contains(STATE2);
        }
        return bl;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

