/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.AbstractAcceptance;
import java.util.ArrayDeque;
import java.util.Set;

public final class Accepts<LETTER, STATE>
extends AbstractAcceptance<LETTER, STATE> {
    private final NestedWord<LETTER> mWord;
    private final boolean mPrefixOfInputIsAccepted;
    private final boolean mInputIsSuffixOfAcceptedWord;

    public Accepts(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, NestedWord<LETTER> nestedWord, boolean bl, boolean bl2) throws AutomataLibraryException {
        super(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider);
        this.mWord = nestedWord;
        this.mPrefixOfInputIsAccepted = bl;
        this.mInputIsSuffixOfAcceptedWord = bl2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mIsAccepted = this.isAccepted();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    public Accepts(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, NestedWord<LETTER> nestedWord) throws AutomataLibraryException {
        this(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, nestedWord, false, false);
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". Automaton has " + this.mOperand.sizeInformation() + " Word has length " + this.mWord.length();
    }

    @Override
    public String exitMessage() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Finished ").append(this.getOperationName()).append(". ");
        String string2 = string = this.mIsAccepted ? "some " : "each ";
        if (this.mInputIsSuffixOfAcceptedWord) {
            if (this.mPrefixOfInputIsAccepted) {
                stringBuilder.append(string).append("prefix of ").append(string).append("suffix ");
            } else {
                stringBuilder.append(string).append("suffix ");
            }
        } else if (this.mPrefixOfInputIsAccepted) {
            stringBuilder.append(string).append("prefix ");
        } else {
            stringBuilder.append("word ");
        }
        if (this.mIsAccepted) {
            stringBuilder.append("is accepted.");
        } else {
            stringBuilder.append("is rejected.");
        }
        return stringBuilder.toString();
    }

    private boolean isAccepted() throws AutomataLibraryException {
        Set set = this.emptyStackConfiguration(this.mOperand.getInitialStates());
        int n = 0;
        while (n < this.mWord.length()) {
            set = this.successorConfigurations(set, this.mWord, n, this.mOperand, this.mInputIsSuffixOfAcceptedWord);
            if (this.mPrefixOfInputIsAccepted && this.containsAcceptingConfiguration(set)) {
                return true;
            }
            ++n;
        }
        return this.containsAcceptingConfiguration(set);
    }

    public boolean containsAcceptingConfiguration(Set<ArrayDeque<STATE>> set) {
        for (ArrayDeque<STATE> arrayDeque : set) {
            if (!this.isAcceptingConfiguration(arrayDeque, this.mOperand)) continue;
            return true;
        }
        return false;
    }
}

