/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceResultAggregator;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.PrettyPrint;
import java.util.function.Supplier;

public class TimedIndependenceStatisticsDataProvider
extends IndependenceStatisticsDataProvider {
    public static final String QUERY_TIME = "Query Time";
    private final IndependenceResultAggregator.Timer mTimer = new IndependenceResultAggregator.Timer();

    public TimedIndependenceStatisticsDataProvider(Class<?> clazz) {
        super(clazz);
        this.declareTimer(clazz.getSimpleName() + ".Query Time", () -> this.mTimer);
    }

    protected final void declareTimer(String string2, Supplier<IndependenceResultAggregator.Timer> supplier) {
        this.declare(string2, supplier::get, (object, object2) -> IndependenceResultAggregator.Timer.sum((IndependenceResultAggregator.Timer)object, (IndependenceResultAggregator.Timer)object2), (string, object) -> PrettyPrint.keyColonData((String)(string + " [ms]"), (Object)((IndependenceResultAggregator.Timer)object).print(l -> Long.toString(Math.round((double)l.longValue() * 1.0E-6)))));
    }

    public void startQuery() {
        this.mTimer.start();
    }

    @Override
    public void reportQuery(IIndependenceRelation.Dependence dependence, boolean bl) {
        this.mTimer.stop(dependence, bl);
        super.reportQuery(dependence, bl);
    }

    @Override
    public void reportIndependentQuery(boolean bl) {
        this.mTimer.stop(IIndependenceRelation.Dependence.INDEPENDENT, bl);
        super.reportIndependentQuery(bl);
    }

    @Override
    public void reportDependentQuery(boolean bl) {
        this.mTimer.stop(IIndependenceRelation.Dependence.DEPENDENT, bl);
        super.reportDependentQuery(bl);
    }

    @Override
    public void reportUnknownQuery(boolean bl) {
        this.mTimer.stop(IIndependenceRelation.Dependence.UNKNOWN, bl);
        super.reportUnknownQuery(bl);
    }
}

