/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.PolyIdentifier;
import java.util.List;
import java.util.function.Predicate;

public final class Case
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Case.class);
    PolyIdentifier polyId;
    Expression formula;

    public Case(PolyIdentifier polyIdentifier, Expression expression) {
        this.polyId = polyIdentifier;
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Case: " + String.valueOf(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Case").append('[');
        stringBuffer.append(this.polyId);
        stringBuffer.append(',').append(this.formula);
        return stringBuffer.append(']').toString();
    }

    public PolyIdentifier getPolyId() {
        return this.polyId;
    }

    public Expression getFormula() {
        return this.formula;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.polyId);
        list.add(this.formula);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (aCSLVisitor.visit(this)) {
            if (this.polyId != null) {
                this.polyId.accept(aCSLVisitor);
            }
            if (this.formula != null) {
                this.formula.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Case accept(ACSLTransformer aCSLTransformer) {
        Case case_ = aCSLTransformer.transform(this);
        if (case_ != this) {
            return case_;
        }
        PolyIdentifier polyIdentifier = null;
        if (this.polyId != null) {
            polyIdentifier = this.polyId.accept(aCSLTransformer);
        }
        Expression expression = null;
        if (this.formula != null) {
            expression = this.formula.accept(aCSLTransformer);
        }
        if (this.polyId != polyIdentifier || this.formula != expression) {
            return new Case(polyIdentifier, expression);
        }
        return this;
    }
}

