/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST;

import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.RelationalOperatorAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;

public class RelationalExpressionAST
extends AtsASTNode {
    private static final long serialVersionUID = -5806173754091876977L;
    private RelationalOperatorAST moperator;

    public RelationalOperatorAST getOperator() {
        return this.moperator;
    }

    public void setOperator(RelationalOperatorAST relationalOperatorAST) {
        this.moperator = relationalOperatorAST;
    }

    public RelationalExpressionAST(ILocation iLocation) {
        super(iLocation);
        this.mReturnType = Boolean.class;
        this.mExpectingType = Integer.class;
    }

    public String toString() {
        return "RelationalExpression [Operator: " + RelationalExpressionAST.operatorToString(this.moperator) + "]";
    }

    private static String operatorToString(RelationalOperatorAST relationalOperatorAST) {
        return switch (relationalOperatorAST) {
            case RelationalOperatorAST.LESSTHAN -> " < ";
            case RelationalOperatorAST.LESS_EQ_THAN -> " <= ";
            case RelationalOperatorAST.GREATERTHAN -> " > ";
            case RelationalOperatorAST.GREATER_EQ_THAN -> " >= ";
            case RelationalOperatorAST.EQ -> " == ";
            case RelationalOperatorAST.NOT_EQ -> " != ";
            default -> throw new MatchException(null, null);
        };
    }

    public String getOperatorAsString() {
        return RelationalExpressionAST.operatorToString(this.moperator);
    }

    @Override
    public String getAsString() {
        if (this.mChildren.size() == 2) {
            return ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString() + RelationalExpressionAST.operatorToString(this.moperator) + ((AtsASTNode)((Object)this.mChildren.get(1))).getAsString();
        }
        return "";
    }
}

