/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IMessageProvider;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public abstract class MessageProvider
implements IMessageProvider {
    private final Map<Spec, Supplier<String>> mPosMsgProviderOverrideFuncs = new HashMap<Spec, Supplier<String>>();
    private final Map<Spec, Supplier<String>> mNegMsgProviderOverrideFuncs = new HashMap<Spec, Supplier<String>>();
    private final Set<Spec.Group> mSpecGroups;

    public MessageProvider(Spec.Group group) {
        this(EnumSet.of(group));
    }

    public MessageProvider(Set<Spec.Group> set) {
        this.mSpecGroups = set;
    }

    private void checkSpecificationGroups(Spec spec) throws IllegalArgumentException {
        if (!spec.isInGroups(this.mSpecGroups)) {
            throw new IllegalArgumentException(String.format("Messages for specification type '%s' are not handled by this message provider for '%s'!", spec, this.mSpecGroups));
        }
    }

    public void registerPositiveMessageOverride(Spec spec, Supplier<String> supplier) {
        this.mPosMsgProviderOverrideFuncs.put(spec, supplier);
    }

    public void registerNegativeMessageOverride(Spec spec, Supplier<String> supplier) {
        this.mNegMsgProviderOverrideFuncs.put(spec, supplier);
    }

    public String getPositiveMessage(Spec spec) {
        this.checkSpecificationGroups(spec);
        Supplier<String> supplier = this.mPosMsgProviderOverrideFuncs.get(spec);
        if (supplier != null) {
            return supplier.get();
        }
        return this.getDefaultPositiveMessage(spec);
    }

    public String getNegativeMessage(Spec spec) {
        this.checkSpecificationGroups(spec);
        Supplier<String> supplier = this.mNegMsgProviderOverrideFuncs.get(spec);
        if (supplier != null) {
            return supplier.get();
        }
        return this.getDefaultNegativeMessage(spec);
    }
}

