/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Axiomatic;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Inductive;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Lemma;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LogicFunction;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Parameter;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.PolyIdentifier;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Predicate;
import java.util.Arrays;
import java.util.List;

public abstract sealed class LogicStatement
extends ACSLNode
permits LogicFunction, Predicate, Axiom, Axiomatic, Lemma, Inductive {
    private static final java.util.function.Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(LogicStatement.class);
    PolyIdentifier polyId;
    Parameter[] parameters;

    public LogicStatement(PolyIdentifier polyIdentifier) {
        this.polyId = polyIdentifier;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid LogicStatement: " + String.valueOf(this);
    }

    public LogicStatement(PolyIdentifier polyIdentifier, Parameter[] parameterArray) {
        this.polyId = polyIdentifier;
        this.parameters = parameterArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid LogicStatement: " + String.valueOf(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LogicStatement").append('[');
        stringBuffer.append(this.polyId);
        stringBuffer.append(',');
        if (this.parameters == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.parameters.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.parameters[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public PolyIdentifier getPolyId() {
        return this.polyId;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.polyId);
        if (this.parameters != null) {
            list.addAll(Arrays.asList(this.parameters));
        }
        return list;
    }

    @Override
    public abstract void accept(ACSLVisitor var1);

    @Override
    public abstract LogicStatement accept(ACSLTransformer var1);
}

