/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner;

import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InlinedCallAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private final List<CallStatement> mCallStatements;
    private final boolean mIsReturn;
    private final boolean mIsCallAndReturn;

    public InlinedCallAnnotation(CallStatement callStatement, boolean bl) {
        this.mCallStatements = Collections.singletonList(callStatement);
        this.mIsReturn = bl;
        this.mIsCallAndReturn = false;
    }

    private InlinedCallAnnotation(List<CallStatement> list, boolean bl, boolean bl2) {
        this.mCallStatements = list;
        this.mIsReturn = bl;
        this.mIsCallAndReturn = bl2;
    }

    public CallStatement getCallStatement() {
        if (this.mCallStatements.size() > 1) {
            throw new UnsupportedOperationException("You should not try to infer an inlined call from a merged annotation");
        }
        return this.mCallStatements.get(0);
    }

    public boolean isReturn() {
        if (this.mIsCallAndReturn) {
            throw new UnsupportedOperationException("You should not try to infer an inlined call from a merged annotation");
        }
        return this.mIsReturn;
    }

    public void annotate(IElement iElement) {
        iElement.getPayload().getAnnotations().put(InlinedCallAnnotation.class.getName(), this);
    }

    public static InlinedCallAnnotation getAnnotation(IElement iElement) {
        return (InlinedCallAnnotation)ModelUtils.getAnnotation((IElement)iElement, InlinedCallAnnotation.class);
    }

    public String toString() {
        return String.valueOf(this.mCallStatements);
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations instanceof InlinedCallAnnotation) {
            InlinedCallAnnotation inlinedCallAnnotation = (InlinedCallAnnotation)iAnnotations;
            ArrayList<CallStatement> arrayList = new ArrayList<CallStatement>(this.mCallStatements);
            arrayList.addAll(inlinedCallAnnotation.mCallStatements);
            return new InlinedCallAnnotation(arrayList, inlinedCallAnnotation.mIsReturn && this.mIsReturn, this.mIsCallAndReturn || inlinedCallAnnotation.mIsCallAndReturn || this.mIsReturn != inlinedCallAnnotation.mIsReturn);
        }
        return super.merge(iAnnotations);
    }
}

