/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class LexicographicRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = -7426526617632086331L;
    private final RankingFunction[] mParts;

    public LexicographicRankingFunction(RankingFunction[] rankingFunctionArray) {
        assert (rankingFunctionArray.length >= 1);
        this.mParts = rankingFunctionArray;
    }

    @Override
    public String getName() {
        return this.mParts.length + "-lex";
    }

    public RankingFunction[] getComponents() {
        return this.mParts;
    }

    @Override
    public Set<IProgramVar> getVariables() {
        LinkedHashSet<IProgramVar> linkedHashSet = new LinkedHashSet<IProgramVar>();
        RankingFunction[] rankingFunctionArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            RankingFunction rankingFunction = rankingFunctionArray[n2];
            linkedHashSet.addAll(rankingFunction.getVariables());
            ++n2;
        }
        return linkedHashSet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mParts.length);
        stringBuilder.append("-lexicographic ranking function:\n");
        stringBuilder.append("  f(");
        boolean bl = true;
        for (IProgramVar iProgramVar : this.getVariables()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(iProgramVar.getGloballyUniqueId());
            bl = false;
        }
        stringBuilder.append(") = <");
        int n = 0;
        while (n < this.mParts.length) {
            if (n > 0) {
                stringBuilder.append(",  ");
            }
            stringBuilder.append(this.mParts[n]);
            ++n;
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        ArrayList arrayList = new ArrayList();
        RankingFunction[] rankingFunctionArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            RankingFunction rankingFunction = rankingFunctionArray[n2];
            Term[] termArray = rankingFunction.asLexTerm(script);
            Collections.addAll(arrayList, termArray);
            ++n2;
        }
        return arrayList.toArray(new Term[arrayList.size()]);
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> map) {
        Ordinal ordinal = Ordinal.ZERO;
        return ordinal;
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.OMEGA;
    }
}

