/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.test_generator;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Generator {
    private final List<String> mDeclarations = new ArrayList<String>();
    private final List<Term> mInputAsserts = new ArrayList<Term>();
    private final List<Term> mOutputAsserts = new ArrayList<Term>();
    private int mDots = 1;
    final PrintWriter mOut;

    public Generator(PrintWriter printWriter) {
        this.mOut = printWriter;
    }

    public void setLogic(String string) {
        String string2 = "(set-logic " + string + ")";
        this.mOut.println(string2);
    }

    public void addPush(int n) {
        this.mOut.println("(push " + n + ")");
    }

    public void addPop(int n) {
        this.mOut.println("(pop " + n + ")");
    }

    public void addFuncDec(String string, Sort[] sortArray, Sort sort) {
        this.updateDots(string);
        StringBuilder stringBuilder = new StringBuilder("(declare-fun ").append(string).append(" (");
        if (sortArray.length != 0) {
            String string2 = "";
            Sort[] sortArray2 = sortArray;
            int n = sortArray.length;
            int n2 = 0;
            while (n2 < n) {
                Sort sort2 = sortArray2[n2];
                stringBuilder.append(string2).append(sort2);
                string2 = " ";
                ++n2;
            }
        }
        stringBuilder.append(") ").append(sort).append(')');
        this.mOut.println(stringBuilder);
    }

    public void addSortDec(String string, int n) {
        this.updateDots(string);
        this.mOut.println("(declare-sort " + string + " " + n + ")");
    }

    public void addFuncDef(String string, TermVariable[] termVariableArray, Sort sort, Term term) {
        this.updateDots(string);
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append("(define-fun ").append(string).append(" (");
        if (termVariableArray.length != 0) {
            TermVariable[] termVariableArray2 = termVariableArray;
            int n = termVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable termVariable = termVariableArray2[n2];
                stringBuilder.append('(').append(termVariable).append(' ').append(termVariable.getSort()).append(')');
                ++n2;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(") ").append(sort).append(' ').append(term).append(')');
        this.mDeclarations.add(stringBuilder.toString());
    }

    public void addSortDef(String string, Sort[] sortArray, Sort sort) {
        this.updateDots(string);
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append("(define-sort ").append(string).append(" (");
        if (sortArray.length != 0) {
            Sort[] sortArray2 = sortArray;
            int n = sortArray.length;
            int n2 = 0;
            while (n2 < n) {
                Sort sort2 = sortArray2[n2];
                stringBuilder.append(sort2).append(' ');
                ++n2;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(") ").append(sort).append(')');
        this.mDeclarations.add(stringBuilder.toString());
    }

    public void addInputAssertion(Term term) {
        this.mInputAsserts.add(term);
    }

    public void addNewDeclaration(String object) {
        object = (String)object + "; new added";
        this.mDeclarations.add((String)object);
    }

    public void addOutputAssertion(Term term) {
        this.mOutputAsserts.add(term);
    }

    public List<Term> getInputAssertions() {
        return this.mInputAsserts;
    }

    public void writeCorrectness(Term[] termArray, Term term) {
        this.mOut.println();
        this.mOut.println("(push 1)");
        this.mOut.println("(set-info :status unsat)");
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray2[n2];
            this.mOut.println("(declare-fun " + String.valueOf(term2) + " () " + String.valueOf(term2.getSort()) + ")");
            ++n2;
        }
        this.mOut.println("(assert " + term.toStringDirect() + ")");
        this.mOut.println("(check-sat)");
        this.mOut.println("(pop 1)");
        this.mOut.flush();
    }

    public void updateDots(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) != '.') break;
            ++n;
            ++n2;
        }
        this.mDots = Math.max(this.mDots, n + 1);
    }

    public String getDots() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.mDots;
        while (n-- > 0) {
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    public void exit() {
        this.mOut.println("(exit)");
        this.mOut.close();
    }

    public Term convertClauseToTerm(Theory theory, Clause clause) {
        Term[] termArray = new Term[clause.getSize()];
        int n = 0;
        while (n < clause.getSize()) {
            termArray[n] = clause.getLiteral(n).getSMTFormula(theory);
            ++n;
        }
        Term term = theory.or(termArray);
        return term;
    }

    /*
     * WARNING - void declaration
     */
    public void generate(Theory theory, Term[] termArray, List<Clause> list, Map<TermVariable, Term> map) {
        void var12_19;
        FunctionSymbol functionSymbol;
        String string;
        Sort sort;
        theory.push();
        String string2 = this.getDots() + "con";
        TermVariable[] termVariableArray = new TermVariable[map.size()];
        Term[] termArray2 = new Term[map.size()];
        Term[] termArray3 = new Term[map.size()];
        int n = 0;
        for (Map.Entry<TermVariable, Term> object22 : map.entrySet()) {
            Term term = object22.getValue();
            sort = term.getSort();
            string = string2 + n;
            functionSymbol = theory.declareFunction(string, new Sort[0], sort);
            termVariableArray[n] = object22.getKey();
            termArray2[n] = term;
            termArray3[n] = theory.term(functionSymbol, new Term[0]);
            ++n;
        }
        ApplicationTerm[] applicationTermArray = new ApplicationTerm[list.size()];
        int n2 = 0;
        for (Clause clause : list) {
            applicationTermArray[n2++] = this.convertClauseToTerm(theory, clause);
        }
        Term term = theory.and((Term[])applicationTermArray);
        sort = theory.term("not", new Term[]{term});
        if (termVariableArray.length > 0) {
            sort = theory.let(termVariableArray, termArray2, (Term)sort);
            Term term2 = theory.let(termVariableArray, termArray3, term);
        }
        string = theory.and(termArray);
        functionSymbol = theory.term("and", new Term[]{string, sort});
        Term term3 = theory.term("and", new Term[]{var12_19, theory.term("not", new Term[]{string})});
        this.writeCorrectness(new Term[0], (Term)functionSymbol);
        this.writeCorrectness(termArray3, term3);
        theory.pop();
    }
}

