/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class AtomicLibraryModel
implements ILibraryModel {
    private final FunctionModelHelper mHelper;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final ExpressionTranslation mExpressionTranslation;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;

    public AtomicLibraryModel(FunctionModelHelper functionModelHelper, ExpressionResultTransformer expressionResultTransformer, ExpressionTranslation expressionTranslation, AuxVarInfoBuilder auxVarInfoBuilder) {
        this.mHelper = functionModelHelper;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mExpressionTranslation = expressionTranslation;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        ArrayList<ILibraryModel.FunctionModel> arrayList = new ArrayList<ILibraryModel.FunctionModel>();
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_load", this::handleAtomicLoad));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_store", this::handleAtomicStore));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_exchange", this::handleAtomicExchange));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_compare_exchange", this::handleAtomicCompareExchange));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_load_n", this::handleAtomicLoadN));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_store_n", this::handleAtomicStoreN));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_exchange_n", this::handleAtomicExchangeN));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_compare_exchange_n", this::handleAtomicCompareExchangeN));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_fetch_add", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleAtomicFetch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 4)));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_fetch_sub", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleAtomicFetch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 5)));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_fetch_and", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleAtomicFetch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 12)));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_fetch_or", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleAtomicFetch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 14)));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_fetch_xor", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleAtomicFetch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 13)));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_test_and_set", this::handleAtomicTestAndSet));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_clear", this::handleAtomicClear));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_thread_fence", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleUnsupportedFunctionByOverapproximation(iDispatcher, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.VOID))));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_signal_fence", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleUnsupportedFunctionByOverapproximation(iDispatcher, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.VOID))));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_always_lock_free", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPrimitive(CPrimitive.CPrimitives.BOOL))));
        arrayList.add(new ILibraryModel.FunctionModel("__atomic_is_lock_free", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPrimitive(CPrimitive.CPrimitives.BOOL))));
        return arrayList;
    }

    private Result handleAtomicClear(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult.getLrValue(), this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.BOOL), BigInteger.ZERO));
        return expressionResultBuilder.addAllExceptLrValue(this.applyMemoryOrders(iLocation, expressionResult3, expressionResult2.getLrValue().getValue())).build();
    }

    private Result handleAtomicTestAndSet(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder(this.mExprResultTransformer.readPointerValue(iLocation, expressionResult.getLrValue()));
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.BOOL);
        Expression expression = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ONE);
        expressionResultBuilder.addAllExceptLrValue(this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult.getLrValue(), expression));
        ExpressionResultBuilder expressionResultBuilder2 = new ExpressionResultBuilder();
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        expressionResultBuilder2.addAllExceptLrValue(expressionResult, expressionResult2).addAllIncludingLrValue(this.applyMemoryOrders(iLocation, expressionResultBuilder.build(), expressionResult2.getLrValue().getValue()));
        return expressionResultBuilder2.build();
    }

    private Result handleAtomicLoad(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[1]);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[2]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult3);
        ExpressionResult expressionResult4 = this.mExprResultTransformer.readPointerValue(iLocation, expressionResult.getLrValue());
        ExpressionResult expressionResult5 = this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult2.getLrValue(), expressionResult4.getLrValue().getValue());
        return expressionResultBuilder.addAllIncludingLrValue(this.applyMemoryOrders(iLocation, expressionResult4, expressionResult3.getLrValue().getValue())).addAllExceptLrValue(expressionResult5).build();
    }

    private Result handleAtomicStore(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[1]);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[2]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult3);
        ExpressionResult expressionResult4 = this.mExprResultTransformer.readPointerValue(iLocation, expressionResult2.getLrValue());
        expressionResultBuilder.addAllExceptLrValue(expressionResult4);
        expressionResultBuilder.addAllExceptLrValue(this.applyMemoryOrders(iLocation, this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult.getLrValue(), expressionResult4.getLrValue().getValue()), expressionResult3.getLrValue().getValue()));
        return expressionResultBuilder.build();
    }

    private Result handleAtomicExchange(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 4, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[1]);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[2]);
        ExpressionResult expressionResult4 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[3]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult3, expressionResult4);
        ExpressionResult expressionResult5 = this.mExprResultTransformer.readPointerValue(iLocation, expressionResult.getLrValue());
        ExpressionResultBuilder expressionResultBuilder2 = new ExpressionResultBuilder();
        ExpressionResult expressionResult6 = this.mExprResultTransformer.readPointerValue(iLocation, expressionResult2.getLrValue());
        expressionResultBuilder2.addAllExceptLrValue(expressionResult5, this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult3.getLrValue(), expressionResult5.getLrValue().getValue()), expressionResult6, this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult.getLrValue(), expressionResult6.getLrValue().getValue()));
        expressionResultBuilder.addAllExceptLrValue(this.applyMemoryOrders(iLocation, expressionResultBuilder2.build(), expressionResult4.getLrValue().getValue()));
        return expressionResultBuilder.build();
    }

    private Result handleAtomicCompareExchange(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 6, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[2]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.readPointerValue(iLocation, expressionResult.getLrValue());
        return this.handleAtomicCompareExchange(iDispatcher, iASTFunctionCallExpression, iLocation, expressionResult, expressionResult2);
    }

    private Result handleAtomicCompareExchangeN(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 6, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDecaySwitch((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[2]), iLocation, (IASTNode)iASTFunctionCallExpression);
        ExpressionResult expressionResult2 = new ExpressionResult(expressionResult.getLrValue());
        return this.handleAtomicCompareExchange(iDispatcher, iASTFunctionCallExpression, iLocation, expressionResult, expressionResult2);
    }

    private Result handleAtomicCompareExchange(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, ExpressionResult expressionResult, ExpressionResult expressionResult2) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        ExpressionResult expressionResult3 = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult4 = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[1]);
        ExpressionResult expressionResult5 = this.mExprResultTransformer.transformSwitchRexIntToBool((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[3]), iLocation, (IASTNode)iASTFunctionCallExpression);
        ExpressionResult expressionResult6 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[4]);
        ExpressionResult expressionResult7 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[5]);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult3, expressionResult4, expressionResult, expressionResult5, expressionResult6, expressionResult7);
        boolean bl = !ExpressionFactory.isFalseLiteral((Expression)expressionResult5.getLrValue().getValue());
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.BOOL);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        Expression expression = this.mExpressionTranslation.toBool(iLocation, (Expression)auxVarInfo.getExp(), cPrimitive);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        if (bl) {
            expressionResultBuilder.addStatement((Statement)new HavocStatement(iLocation, new VariableLHS[]{auxVarInfo.getLhs()}));
        }
        ExpressionResult expressionResult8 = this.mExprResultTransformer.readPointerValue(iLocation, expressionResult3.getLrValue());
        ExpressionResult expressionResult9 = this.mExprResultTransformer.readPointerValue(iLocation, expressionResult4.getLrValue());
        ExpressionResult expressionResult10 = this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult3.getLrValue(), expressionResult2.getLrValue().getValue());
        ExpressionResult expressionResult11 = this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult4.getLrValue(), expressionResult8.getLrValue().getValue());
        ExpressionResult expressionResult12 = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult8, expressionResult9).addAllExceptLrValueAndStatements(expressionResult2).addAllExceptLrValueAndStatements(expressionResult10).addAllExceptLrValueAndStatements(expressionResult11).addStatement((Statement)StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)this.mExpressionTranslation.boolToInt(iLocation, this.mExpressionTranslation.constructBinaryEqualityExpression(iLocation, 28, expressionResult8.getLrValue().getValue(), expressionResult8.getLrValue().getCType(), expressionResult9.getLrValue().getValue(), expressionResult9.getCType()), cPrimitive.getType()))).addStatement(StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)expression, (List)DataStructureUtils.concat(expressionResult2.getStatements(), expressionResult10.getStatements()), expressionResult11.getStatements())).build();
        ExpressionResult expressionResult13 = this.applyMemoryOrders(iLocation, expressionResult12, expressionResult6.getLrValue().getValue(), expressionResult7.getLrValue().getValue());
        if (bl) {
            expressionResultBuilder.addAllExceptLrValueAndStatements(expressionResult13).addStatement(StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)ExpressionFactory.or((ILocation)iLocation, (Expression[])new Expression[]{expression, ExpressionFactory.not((ILocation)iLocation, (Expression)expressionResult5.getLrValue().getValue())}), expressionResult13.getStatements()));
        } else {
            expressionResultBuilder.addAllExceptLrValue(expressionResult13);
        }
        return expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), cPrimitive)).build();
    }

    private Result handleAtomicLoadN(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.readPointerValue(iLocation, expressionResult.getLrValue());
        ExpressionResult expressionResult3 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult3).addAllIncludingLrValue(this.applyMemoryOrders(iLocation, expressionResult2, expressionResult3.getLrValue().getValue())).build();
    }

    private Result handleAtomicStoreN(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDecaySwitch((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[1]), iLocation, (IASTNode)iASTFunctionCallExpression);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[2]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult3);
        ExpressionResult expressionResult4 = this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult.getLrValue(), expressionResult2.getLrValue().getValue());
        return expressionResultBuilder.addAllExceptLrValue(this.applyMemoryOrders(iLocation, expressionResult4, expressionResult3.getLrValue().getValue())).build();
    }

    private Result handleAtomicExchangeN(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDecaySwitch((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[1]), iLocation, (IASTNode)iASTFunctionCallExpression);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[2]);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult3);
        ExpressionResultBuilder expressionResultBuilder2 = new ExpressionResultBuilder(this.mExprResultTransformer.readPointerValue(iLocation, expressionResult.getLrValue()));
        expressionResultBuilder2.addAllExceptLrValue(this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult.getLrValue(), expressionResult2.getLrValue().getValue()));
        return expressionResultBuilder.addAllIncludingLrValue(this.applyMemoryOrders(iLocation, expressionResultBuilder2.build(), expressionResult3.getLrValue().getValue())).build();
    }

    private Result handleAtomicFetch(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, int n) {
        Expression expression;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDecaySwitch((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[1]), iLocation, (IASTNode)iASTFunctionCallExpression);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.transformDispatchSwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[2]);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult3);
        ExpressionResult expressionResult4 = this.mExprResultTransformer.readPointerValue(iLocation, expressionResult.getLrValue());
        ExpressionResultBuilder expressionResultBuilder2 = new ExpressionResultBuilder(expressionResult4);
        CPrimitive cPrimitive = (CPrimitive)expressionResult4.getCType().getUnderlyingType();
        CPrimitive cPrimitive2 = (CPrimitive)expressionResult2.getCType().getUnderlyingType();
        if (n == 4 || n == 5) {
            expression = this.mExpressionTranslation.constructArithmeticExpression(iLocation, n, expressionResult4.getLrValue().getValue(), cPrimitive, expressionResult2.getLrValue().getValue(), cPrimitive2);
        } else {
            ExpressionResult expressionResult5 = this.mExpressionTranslation.handleBinaryBitwiseExpression(iLocation, n, expressionResult4.getLrValue().getValue(), cPrimitive, expressionResult2.getLrValue().getValue(), cPrimitive2, this.mAuxVarInfoBuilder);
            expressionResultBuilder2.addAllExceptLrValue(expressionResult5);
            expression = expressionResult5.getLrValue().getValue();
        }
        expressionResultBuilder2.addAllExceptLrValue(this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult.getLrValue(), expression));
        return expressionResultBuilder.addAllIncludingLrValue(this.applyMemoryOrders(iLocation, expressionResultBuilder2.build(), expressionResult3.getLrValue().getValue())).build();
    }

    private ExpressionResult applyMemoryOrders(ILocation iLocation, ExpressionResult expressionResult, Expression ... expressionArray) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder(expressionResult);
        expressionResultBuilder.resetStatements(List.of());
        AtomicStatement atomicStatement = StatementFactory.constructAtomicStatement((ILocation)iLocation, expressionResult.getStatements());
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        Expression expression = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, MemoryOrder.SEQ_CST.getValue());
        List list = Arrays.stream(expressionArray).map(expression2 -> this.mExpressionTranslation.constructBinaryEqualityExpression(iLocation, 28, (Expression)expression2, cPrimitive, expression, cPrimitive)).collect(Collectors.toList());
        Expression expression3 = ExpressionFactory.and((ILocation)iLocation, list);
        Statement statement = ExpressionTranslation.modelUnsupportedFeature(iLocation, "memory order (only sequential consistency is supported)");
        Object object = expression3 instanceof BooleanLiteral ? (((BooleanLiteral)expression3).getValue() ? atomicStatement : statement) : new IfStatement(iLocation, expression3, new Statement[]{atomicStatement}, new Statement[]{statement});
        return expressionResultBuilder.addStatement((Statement)object).build();
    }

    @Override
    public Collection<ILibraryModel.TypeModel> getTypeModels() {
        return List.of(new ILibraryModel.TypeModel("atomic_bool", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.BOOL)), new ILibraryModel.TypeModel("atomic_char", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.CHAR)), new ILibraryModel.TypeModel("atomic_schar", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.SCHAR)), new ILibraryModel.TypeModel("atomic_uchar", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.UCHAR)), new ILibraryModel.TypeModel("atomic_short", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.SHORT)), new ILibraryModel.TypeModel("atomic_ushort", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.USHORT)), new ILibraryModel.TypeModel("atomic_int", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.INT)), new ILibraryModel.TypeModel("atomic_uint", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.UINT)), new ILibraryModel.TypeModel("atomic_long", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.LONG)), new ILibraryModel.TypeModel("atomic_ulong", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.ULONG)), new ILibraryModel.TypeModel("atomic_llong", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.LONGLONG)), new ILibraryModel.TypeModel("atomic_ullong", CPrimitive.constructAtomicType(CPrimitive.CPrimitives.ULONGLONG)), new ILibraryModel.TypeModel("memory_order", new CEnum("memory_order", (String[])Arrays.stream(MemoryOrder.values()).map(MemoryOrder::getFieldName).toArray(String[]::new))));
    }

    @Override
    public Collection<ILibraryModel.ConstantModel> getConstantModels() {
        ArrayList<ILibraryModel.ConstantModel> arrayList = new ArrayList<ILibraryModel.ConstantModel>();
        MemoryOrder[] memoryOrderArray = MemoryOrder.values();
        int n = memoryOrderArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryOrder memoryOrder = memoryOrderArray[n2];
            ILibraryModel.IConstantModelHandler iConstantModelHandler = iLocation -> this.mHelper.constructIntegerLiteral(iLocation, memoryOrder.getValue(), new CPrimitive(CPrimitive.CPrimitives.INT));
            arrayList.add(new ILibraryModel.ConstantModel(memoryOrder.getFieldName(), iConstantModelHandler));
            arrayList.add(new ILibraryModel.ConstantModel(memoryOrder.getGccConstantName(), iConstantModelHandler));
            ++n2;
        }
        return arrayList;
    }

    private static enum MemoryOrder {
        RELAXED("memory_order_relaxed", "__ATOMIC_RELAXED", 0),
        CONSUME("memory_order_consume", "__ATOMIC_CONSUME", 1),
        ACQUIRE("memory_order_acquire", "__ATOMIC_ACQUIRE", 2),
        RELEASE("memory_order_release", "__ATOMIC_RELEASE", 3),
        ACQ_REL("memory_order_acq_rel", "__ATOMIC_ACQ_REL", 4),
        SEQ_CST("memory_order_seq_cst", "__ATOMIC_SEQ_CST", 5);

        private final String mFieldName;
        private final String mGccConstantName;
        private final int mValue;

        private MemoryOrder(String string2, String string3, int n2) {
            this.mFieldName = string2;
            this.mGccConstantName = string3;
            this.mValue = n2;
        }

        public String getFieldName() {
            return this.mFieldName;
        }

        public String getGccConstantName() {
            return this.mGccConstantName;
        }

        public BigInteger getValue() {
            return BigInteger.valueOf(this.mValue);
        }
    }
}

