/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetadataStoreHelper {
    static final int STORE_VERSION = 1;
    static final byte STRING_NULL = 0;
    static final byte STRING_OBJECT = 1;
    static final byte STRING_INDEX = 2;
    static final byte STRING_LONG = 3;

    public static void addString(String s, Set<String> strings) {
        if (s != null) {
            strings.add(s);
        }
    }

    public static class MetaDataWriter {
        private final Map<String, Integer> stringTable = new HashMap<String, Integer>();

        public void writeVersion(DataOutputStream out) throws IOException {
            out.writeInt(1);
        }

        public void writeIndexedString(String s, DataOutputStream out) throws IOException {
            this.writeString(s, out);
            out.writeInt(this.addToStringTable(s));
        }

        public void writeString(String s, DataOutputStream out) throws IOException {
            Integer index;
            Integer n = index = s != null ? this.stringTable.get(s) : null;
            if (index != null) {
                out.writeByte(2);
                out.writeInt(index);
                return;
            }
            if (s == null) {
                out.writeByte(0);
            } else {
                byte[] data = s.getBytes("UTF-8");
                if (data.length > 65535) {
                    out.writeByte(3);
                    out.writeInt(data.length);
                    out.write(data);
                } else {
                    out.writeByte(1);
                    out.writeUTF(s);
                }
            }
        }

        private int addToStringTable(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            Integer cur = this.stringTable.get(s);
            if (cur != null) {
                throw new IllegalStateException("String is already in the write table: " + s);
            }
            int index = this.stringTable.size();
            this.stringTable.put(s, index);
            return index;
        }
    }

    public static class MetaDataReader {
        private final List<String> stringTable = new ArrayList<String>();

        public boolean isVersionSupported(DataInputStream in) throws IOException {
            return 1 == in.readInt();
        }

        public String readIndexedString(DataInputStream in) throws IOException {
            String s = this.readString(in);
            this.addToStringTable(s, in.readInt());
            return s;
        }

        public String readString(DataInputStream in) throws IOException {
            String s;
            byte type = in.readByte();
            if (type == 2) {
                int index = in.readInt();
                return this.stringTable.get(index);
            }
            if (type == 0) {
                return null;
            }
            if (type == 3) {
                int length = in.readInt();
                byte[] data = new byte[length];
                in.readFully(data);
                s = new String(data, "UTF-8");
            } else {
                s = in.readUTF();
            }
            return s;
        }

        private void addToStringTable(String s, int index) {
            if (index == this.stringTable.size()) {
                this.stringTable.add(s);
            } else if (index < this.stringTable.size()) {
                this.stringTable.set(index, s);
            } else {
                while (this.stringTable.size() < index) {
                    this.stringTable.add(null);
                }
                this.stringTable.add(s);
            }
        }
    }
}

