/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public final class RcfgUtils {
    private RcfgUtils() {
    }

    public static boolean isAllowedReturn(IIcfgReturnTransition<?, ?> iIcfgReturnTransition, IIcfgTransition<?> iIcfgTransition) {
        if (iIcfgTransition == null) {
            return false;
        }
        assert (iIcfgTransition instanceof IIcfgCallTransition);
        return iIcfgReturnTransition.getCorrespondingCall().equals(iIcfgTransition);
    }

    public static boolean isValidSuccessor(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        return !(icfgEdge instanceof IIcfgReturnTransition) || RcfgUtils.isAllowedReturn((IIcfgReturnTransition)icfgEdge, icfgEdge2);
    }

    public static <E extends IcfgEdge> Collection<IcfgEdge> getValidCodeBlocks(Collection<E> collection, E e) {
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList<IcfgEdge> arrayList = new ArrayList<IcfgEdge>(collection.size());
        for (IcfgEdge icfgEdge : collection) {
            if (!RcfgUtils.isValidSuccessor(icfgEdge, e)) continue;
            arrayList.add(icfgEdge);
        }
        return arrayList;
    }

    public static boolean isSummaryWithImplementation(IcfgEdge icfgEdge) {
        if (icfgEdge instanceof Summary) {
            Summary summary = (Summary)icfgEdge;
            return summary.calledProcedureHasImplementation();
        }
        return false;
    }

    public static boolean isSummaryForCall(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        if (icfgEdge2 instanceof Call && icfgEdge instanceof Summary) {
            Call call = (Call)icfgEdge2;
            Summary summary = (Summary)icfgEdge;
            return summary.getCallStatement() == call.getCallStatement();
        }
        return false;
    }

    public static Collection<IcfgEdge> getInitialEdges(IIcfg<?> iIcfg) {
        return iIcfg.getInitialNodes().stream().flatMap(icfgLocation -> icfgLocation.getOutgoingEdges().stream()).collect(Collectors.toSet());
    }

    public static Collection<CodeBlock> getInitialCodeblocks(IIcfg<?> iIcfg) {
        Collection<IcfgEdge> collection = RcfgUtils.getInitialEdges(iIcfg);
        assert (collection.stream().allMatch(icfgEdge -> icfgEdge instanceof CodeBlock));
        return collection.stream().map(icfgEdge -> (CodeBlock)icfgEdge).collect(Collectors.toSet());
    }
}

