/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class StructType
extends ASTType {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(StructType.class);
    VarList[] fields;

    public StructType(ILocation iLocation, VarList[] varListArray) {
        super(iLocation);
        this.fields = varListArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid StructType: " + String.valueOf((Object)this);
    }

    public StructType(ILocation iLocation, IBoogieType iBoogieType, VarList[] varListArray) {
        super(iLocation, iBoogieType);
        this.fields = varListArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid StructType: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StructType").append('[');
        if (this.fields == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.fields.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.fields[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public VarList[] getFields() {
        return this.fields;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.fields != null) {
            list.addAll(Arrays.asList(this.fields));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((ASTType)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.fields != null) {
            VarList[] varListArray = this.fields;
            int n = this.fields.length;
            int n2 = 0;
            while (n2 < n) {
                VarList varList = varListArray[n2];
                varList.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    @Override
    public ASTType accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        ASTType aSTType = generatedBoogieAstTransformer.transform(this);
        if (aSTType != this) {
            return aSTType;
        }
        boolean bl = false;
        ArrayList<VarList> arrayList = new ArrayList<VarList>();
        if (this.fields != null) {
            VarList[] varListArray = this.fields;
            int n = this.fields.length;
            int n2 = 0;
            while (n2 < n) {
                VarList varList = varListArray[n2];
                VarList varList2 = varList.accept(generatedBoogieAstTransformer);
                bl = bl || varList2 != varList;
                arrayList.add(varList2);
                ++n2;
            }
        }
        if (bl) {
            return new StructType(this.loc, this.boogieType, arrayList.toArray(new VarList[0]));
        }
        return this;
    }
}

