/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants;

import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.Payload;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class BranchUnfoldIcfgTransformer {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final PredicateFactory mPredicateFactory;
    private final IPredicateUnifier mPredicateUnifier;
    private IIcfg<IcfgLocation> mInputIcfg;
    private final HashRelation<IcfgLocation, IcfgLocation> mOldLoc2NewLoc = new HashRelation();
    private BasicIcfg<IcfgLocation> mResultIcfg;
    private ArrayDeque<Pair<IcfgLocation, Integer>> mWorklist;

    public BranchUnfoldIcfgTransformer(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mPredicateFactory = predicateFactory;
        this.mPredicateUnifier = iPredicateUnifier;
    }

    public IIcfg<IcfgLocation> transform(IIcfg<IcfgLocation> iIcfg) {
        this.mInputIcfg = iIcfg;
        ConstructionCache.IValueConstruction<IcfgEdge, Integer> iValueConstruction = new ConstructionCache.IValueConstruction<IcfgEdge, Integer>(){
            int mCounter = 0;

            public Integer constructValue(IcfgEdge icfgEdge) {
                return this.mCounter++;
            }
        };
        ConstructionCache constructionCache = new ConstructionCache((ConstructionCache.IValueConstruction)iValueConstruction);
        ConstructionCache.IValueConstruction<Pair<IcfgLocation, Integer>, IcfgLocation> iValueConstruction2 = new ConstructionCache.IValueConstruction<Pair<IcfgLocation, Integer>, IcfgLocation>(){

            public IcfgLocation constructValue(Pair<IcfgLocation, Integer> pair) {
                IcfgLocation icfgLocation = (IcfgLocation)pair.getFirst();
                boolean bl = BranchUnfoldIcfgTransformer.this.mInputIcfg.getInitialNodes().contains(icfgLocation);
                BranchUnfoldDebugIdentifier branchUnfoldDebugIdentifier = new BranchUnfoldDebugIdentifier(icfgLocation.getDebugIdentifier(), this.getClass(), (Integer)pair.getSecond());
                IcfgLocation icfgLocation2 = new IcfgLocation((DebugIdentifier)branchUnfoldDebugIdentifier, icfgLocation.getProcedure());
                boolean bl2 = bl;
                boolean bl3 = ((Set)BranchUnfoldIcfgTransformer.this.mInputIcfg.getProcedureErrorNodes().get(icfgLocation.getProcedure())).contains(icfgLocation);
                boolean bl4 = bl;
                boolean bl5 = BranchUnfoldIcfgTransformer.this.mInputIcfg.getLoopLocations().contains(icfgLocation);
                boolean bl6 = BranchUnfoldIcfgTransformer.this.mInputIcfg.getLocationsOfInterest().contains(icfgLocation);
                BranchUnfoldIcfgTransformer.this.mResultIcfg.addLocation(icfgLocation2, bl2, bl3, bl4, false, bl5, bl6);
                BranchUnfoldIcfgTransformer.this.mOldLoc2NewLoc.addPair((Object)icfgLocation, (Object)icfgLocation2);
                BranchUnfoldIcfgTransformer.this.mWorklist.add(pair);
                return icfgLocation2;
            }
        };
        ConstructionCache constructionCache2 = new ConstructionCache((ConstructionCache.IValueConstruction)iValueConstruction2);
        String string = iIcfg.getIdentifier() + String.valueOf(this.getClass());
        this.mResultIcfg = new BasicIcfg(string, iIcfg.getCfgSmtToolkit(), IcfgLocation.class);
        IcfgEdgeFactory icfgEdgeFactory = this.mResultIcfg.getCfgSmtToolkit().getIcfgEdgeFactory();
        this.mWorklist = new ArrayDeque();
        for (Pair<IcfgLocation, Integer> pair : this.mInputIcfg.getInitialNodes()) {
            Pair pair2 = new Pair(pair, (Object)0);
            constructionCache2.getOrConstruct((Object)pair2);
        }
        while (!this.mWorklist.isEmpty()) {
            Pair<IcfgLocation, Integer> pair;
            pair = this.mWorklist.removeFirst();
            IcfgLocation icfgLocation = (IcfgLocation)constructionCache2.getOrConstruct(pair);
            for (Pair pair2 : ((IcfgLocation)pair.getFirst()).getOutgoingEdges()) {
                Integer n = (Integer)constructionCache.getOrConstruct((Object)pair2);
                Pair pair3 = new Pair((Object)((IcfgLocation)pair2.getTarget()), (Object)n);
                IcfgLocation icfgLocation2 = (IcfgLocation)constructionCache2.getOrConstruct((Object)pair3);
                IcfgInternalTransition icfgInternalTransition = icfgEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, (IPayload)new Payload(), pair2.getTransformula());
                icfgLocation.addOutgoing((IModifiableMultigraphEdge)icfgInternalTransition);
                icfgInternalTransition.setSource((IModifiableExplicitEdgesMultigraph)icfgLocation);
                icfgInternalTransition.setTarget((IModifiableExplicitEdgesMultigraph)icfgLocation2);
                icfgLocation2.addIncoming((IModifiableMultigraphEdge)icfgInternalTransition);
            }
        }
        return this.mResultIcfg;
    }

    public Map<IcfgLocation, IPredicate> transform(Map<IcfgLocation, IPredicate> map) {
        HashMap<IcfgLocation, IPredicate> hashMap = new HashMap<IcfgLocation, IPredicate>();
        for (IcfgLocation icfgLocation : this.mOldLoc2NewLoc.getDomain()) {
            ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
            for (IcfgLocation icfgLocation2 : this.mOldLoc2NewLoc.getImage((Object)icfgLocation)) {
                arrayList.add(map.get(icfgLocation2));
            }
            hashMap.put(icfgLocation, this.mPredicateFactory.or(arrayList));
        }
        this.mInputIcfg = null;
        return hashMap;
    }

    private static final class BranchUnfoldDebugIdentifier
    extends DebugIdentifier {
        private final int mNumber;
        private final Class<?> mCreatingClass;
        private final DebugIdentifier mOriginalIdentifier;

        public BranchUnfoldDebugIdentifier(DebugIdentifier debugIdentifier, Class<?> clazz, int n) {
            this.mNumber = n;
            this.mCreatingClass = clazz;
            this.mOriginalIdentifier = debugIdentifier;
        }

        public String toString() {
            return this.mOriginalIdentifier.toString() + this.mCreatingClass.getSimpleName() + this.mNumber;
        }
    }
}

