/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class SymbolTableValue {
    private final String mBoogieName;
    private final CDeclaration mCDecl;
    private final Declaration mBoogieDecl;
    private final boolean mIsIntFromPointer;
    private final boolean mHasConstantValue;
    private final Expression mConstantValue;
    private final IASTNode mDeclarationNode;
    private final DeclarationInformation mDeclarationInformation;
    private final ASTType mAstType;

    public SymbolTableValue(String string, Declaration declaration, ASTType aSTType, CDeclaration cDeclaration, DeclarationInformation declarationInformation, IASTNode iASTNode, boolean bl) {
        this(string, declaration, aSTType, cDeclaration, declarationInformation, iASTNode, bl, null);
    }

    public SymbolTableValue(String string, Declaration declaration, ASTType aSTType, CDeclaration cDeclaration, DeclarationInformation declarationInformation, IASTNode iASTNode, boolean bl, Expression expression) {
        assert (string != null && !string.equals(""));
        assert (cDeclaration != null);
        this.mBoogieName = string;
        this.mCDecl = cDeclaration;
        this.mBoogieDecl = declaration;
        this.mAstType = aSTType;
        this.mDeclarationNode = iASTNode;
        this.mIsIntFromPointer = bl;
        this.mDeclarationInformation = declarationInformation;
        if (expression != null) {
            this.mConstantValue = expression;
            this.mHasConstantValue = true;
        } else {
            this.mConstantValue = expression;
            this.mHasConstantValue = false;
        }
    }

    public String getBoogieName() {
        return this.mBoogieName;
    }

    public CDeclaration getCDecl() {
        return this.mCDecl;
    }

    public Declaration getBoogieDecl() {
        return this.mBoogieDecl;
    }

    public ASTType getAstType() {
        return this.mAstType;
    }

    public boolean isBoogieGlobalVar() {
        return this.mDeclarationInformation.getStorageClass() == DeclarationInformation.StorageClass.GLOBAL;
    }

    public ICType getCType() {
        return this.mCDecl.getType();
    }

    public IASTNode getDeclarationNode() {
        return this.mDeclarationNode;
    }

    public boolean isIntFromPointer() {
        return this.mIsIntFromPointer;
    }

    public boolean hasConstantValue() {
        return this.mHasConstantValue;
    }

    public Expression getConstantValue() {
        if (!this.mHasConstantValue) {
            throw new IllegalStateException("check hasConstantValue() first!");
        }
        return this.mConstantValue;
    }

    public SymbolTableValue createMarkedIsIntFromPointer() {
        return new SymbolTableValue(this.mBoogieName, this.mBoogieDecl, this.mAstType, this.mCDecl, this.mDeclarationInformation, this.mDeclarationNode, true, this.mConstantValue);
    }

    public DeclarationInformation getDeclarationInformation() {
        return this.mDeclarationInformation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mCDecl.getName());
        stringBuilder.append(" : ");
        stringBuilder.append(this.mCDecl.getType());
        stringBuilder.append(" -> ");
        if (this.mBoogieDecl != null) {
            if (this.mBoogieDecl instanceof VariableDeclaration) {
                stringBuilder.append(BoogiePrettyPrinter.print((VariableDeclaration)((VariableDeclaration)this.mBoogieDecl)));
            } else {
                stringBuilder.append(this.mBoogieDecl);
            }
        } else {
            stringBuilder.append(this.mBoogieName).append(" : ?");
        }
        return stringBuilder.toString();
    }
}

