/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIntersectNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LassoExtractor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.Collection;

public final class BuchiIntersect<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private NestedWordAutomatonReachableStates<LETTER, STATE> mResult;

    public <FACTORY extends IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>> BuchiIntersect(AutomataLibraryServices automataLibraryServices, FACTORY FACTORY, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        super(automataLibraryServices);
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.doIntersect((IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>)FACTORY);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Result " + this.mResult.sizeInformation();
    }

    private <SF extends IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>> void doIntersect(SF SF) throws AutomataLibraryException {
        BuchiIntersectNwa<LETTER, STATE> buchiIntersectNwa = new BuchiIntersectNwa<LETTER, STATE>(this.mFstOperand, this.mSndOperand, SF);
        this.mResult = new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, buchiIntersectNwa);
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    @Override
    public NestedWordAutomatonReachableStates<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        boolean bl = true;
        assert (bl &= this.resultCheckWithRandomWords());
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mFstOperand, this.mSndOperand);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }

    private boolean resultCheckWithRandomWords() throws AutomataLibraryException {
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty;
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty2;
        ArrayList<NestedLassoWord<LETTER>> arrayList = new ArrayList<NestedLassoWord<LETTER>>();
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty3 = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mResult);
        if (!buchiIsEmpty3.getResult().booleanValue()) {
            arrayList.add(buchiIsEmpty3.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        if ((buchiIsEmpty2 = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mFstOperand)).getResult().booleanValue()) {
            assert (buchiIsEmpty3.getResult().booleanValue());
        } else {
            arrayList.add(buchiIsEmpty2.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        if ((buchiIsEmpty = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mSndOperand)).getResult().booleanValue()) {
            assert (buchiIsEmpty3.getResult().booleanValue());
        } else {
            arrayList.add(buchiIsEmpty.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        arrayList.add(NestedWordAutomataUtils.getRandomNestedLassoWord(this.mResult, this.mResult.size(), 0L));
        arrayList.add(NestedWordAutomataUtils.getRandomNestedLassoWord(this.mResult, this.mFstOperand.size(), 1L));
        arrayList.add(NestedWordAutomataUtils.getRandomNestedLassoWord(this.mResult, this.mSndOperand.size(), 2L));
        arrayList.addAll((Collection<NestedLassoWord<LETTER>>)new LassoExtractor<LETTER, STATE>(this.mServices, this.mFstOperand).getResult());
        arrayList.addAll((Collection<NestedLassoWord<LETTER>>)new LassoExtractor<LETTER, STATE>(this.mServices, this.mSndOperand).getResult());
        arrayList.addAll((Collection<NestedLassoWord<LETTER>>)new LassoExtractor<LETTER, STATE>(this.mServices, this.mResult).getResult());
        boolean bl = true;
        for (NestedLassoWord nestedLassoWord : arrayList) {
            assert (bl &= this.checkAcceptance(nestedLassoWord, this.mFstOperand, this.mSndOperand));
        }
        return bl;
    }

    private boolean checkAcceptance(NestedLassoWord<LETTER> nestedLassoWord, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        boolean bl;
        boolean bl2 = new BuchiAccepts<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider, nestedLassoWord).getResult();
        boolean bl3 = new BuchiAccepts<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider2, nestedLassoWord).getResult();
        return (bl2 && bl3) == (bl = new BuchiAccepts<LETTER, STATE>(this.mServices, this.mResult, nestedLassoWord).getResult().booleanValue());
    }
}

