/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;

public class ConditionMarking<LETTER, PLACE>
implements Iterable<Condition<LETTER, PLACE>>,
Serializable {
    private static final long serialVersionUID = -357669345268897194L;
    private final Set<Condition<LETTER, PLACE>> mConditions;

    public ConditionMarking(Set<Condition<LETTER, PLACE>> set) {
        this.mConditions = set;
    }

    public Set<Condition<LETTER, PLACE>> getConditions() {
        return this.mConditions;
    }

    public boolean contains(Condition<LETTER, PLACE> condition) {
        return this.mConditions.contains(condition);
    }

    public boolean containsAll(Collection<Condition<LETTER, PLACE>> collection) {
        return this.mConditions.containsAll(collection);
    }

    public boolean isEmpty() {
        return this.mConditions.isEmpty();
    }

    @Override
    public Iterator<Condition<LETTER, PLACE>> iterator() {
        return Collections.unmodifiableSet(this.mConditions).iterator();
    }

    public int size() {
        return this.mConditions.size();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConditionMarking conditionMarking = (ConditionMarking)object;
        return !(this.mConditions == null ? conditionMarking.mConditions != null : !this.mConditions.equals(conditionMarking.mConditions));
    }

    public int hashCode() {
        return 31 + (this.mConditions == null ? 0 : this.mConditions.hashCode());
    }

    public boolean isEventEnabled(Event<LETTER, PLACE> event) {
        return this.mConditions.containsAll(event.getPredecessorConditions());
    }

    public void addTo(Set<Condition<LETTER, PLACE>> set) {
        set.addAll(this.mConditions);
    }

    public ConditionMarking<LETTER, PLACE> fireEvent(Event<LETTER, PLACE> event) {
        assert (this.isEventEnabled(event));
        HashSet<Condition<LETTER, PLACE>> hashSet = new HashSet<Condition<LETTER, PLACE>>(this.mConditions);
        hashSet.removeAll(event.getPredecessorConditions());
        hashSet.addAll(event.getSuccessorConditions());
        return new ConditionMarking<LETTER, PLACE>(hashSet);
    }

    public String toString() {
        return this.mConditions.toString();
    }

    public Marking<PLACE> getMarking() throws PetriNetNot1SafeException {
        HashSet<PLACE> hashSet = new HashSet<PLACE>();
        for (Condition<LETTER, PLACE> condition : this.mConditions) {
            boolean bl = hashSet.add(condition.getPlace());
            if (bl) continue;
            throw new PetriNetNot1SafeException(this.getClass(), Collections.singleton(condition.getPlace()));
        }
        return new Marking(ImmutableSet.of(hashSet));
    }

    public Stream<Condition<LETTER, PLACE>> stream() {
        return this.mConditions.stream();
    }
}

