/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;

public class DnfToExplicitValue
extends TermTransformer {
    private final Term mTrue;

    public DnfToExplicitValue(SymbolicTools symbolicTools) {
        this.mTrue = symbolicTools.top().getFormula();
    }

    protected void convert(Term term) {
        if (term instanceof TermVariable) {
            this.setResult(term);
        } else if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            String string = applicationTerm.getFunction().getName();
            if ("=".equals(string) && DnfToExplicitValue.hasAtLeastOneConstant(applicationTerm.getParameters())) {
                this.setResult(term);
            } else {
                this.setResult(this.mTrue);
            }
        } else {
            if (term instanceof LetTerm) {
                throw new UnsupportedOperationException("We were told there are no let terms");
            }
            if (term instanceof AnnotatedTerm) {
                this.convert(((AnnotatedTerm)term).getSubterm());
            } else if (term instanceof QuantifiedFormula) {
                this.setResult(this.mTrue);
            } else {
                throw new UnsupportedOperationException("Not yet implemented: " + String.valueOf(term.getClass()));
            }
        }
    }

    private static boolean hasAtLeastOneConstant(Term[] termArray) {
        return Arrays.stream(termArray).anyMatch(term -> term instanceof ConstantTerm);
    }
}

