/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.TermToZCDDVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZTerm;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZWrapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.print.oz.PrintUtils;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.GivenPara;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.visitor.AxParaVisitor;
import net.sourceforge.czt.z.visitor.GivenParaVisitor;

public class ProcessDeclarationsVisitor
implements AxParaVisitor<Map<String, String>>,
TermVisitor<Map<String, String>>,
GivenParaVisitor<Map<String, String>> {
    protected Map<String, Integer> freeTypes;
    protected int freeTypeCounter;
    protected ZTerm term;
    protected CDD invariant;

    public ProcessDeclarationsVisitor(ZTerm zTerm) {
        this.term = zTerm;
        this.freeTypes = new HashMap<String, Integer>();
        this.freeTypeCounter = 0;
        this.invariant = CDD.TRUE;
    }

    public Map<String, String> visitAxPara(AxPara axPara) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object : axPara.getZSchText().getZDeclList()) {
            StringWriter stringWriter;
            if (object instanceof VarDecl) {
                stringWriter = new StringWriter();
                PrintUtils.print((Term)((VarDecl)object).getExpr(), (Writer)stringWriter, (SectionManager)((SectionManager)this.term.getSectionInfo()), (String)ZWrapper.getSectionName(), (Markup)Markup.UNICODE);
                for (Name name : ((VarDecl)object).getZNameList()) {
                    hashMap.put(name.toString(), stringWriter.toString());
                }
                continue;
            }
            stringWriter = new StringWriter();
            PrintUtils.print((Term)axPara, (Writer)stringWriter, (SectionManager)((SectionManager)this.term.getSectionInfo()), (String)ZWrapper.getSectionName(), (Markup)Markup.UNICODE);
            throw new RuntimeException("Only axiomatic constant definitions are supported by the Localize export.\nError while reading in\n\n" + String.valueOf(stringWriter));
        }
        if (axPara.getZSchText().getPred() != null) {
            Object object;
            object = new TermToZCDDVisitor(this.term);
            this.invariant = this.invariant.and((CDD)axPara.getZSchText().getPred().accept((Visitor)object));
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        return hashMap;
    }

    public Map<String, String> visitTerm(Term term) {
        Object[] objectArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object[] objectArray2 = objectArray = term.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map map;
            Object object = objectArray2[n2];
            if (object instanceof GivenPara) {
                map = (Map)((GivenPara)object).accept((Visitor)this);
                for (String string : map.keySet()) {
                    this.freeTypes.put(string, this.freeTypeCounter++);
                }
            } else if (object instanceof Term && (map = (Map)((Term)object).accept((Visitor)this)) != null) {
                for (String string : map.keySet()) {
                    if (hashMap.containsKey(string) && !((String)hashMap.get(string)).equals(map.get(string))) {
                        throw new RuntimeException("Different type definitions for " + string + "found!");
                    }
                    hashMap.put(string, (String)map.get(string));
                }
            }
            ++n2;
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        return hashMap;
    }

    public Map<String, String> visitGivenPara(GivenPara givenPara) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Name name : givenPara.getZNameList()) {
            if (!(name instanceof ZName)) continue;
            hashMap.put(((ZName)name).toString(), null);
        }
        return hashMap;
    }

    public Map<String, Integer> getFreeTypes() {
        return this.freeTypes;
    }

    public CDD getInvariant() {
        return this.invariant;
    }
}

