/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.ISOIEC9899TC3;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import java.math.BigInteger;
import java.util.List;

public class CStringLiteral {
    private final CharacterType mCharacterType;
    private final String mSourceCharacterString;
    private final List<BigInteger> mNumericalValues;
    private final List<BigInteger> mByteValues;
    private final CACSLPreferenceInitializer.Signedness mSignednessOfChar;

    public CStringLiteral(char[] cArray, CACSLPreferenceInitializer.Signedness signedness) {
        if (cArray.length == 0) {
            throw new AssertionError((Object)"No string literal");
        }
        if (cArray[0] == 'L') {
            this.mCharacterType = CharacterType.WCHAR_T;
            this.mSourceCharacterString = CStringLiteral.stripQuotes(cArray, 1);
        } else if (cArray[0] == 'u') {
            if (cArray[1] == '8') {
                throw new UnsupportedOperationException("utf8 string");
            }
            this.mCharacterType = CharacterType.CHAR16_T;
            this.mSourceCharacterString = CStringLiteral.stripQuotes(cArray, 1);
        } else if (cArray[0] == 'U') {
            this.mCharacterType = CharacterType.CHAR32_T;
            this.mSourceCharacterString = CStringLiteral.stripQuotes(cArray, 1);
        } else {
            this.mCharacterType = CharacterType.CHAR;
            this.mSourceCharacterString = CStringLiteral.stripQuotes(cArray, 0);
        }
        this.mSignednessOfChar = signedness;
        this.mNumericalValues = ISOIEC9899TC3.parseCharacterSequence(this.mSourceCharacterString);
        this.mNumericalValues.add(BigInteger.ZERO);
        this.mByteValues = ISOIEC9899TC3.convertCharacterSequenceToByteSequence(this.mNumericalValues, this.mSignednessOfChar);
    }

    private static String stripQuotes(char[] cArray, int n) {
        if (cArray[n] == '\"' && cArray[cArray.length - 1] == '\"') {
            return new String(cArray, n + 1, cArray.length - 2 - n);
        }
        throw new UnsupportedOperationException("unsupported representation of string literal " + String.valueOf((Object)cArray));
    }

    public List<BigInteger> getByteValues() {
        return this.mByteValues;
    }

    public static enum CharacterType {
        CHAR,
        WCHAR_T,
        CHAR16_T,
        CHAR32_T;

    }
}

