/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.chctoboogie;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.chctoboogie.GenerateBoogieAstHelper;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GenerateBoogieAst {
    Unit mResult;
    private final GenerateBoogieAstHelper mHelper;

    public GenerateBoogieAst(HashRelation<HcPredicateSymbol, HornClause> hashRelation, GenerateBoogieAstHelper generateBoogieAstHelper) {
        this.mHelper = generateBoogieAstHelper;
        this.mResult = this.generateBoogieAst(hashRelation);
    }

    private Unit generateBoogieAst(HashRelation<HcPredicateSymbol, HornClause> hashRelation) {
        ILocation iLocation = this.mHelper.getLoc();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayDeque<HcPredicateSymbol> arrayDeque = new ArrayDeque<HcPredicateSymbol>();
        HashSet<HcPredicateSymbol> hashSet = new HashSet<HcPredicateSymbol>();
        arrayDeque.push(this.mHelper.getBottomPredSym());
        hashSet.add(this.mHelper.getBottomPredSym());
        while (!arrayDeque.isEmpty()) {
            Statement[] statementArray;
            HcPredicateSymbol hcPredicateSymbol = (HcPredicateSymbol)arrayDeque.pop();
            Set set = hashRelation.getImage((Object)hcPredicateSymbol);
            HashSet<HcVar> hashSet2 = new HashSet<HcVar>();
            List<Statement> list = this.generateNondetSwitchForPred(iLocation, set, arrayDeque, hashSet, hashSet2);
            VarList[] varListArray = this.mHelper.getInParamsForHeadPredSymbol(iLocation, hcPredicateSymbol, set.isEmpty());
            ArrayList<VariableDeclaration> arrayList2 = new ArrayList<VariableDeclaration>();
            this.mHelper.updateLocalVarDecs(arrayList2, hashSet2, iLocation);
            VariableDeclaration[] variableDeclarationArray = arrayList2.toArray(new VariableDeclaration[arrayList2.size()]);
            assert (set.isEmpty() || !list.stream().anyMatch(Objects::isNull));
            if (set.isEmpty()) {
                Statement[] statementArray2 = new Statement[1];
                statementArray = statementArray2;
                statementArray2[0] = new AssumeStatement(iLocation, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)false));
            } else {
                statementArray = list.toArray(new Statement[list.size()]);
            }
            Statement[] statementArray3 = statementArray;
            Body body = new Body(iLocation, variableDeclarationArray, statementArray3);
            Procedure procedure = new Procedure(iLocation, new Attribute[0], this.mHelper.predSymToMethodName(hcPredicateSymbol), new String[0], varListArray, new VarList[0], new Specification[0], body);
            arrayList.add(procedure);
        }
        arrayList.add(this.constructMainEntryPointProcedure(iLocation));
        arrayList.addAll(this.mHelper.getDeclarationsForSkolemFunctions());
        return new Unit(iLocation, arrayList.toArray(new Declaration[arrayList.size()]));
    }

    private List<Statement> generateNondetSwitchForPred(ILocation iLocation, Set<HornClause> set, Deque<HcPredicateSymbol> deque, Set<HcPredicateSymbol> set2, Set<HcVar> set3) {
        List<Statement> list = null;
        for (HornClause hornClause : set) {
            if (SmtUtils.isFalseLiteral((Term)hornClause.getConstraintFormula())) continue;
            set3.addAll(hornClause.getBodyVariables());
            ArrayList<Statement> arrayList = new ArrayList<Statement>();
            AssumeStatement assumeStatement = new AssumeStatement(iLocation, this.mHelper.translate(hornClause.getConstraintFormula()));
            arrayList.add((Statement)assumeStatement);
            int n = 0;
            while (n < hornClause.getNoBodyPredicates()) {
                HcPredicateSymbol hcPredicateSymbol = (HcPredicateSymbol)hornClause.getBodyPredicates().get(n);
                List list2 = (List)hornClause.getBodyPredToArgs().get(n);
                if (!set2.contains(hcPredicateSymbol)) {
                    deque.push(hcPredicateSymbol);
                    set2.add(hcPredicateSymbol);
                }
                List<Expression> list3 = list2.stream().map(term -> this.mHelper.translate((Term)term)).collect(Collectors.toList());
                CallStatement callStatement = new CallStatement(iLocation, false, new VariableLHS[0], this.mHelper.predSymToMethodName(hcPredicateSymbol), list3.toArray(new Expression[list2.size()]));
                arrayList.add((Statement)callStatement);
                ++n;
            }
            list = this.mHelper.addIteBranch(iLocation, list, arrayList, ExpressionFactory.constructBooleanWildCardExpression((ILocation)iLocation));
        }
        return list;
    }

    public Unit getResult() {
        return this.mResult;
    }

    private Declaration constructMainEntryPointProcedure(ILocation iLocation) {
        CallStatement callStatement = new CallStatement(iLocation, false, new VariableLHS[0], this.mHelper.predSymToMethodName(this.mHelper.getBottomPredSym()), new Expression[0]);
        AssertStatement assertStatement = new AssertStatement(iLocation, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)false));
        Check check = new Check(Spec.CHC_SATISFIABILITY);
        check.annotate((IElement)assertStatement);
        Statement[] statementArray = new Statement[]{callStatement, assertStatement};
        Body body = new Body(iLocation, new VariableDeclaration[0], statementArray);
        return new Procedure(iLocation, new Attribute[0], this.mHelper.getNameOfMainEntryPointProc(), new String[0], new VarList[0], new VarList[0], new Specification[0], body);
    }
}

