/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BinaryStatePredicateManager;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiAutomizerUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiInterpolantAutomatonConstructionStyle;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BuchiInterpolantAutomatonBouncer<LETTER extends IAction>
extends AbstractInterpolantAutomaton<LETTER> {
    @Deprecated
    private final Set<IPredicate> mInputStemPredicates = new HashSet<IPredicate>();
    @Deprecated
    private final Set<IPredicate> mInputLoopPredicates = new HashSet<IPredicate>();
    private final Set<IPredicate> mInputAuxFreePredicates = new HashSet<IPredicate>();
    private final Set<IPredicate> mInputWithAuxPredicates = new HashSet<IPredicate>();
    private final LETTER mHondaEntererStem;
    private final LETTER mHondaEntererLoop;
    private final boolean mScroogeNondeterminismStem;
    private final boolean mScroogeNondeterminismLoop;
    private final boolean mHondaBouncerStem;
    private final boolean mHondaBouncerLoop;
    private final BinaryStatePredicateManager.BspmResult mBspmResult;
    private final Map<Set<IPredicate>, IPredicate> mStemInputPreds2ResultPreds = new HashMap<Set<IPredicate>, IPredicate>();
    private final HashRelation<IPredicate, IPredicate> mStemResPred2InputPreds = new HashRelation();
    private final Map<Set<IPredicate>, IPredicate> mLoopInputPreds2ResultPreds = new HashMap<Set<IPredicate>, IPredicate>();
    private final HashRelation<IPredicate, IPredicate> mLoopResPred2InputPreds = new HashRelation();
    private final Map<Set<IPredicate>, IPredicate> mAcceptingInputPreds2ResultPreds = new HashMap<Set<IPredicate>, IPredicate>();
    private final HashRelation<IPredicate, IPredicate> mAcceptingResPred2InputPreds = new HashRelation();
    private final Map<Set<IPredicate>, IPredicate> mRankEqInputPreds2ResultPreds = new HashMap<Set<IPredicate>, IPredicate>();
    private final HashRelation<IPredicate, IPredicate> mRankEqResPred2InputPreds = new HashRelation();
    private final PredicateUnifier mPredicateUnifier;
    private final PredicateFactory mPredicateFactory;

    public BuchiInterpolantAutomatonBouncer(CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, BinaryStatePredicateManager.BspmResult bspmResult, BuchiHoareTripleChecker buchiHoareTripleChecker, NestedLassoRun<LETTER, IPredicate> nestedLassoRun, Set<IPredicate> set, Set<IPredicate> set2, BuchiInterpolantAutomatonConstructionStyle buchiInterpolantAutomatonConstructionStyle, PredicateUnifier predicateUnifier, IUltimateServiceProvider iUltimateServiceProvider, NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton) {
        super(iUltimateServiceProvider, cfgSmtToolkit, (IHoareTripleChecker)buchiHoareTripleChecker, false, predicateUnifier.getFalsePredicate(), nestedWordAutomaton);
        this.mPredicateFactory = predicateFactory;
        this.mBspmResult = bspmResult;
        this.mPredicateUnifier = predicateUnifier;
        NestedRun nestedRun = nestedLassoRun.getStem();
        boolean bl = BuchiAutomizerUtils.isEmptyStem(nestedRun);
        if (bl) {
            this.mHondaEntererStem = null;
            this.getOrConstructAcceptingPredicate(Set.of(), true);
        } else {
            this.mHondaEntererStem = (IAction)nestedRun.getSymbol(nestedRun.getLength() - 2);
            this.getOrConstructStemPredicate(Set.of(this.mBspmResult.getStemPrecondition()), true);
        }
        NestedRun nestedRun2 = nestedLassoRun.getLoop();
        this.mHondaEntererLoop = (IAction)nestedRun2.getSymbol(nestedRun2.getLength() - 2);
        this.initializeConstruction(bl, set, set2);
        this.mScroogeNondeterminismStem = buchiInterpolantAutomatonConstructionStyle.isScroogeNondeterminismStem();
        this.mScroogeNondeterminismLoop = buchiInterpolantAutomatonConstructionStyle.isScroogeNondeterminismLoop();
        this.mHondaBouncerStem = buchiInterpolantAutomatonConstructionStyle.isBouncerStem();
        this.mHondaBouncerLoop = buchiInterpolantAutomatonConstructionStyle.isBouncerLoop();
        this.mLogger.info((Object)this.startMessage());
    }

    private void initializeConstruction(boolean bl, Set<IPredicate> set, Set<IPredicate> set2) {
        IPredicate iPredicate = this.mBspmResult.getStemPrecondition();
        if (!bl) {
            this.mInputStemPredicates.add(iPredicate);
            for (IPredicate iPredicate2 : set) {
                if (this.mInputStemPredicates.contains(iPredicate2)) continue;
                this.mInputStemPredicates.add(iPredicate2);
            }
        }
        this.mInputAuxFreePredicates.add(this.mBspmResult.getSiConjunction());
        for (IPredicate iPredicate2 : set2) {
            if (!this.mInputLoopPredicates.contains(iPredicate2)) {
                this.mInputLoopPredicates.add(iPredicate2);
            }
            if (Arrays.stream(this.mBspmResult.getOldRankVariables()).anyMatch(iPredicate2.getVars()::contains)) {
                this.mInputWithAuxPredicates.add(iPredicate2);
                continue;
            }
            this.mInputAuxFreePredicates.add(iPredicate2);
        }
    }

    protected String startMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mScroogeNondeterminismStem || this.mScroogeNondeterminismLoop) {
            stringBuilder.append("Defining Buchi interpolant automaton with scrooge nondeterminism ");
            if (this.mScroogeNondeterminismStem) {
                stringBuilder.append("in stem");
                if (this.mScroogeNondeterminismLoop) {
                    stringBuilder.append("in loop");
                }
            } else {
                stringBuilder.append("in loop");
            }
        } else {
            stringBuilder.append("Defining deterministic Buchi interpolant automaton ");
        }
        stringBuilder.append(this.mHondaBouncerStem ? "with " : "without ");
        stringBuilder.append("honda bouncer for stem and ");
        stringBuilder.append(this.mHondaBouncerLoop ? "with " : "without ");
        stringBuilder.append("honda bouncer for loop.");
        stringBuilder.append(this.mInputStemPredicates.size()).append(" stem predicates ");
        stringBuilder.append(this.mInputLoopPredicates.size()).append(" loop predicates ");
        return stringBuilder.toString();
    }

    protected String switchToReadonlyMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Switched to read-only mode: Buchi interpolant automaton has ");
        stringBuilder.append(this.mAlreadyConstructedAutomaton.size()).append(" states ");
        stringBuilder.append(this.mStemResPred2InputPreds.getDomain().size()).append(" stem states ");
        stringBuilder.append(this.mLoopResPred2InputPreds.getDomain().size()).append(" non-accepting loop states ");
        stringBuilder.append(this.mAcceptingResPred2InputPreds.getDomain().size()).append(" accepting loop states ");
        return stringBuilder.toString();
    }

    protected String switchToOnDemandConstructionMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Switched to OnTheFlyConstruction mode: Buchi interpolant automaton has ");
        stringBuilder.append(this.mAlreadyConstructedAutomaton.size()).append(" states ");
        stringBuilder.append(this.mStemResPred2InputPreds.getDomain().size()).append(" stem states ");
        stringBuilder.append(this.mLoopResPred2InputPreds.getDomain().size()).append(" non-accepting loop states ");
        stringBuilder.append(this.mAcceptingResPred2InputPreds.getDomain().size()).append(" accepting loop states ");
        return stringBuilder.toString();
    }

    protected void computeSuccs(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper) {
        if (this.isPredHierLetterFalse(iPredicate, iPredicate2, LETTER, successorComputationHelper)) {
            if (!this.mAlreadyConstructedAutomaton.contains((Object)this.mIaFalseState)) {
                this.mAlreadyConstructedAutomaton.addState(false, true, (Object)this.mIaFalseState);
                this.mLogger.debug((Object)"BenchmarkResult: Transition to False Predicate");
            }
            successorComputationHelper.addTransition(iPredicate, iPredicate2, LETTER, this.mIaFalseState);
        } else if (this.isFalseSucc(iPredicate, iPredicate2, LETTER, successorComputationHelper)) {
            if (!this.mAlreadyConstructedAutomaton.contains((Object)this.mIaFalseState)) {
                this.mAlreadyConstructedAutomaton.addState(false, true, (Object)this.mIaFalseState);
                this.mLogger.debug((Object)"BenchmarkResult: Transition to False Predicate");
            }
            successorComputationHelper.addTransition(iPredicate, iPredicate2, LETTER, this.mIaFalseState);
        } else if (this.mStemResPred2InputPreds.getDomain().contains(iPredicate)) {
            this.computeSuccsStem(iPredicate, iPredicate2, LETTER, successorComputationHelper);
        } else if (this.mAcceptingResPred2InputPreds.getDomain().contains(iPredicate)) {
            this.computeSuccsLoop(iPredicate, iPredicate2, LETTER, successorComputationHelper);
        } else if (this.mLoopResPred2InputPreds.getDomain().contains(iPredicate)) {
            this.computeSuccsLoop(iPredicate, iPredicate2, LETTER, successorComputationHelper);
        } else {
            throw new AssertionError((Object)"unknown state");
        }
        successorComputationHelper.reportSuccsComputed(iPredicate, iPredicate2, LETTER);
    }

    private boolean isPredHierLetterFalse(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper) {
        boolean bl = LETTER.getTransformula().isInfeasible() == UnmodifiableTransFormula.Infeasibility.INFEASIBLE ? true : (successorComputationHelper.isLinearPredecessorFalse(iPredicate) ? true : successorComputationHelper.isHierarchicalPredecessorFalse(iPredicate2));
        return bl;
    }

    private boolean isFalseSucc(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper) {
        IncrementalPlicationChecker.Validity validity = successorComputationHelper.computeSuccWithSolver(iPredicate, iPredicate2, LETTER, this.mIaFalseState);
        boolean bl = validity == IncrementalPlicationChecker.Validity.VALID;
        return bl;
    }

    private void computeSuccsStem(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper) {
        IPredicate iPredicate3 = this.mayEnterAcceptingFromStem(LETTER) ? this.addAcceptingSuccStem(iPredicate, iPredicate2, LETTER, successorComputationHelper) : null;
        if (iPredicate3 == null || this.mScroogeNondeterminismStem) {
            this.addNonAcceptingSuccStem(iPredicate, iPredicate2, LETTER, successorComputationHelper);
        }
    }

    private IPredicate addAcceptingSuccStem(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper) {
        IPredicate iPredicate32;
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (IPredicate iPredicate32 : this.mInputAuxFreePredicates) {
            IncrementalPlicationChecker.Validity validity = successorComputationHelper.computeSuccWithSolver(iPredicate, iPredicate2, LETTER, iPredicate32);
            if (validity != IncrementalPlicationChecker.Validity.VALID) continue;
            hashSet.add(iPredicate32);
        }
        iPredicate32 = this.getOrConstructAcceptingPredicate(hashSet, false);
        successorComputationHelper.addTransition(iPredicate, iPredicate2, LETTER, iPredicate32);
        return iPredicate32;
    }

    private IPredicate getOrConstructAcceptingPredicate(Set<IPredicate> set, boolean bl) {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>(set);
        hashSet.add(this.mBspmResult.getRankDecreaseAndBound());
        IPredicate iPredicate = this.getOrConstructPredicate(hashSet, this.mAcceptingInputPreds2ResultPreds, this.mAcceptingResPred2InputPreds);
        HashSet<IPredicate> hashSet2 = new HashSet<IPredicate>(set);
        hashSet2.add(this.mBspmResult.getRankEquality());
        IPredicate iPredicate2 = this.getOrConstructPredicate(hashSet2, this.mRankEqInputPreds2ResultPreds, this.mRankEqResPred2InputPreds);
        if (!this.mAlreadyConstructedAutomaton.contains((Object)iPredicate)) {
            this.mAlreadyConstructedAutomaton.addState(bl, true, (Object)iPredicate);
        }
        ((BuchiHoareTripleChecker)this.mIHoareTripleChecker).putDecreaseEqualPair(iPredicate, iPredicate2);
        return iPredicate;
    }

    private IPredicate getOrConstructStemPredicate(Set<IPredicate> set, boolean bl) {
        IPredicate iPredicate = this.getOrConstructPredicate(set, this.mStemInputPreds2ResultPreds, this.mStemResPred2InputPreds);
        if (!this.mAlreadyConstructedAutomaton.contains((Object)iPredicate)) {
            this.mAlreadyConstructedAutomaton.addState(bl, false, (Object)iPredicate);
        }
        return iPredicate;
    }

    private IPredicate getOrConstructLoopPredicate(Set<IPredicate> set, boolean bl) {
        IPredicate iPredicate = this.getOrConstructPredicate(set, this.mLoopInputPreds2ResultPreds, this.mLoopResPred2InputPreds);
        if (!this.mAlreadyConstructedAutomaton.contains((Object)iPredicate)) {
            this.mAlreadyConstructedAutomaton.addState(bl, false, (Object)iPredicate);
        }
        return iPredicate;
    }

    private void addNonAcceptingSuccStem(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper) {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (IPredicate iPredicate3 : this.mInputStemPredicates) {
            IncrementalPlicationChecker.Validity validity = successorComputationHelper.computeSuccWithSolver(iPredicate, iPredicate2, LETTER, iPredicate3);
            if (validity != IncrementalPlicationChecker.Validity.VALID) continue;
            hashSet.add(iPredicate3);
        }
        if (!hashSet.isEmpty()) {
            IPredicate iPredicate3;
            iPredicate3 = this.getOrConstructStemPredicate(hashSet, false);
            successorComputationHelper.addTransition(iPredicate, iPredicate2, LETTER, iPredicate3);
        }
    }

    private void computeSuccsLoop(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper) {
        IPredicate iPredicate3 = this.mayEnterAcceptingFromLoop(LETTER) ? this.addAcceptingSuccLoop(iPredicate, iPredicate2, LETTER, successorComputationHelper) : null;
        if (iPredicate3 == null || this.mScroogeNondeterminismLoop) {
            this.addNonAcceptingSuccLoop(iPredicate, iPredicate2, LETTER, successorComputationHelper);
        }
    }

    private IPredicate addAcceptingSuccLoop(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper) {
        IPredicate iPredicate32;
        IncrementalPlicationChecker.Validity validity = successorComputationHelper.computeSuccWithSolver(iPredicate, iPredicate2, LETTER, this.mBspmResult.getRankDecreaseAndBound());
        if (validity != IncrementalPlicationChecker.Validity.VALID) {
            return null;
        }
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (IPredicate iPredicate32 : this.mInputAuxFreePredicates) {
            IncrementalPlicationChecker.Validity validity2 = successorComputationHelper.computeSuccWithSolver(iPredicate, iPredicate2, LETTER, iPredicate32);
            if (validity2 != IncrementalPlicationChecker.Validity.VALID) continue;
            hashSet.add(iPredicate32);
        }
        iPredicate32 = this.getOrConstructAcceptingPredicate(hashSet, false);
        successorComputationHelper.addTransition(iPredicate, iPredicate2, LETTER, iPredicate32);
        return iPredicate32;
    }

    private void addNonAcceptingSuccLoop(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper) {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (IPredicate iPredicate3 : this.mInputLoopPredicates) {
            IncrementalPlicationChecker.Validity validity = successorComputationHelper.computeSuccWithSolver(iPredicate, iPredicate2, LETTER, iPredicate3);
            if (validity != IncrementalPlicationChecker.Validity.VALID) continue;
            hashSet.add(iPredicate3);
        }
        if (!hashSet.isEmpty()) {
            IPredicate iPredicate3;
            iPredicate3 = this.getOrConstructLoopPredicate(hashSet, false);
            successorComputationHelper.addTransition(iPredicate, iPredicate2, LETTER, iPredicate3);
        }
    }

    private IPredicate getOrConstructPredicate(Set<IPredicate> set, Map<Set<IPredicate>, IPredicate> map, HashRelation<IPredicate, IPredicate> hashRelation) {
        IPredicate iPredicate = map.get(set);
        if (iPredicate == null) {
            Term term = this.mPredicateFactory.and(set).getFormula();
            iPredicate = this.mPredicateUnifier.getOrConstructPredicate(term);
            assert (iPredicate != this.mIaFalseState) : "false should have been handeled before";
            map.put(set, iPredicate);
            for (IPredicate iPredicate2 : set) {
                hashRelation.addPair((Object)iPredicate, (Object)iPredicate2);
            }
        }
        return iPredicate;
    }

    protected boolean mayEnterAcceptingFromLoop(LETTER LETTER) {
        return !this.mHondaBouncerLoop || LETTER.equals(this.mHondaEntererLoop);
    }

    protected boolean mayEnterAcceptingFromStem(LETTER LETTER) {
        return !this.mHondaBouncerStem || LETTER.equals(this.mHondaEntererStem);
    }
}

