/*
 * Decompiled with CFR 0.152.
 */
package ap;

import ap.AbstractFileProver;
import ap.AbstractFileProver$;
import ap.CmdlMain$NullStream$;
import ap.IntelliFileProver;
import ap.ParallelFileProver;
import ap.ParallelFileProver$;
import ap.Prover;
import ap.Prover$NoCounterModel$;
import ap.Prover$NoModel$;
import ap.Prover$TimeoutResult$;
import ap.Signature;
import ap.api.SimpleAPI;
import ap.package$;
import ap.parameters.GlobalSettings;
import ap.parameters.GlobalSettings$;
import ap.parameters.Param;
import ap.parameters.Param$ASSERTIONS$;
import ap.parameters.Param$COMPUTE_UNSAT_CORE$;
import ap.parameters.Param$COUNTER_TIMEOUT$;
import ap.parameters.Param$FULL_HELP$;
import ap.parameters.Param$GENERATE_TOTALITY_AXIOMS$;
import ap.parameters.Param$INCREMENTAL$;
import ap.parameters.Param$INPUT_FORMAT$;
import ap.parameters.Param$InputFormat$;
import ap.parameters.Param$LOGO$;
import ap.parameters.Param$LOG_COUNTERS$;
import ap.parameters.Param$LOG_COUNTERS_CONT$;
import ap.parameters.Param$LOG_LEVEL$;
import ap.parameters.Param$LOG_STATS$;
import ap.parameters.Param$MOST_GENERAL_CONSTRAINT$;
import ap.parameters.Param$PORTFOLIO$;
import ap.parameters.Param$PORTFOLIO_THREAD_NUM$;
import ap.parameters.Param$PRINT_CERTIFICATE$;
import ap.parameters.Param$PRINT_DOT_CERTIFICATE_FILE$;
import ap.parameters.Param$PRINT_RUNTIME$;
import ap.parameters.Param$PRINT_SMT_FILE$;
import ap.parameters.Param$PRINT_TPTP_FILE$;
import ap.parameters.Param$PRINT_TREE$;
import ap.parameters.Param$QUIET$;
import ap.parameters.Param$RANDOM_SEED$;
import ap.parameters.Param$STDIN$;
import ap.parameters.Param$TIMEOUT$;
import ap.parameters.Param$TIMEOUT_PER$;
import ap.parameters.Param$VERSION$;
import ap.parameters.Param$WARM_UP$;
import ap.parser.IBinJunctor$;
import ap.parser.IConstant;
import ap.parser.IExpression$;
import ap.parser.IExpression$Eq$;
import ap.parser.IFormula;
import ap.parser.IFunction;
import ap.parser.IIntLit;
import ap.parser.IInterpolantSpec;
import ap.parser.INamedPart;
import ap.parser.ITerm;
import ap.parser.Internal2InputAbsy$;
import ap.parser.LineariseVisitor$;
import ap.parser.PartName;
import ap.parser.PartName$;
import ap.parser.PrincessLineariser$;
import ap.parser.SMTLineariser$;
import ap.parser.SMTParser2InputAbsy;
import ap.parser.SMTParser2InputAbsy$;
import ap.parser.Simplifier;
import ap.parser.Simplifier$;
import ap.parser.TPTPLineariser$;
import ap.parser.TPTPTParser$;
import ap.parser.TPTPTParser$ConjecturePartName$;
import ap.proof.certificates.CertFormula;
import ap.proof.certificates.CertFormula$;
import ap.proof.certificates.Certificate;
import ap.proof.certificates.CertificatePrettyPrinter;
import ap.proof.certificates.DagCertificateConverter$;
import ap.proof.certificates.DotLineariser$;
import ap.proof.tree.ProofTree;
import ap.proof.tree.QuantifiedTree$;
import ap.terfor.ConstantTerm;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.conjunctions.Quantifier;
import ap.terfor.conjunctions.Quantifier$EX$;
import ap.terfor.preds.Predicate;
import ap.theories.Theory;
import ap.util.Debug$;
import ap.util.OpCounters$;
import ap.util.Seqs$;
import ap.util.Timeout$;
import ap.util.Timer$;
import ap.util.Warmup$;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

public final class CmdlMain$ {
    public static CmdlMain$ MODULE$;
    private final String version;
    private boolean stackTraces;

    static {
        new CmdlMain$();
    }

    public String version() {
        return this.version;
    }

    public boolean stackTraces() {
        return this.stackTraces;
    }

    public void stackTraces_$eq(boolean x$1) {
        this.stackTraces = x$1;
    }

    public void printGreeting() {
        Predef$.MODULE$.println((Object)"________       _____");
        Predef$.MODULE$.println((Object)"___  __ \\_________(_)________________________________");
        Predef$.MODULE$.println((Object)"__  /_/ /_  ___/_  /__  __ \\  ___/  _ \\_  ___/_  ___/");
        Predef$.MODULE$.println((Object)"_  ____/_  /   _  / _  / / / /__ /  __/(__  )_(__  )");
        Predef$.MODULE$.println((Object)"/_/     /_/    /_/  /_/ /_/\\___/ \\___//____/ /____/");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"A Theorem Prover for First-Order Logic modulo Linear Integer Arithmetic");
        Predef$.MODULE$.println((Object)new StringBuilder(2).append("(").append(this.version()).append(")").toString());
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"(c) Philipp R\u00fcmmer, 2009-2024");
        Predef$.MODULE$.println((Object)"Contributors: Peter Backeman, Peter Baumgartner, Angelo Brillout, Zafer Esen,");
        Predef$.MODULE$.println((Object)"              Amanda Stjerna.");
        Predef$.MODULE$.println((Object)"Free software under BSD-3-Clause.");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"For more information, visit http://www.philipp.ruemmer.org/princess.shtml");
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)"Usage: princess <option>* <inputfile>*");
        Predef$.MODULE$.println();
        this.printOptions();
    }

    public void printOptions() {
        Predef$.MODULE$.println((Object)"Standard options:");
        Predef$.MODULE$.println((Object)" [+-]logo                  Print logo                               (default: +)");
        Predef$.MODULE$.println((Object)" [+-]runtime               Print elapsed runtime                    (default: +)");
        Predef$.MODULE$.println((Object)" [+-]fullHelp              Print detailed help and exit             (default: -)");
        Predef$.MODULE$.println((Object)" [+-]version               Print version and exit                   (default: -)");
        Predef$.MODULE$.println((Object)" [+-]quiet                 Suppress all output to stderr            (default: -)");
        Predef$.MODULE$.println((Object)" [+-]assert                Enable runtime assertions                (default: -)");
        Predef$.MODULE$.println((Object)" -inputFormat=val          Specify format of problem file:       (default: auto)");
        Predef$.MODULE$.println((Object)"                             auto, pri, smtlib, tptp");
        Predef$.MODULE$.println((Object)" [+-]stdin                 Read SMT-LIB 2 problems from stdin       (default: -)");
        Predef$.MODULE$.println((Object)" [+-]incremental           Incremental SMT-LIB 2 interpreter        (default: -)");
        Predef$.MODULE$.println((Object)"                             (+incremental implies -genTotalityAxioms)");
        Predef$.MODULE$.println((Object)" -timeout=val              Set a timeout in milliseconds        (default: infty)");
        Predef$.MODULE$.println((Object)" -timeoutPer=val           Set a timeout per SMT-LIB query (ms) (default: infty)");
        Predef$.MODULE$.println((Object)" [+-]model                 Compute models or countermodels          (default: -)");
        Predef$.MODULE$.println((Object)" [+-]unsatCore             Compute unsatisfiable cores              (default: -)");
        Predef$.MODULE$.println((Object)" [+-]printProof            Output the constructed proof             (default: -)");
        Predef$.MODULE$.println((Object)" [+-]mostGeneralConstraint Derive a most general constraint         (default: -)");
        Predef$.MODULE$.println((Object)"                           (quantifier elimination for PA formulae) (default: -)");
        Predef$.MODULE$.println((Object)" -clausifier=val           Choose the clausifier (none, simple)  (default: none)");
        Predef$.MODULE$.println((Object)" [+-]genTotalityAxioms     Generate totality axioms for functions   (default: +)");
    }

    public void printExoticOptions() {
        Predef$.MODULE$.println((Object)"Further general options");
        Predef$.MODULE$.println((Object)"-----------------------");
        Predef$.MODULE$.println((Object)" -timeoutSec=val           Set a timeout in seconds             (default: infty)");
        Predef$.MODULE$.println((Object)" [+-]printTree             Output the internal constraint tree     (default: -)");
        Predef$.MODULE$.println((Object)" -printSMT=filename        Output the problem in SMT-LIB format    (default: \"\")");
        Predef$.MODULE$.println((Object)" -printTPTP=filename       Output the problem in TPTP format       (default: \"\")");
        Predef$.MODULE$.println((Object)" -printDOT=filename        Output the proof in GraphViz format     (default: \"\")");
        Predef$.MODULE$.println((Object)" -portfolio=val            Use a strategy portfolio              (default: none)");
        Predef$.MODULE$.println((Object)"                             none:   off");
        Predef$.MODULE$.println((Object)"                             casc:   Optimised for CASC/TPTP");
        Predef$.MODULE$.println((Object)"                             qf_lia: Optimised for quantifier-free LIA");
        Predef$.MODULE$.println((Object)"                             bv:     Optimised for quantified BV");
        Predef$.MODULE$.println((Object)" -threads=num              Number of threads to use for portfolio   (default: 1)");
        Predef$.MODULE$.println((Object)" [+-]threads               Automatically choose number of threads   (default: -)");
        Predef$.MODULE$.println((Object)" -formulaSign=val          Optionally negate input formula       (default: auto)");
        Predef$.MODULE$.println((Object)"                             positive: do not negate");
        Predef$.MODULE$.println((Object)"                             negative: negate");
        Predef$.MODULE$.println((Object)"                             auto:     choose automatically");
        Predef$.MODULE$.println((Object)" [+-]equivInlining         Inline simple equivalences p <-> f       (default: +)");
        Predef$.MODULE$.println((Object)" -inlineSizeLimit=val      Maximum size of functions to inline    (default: 100)");
        Predef$.MODULE$.println((Object)" -randomSeed=val           Seed for randomisation");
        Predef$.MODULE$.println((Object)"                             <seed>: numeric seed             (default: 1234567)");
        Predef$.MODULE$.println((Object)"                             off:    disable randomisation");
        Predef$.MODULE$.println((Object)" -logging=flags            Comma-separated list of log flags       (default: \"\")");
        Predef$.MODULE$.println((Object)"                             Flags: tasks, splits, backtracking, stats, lemmas,");
        Predef$.MODULE$.println((Object)"                                    counters, countersCont");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Proof/interpolation options");
        Predef$.MODULE$.println((Object)"---------------------------");
        Predef$.MODULE$.println((Object)" -constructProofs=val      Extract proofs");
        Predef$.MODULE$.println((Object)"                             never");
        Predef$.MODULE$.println((Object)"                             ifInterpolating: if \\interpolant occurs (default)");
        Predef$.MODULE$.println((Object)"                             always");
        Predef$.MODULE$.println((Object)" [+-]elimInterpolantQuants Eliminate quantifiers from interpolants  (default: +)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Quantifier/constraint options");
        Predef$.MODULE$.println((Object)"-----------------------------");
        Predef$.MODULE$.println((Object)" [+-]posUnitResolution     Resolution of clauses with literals in   (default: +)");
        Predef$.MODULE$.println((Object)"                           the antecedent");
        Predef$.MODULE$.println((Object)" [+-]useStrengthenTree     For quantified formulae with inequality  (default: -)");
        Predef$.MODULE$.println((Object)"                           side conditions, use the StrengthenTree");
        Predef$.MODULE$.println((Object)"                           constraint tree constructor");
        Predef$.MODULE$.println((Object)" -simplifyConstraints=val  How to simplify constraints:");
        Predef$.MODULE$.println((Object)"                             none:   not at all");
        Predef$.MODULE$.println((Object)"                             fair:   fair construction of a proof");
        Predef$.MODULE$.println((Object)"                             lemmas: proof construction with lemmas (default)");
        Predef$.MODULE$.println((Object)" -mgcFormat=val            Most general constraints in specific format:");
        Predef$.MODULE$.println((Object)"                             any: Unspecified                       (default)");
        Predef$.MODULE$.println((Object)"                             dnf: disjunctive normal form");
        Predef$.MODULE$.println((Object)"                             cnf: conjunctive normal form");
        Predef$.MODULE$.println((Object)" [+-]traceConstraintSimplifier  Show constraint simplifications     (default: -)");
        Predef$.MODULE$.println((Object)" [+-]dnfConstraints        Continuously rewrite constraints to DNF  (default: +)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Function options");
        Predef$.MODULE$.println((Object)"----------------");
        Predef$.MODULE$.println((Object)" -generateTriggers=val     Automatically choose triggers for quant. formulae");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)"                             complete, completeFrugal: in combination");
        Predef$.MODULE$.println((Object)"                               with -genTotalityAxioms, in such a way");
        Predef$.MODULE$.println((Object)"                               that completeness is not affected");
        Predef$.MODULE$.println((Object)" -triggerStrategy=val      How to choose triggers for quantified formulae");
        Predef$.MODULE$.println((Object)"                             allMinimal");
        Predef$.MODULE$.println((Object)"                             allMinimalAndEmpty");
        Predef$.MODULE$.println((Object)"                             allMaximal");
        Predef$.MODULE$.println((Object)"                             maximal                                (default)");
        Predef$.MODULE$.println((Object)"                             maximalOutermost");
        Predef$.MODULE$.println((Object)" -functionGC=val           Garbage-collect function terms");
        Predef$.MODULE$.println((Object)"                             none:  not at all");
        Predef$.MODULE$.println((Object)"                             total: for all total functions         (default)");
        Predef$.MODULE$.println((Object)"                             all:   for all functions");
        Predef$.MODULE$.println((Object)" [+-]tightFunctionScopes   Keep function application defs. local    (default: +)");
        Predef$.MODULE$.println((Object)" [+-]boolFunsAsPreds       In smtlib and tptp, encode               (default: -)");
        Predef$.MODULE$.println((Object)"                           Boolean functions as predicates");
        Predef$.MODULE$.println((Object)" [+-]reverseFunctionalityPropagation  Infer distinctness of         (default: -)");
        Predef$.MODULE$.println((Object)"                           arguments from distinctness of results");
        Predef$.MODULE$.println((Object)" [+-]useFunctionalConsistencyTheory  Use dummy theory to represent  (default: -)");
        Predef$.MODULE$.println((Object)"                           functional consistency axioms");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Theory options");
        Predef$.MODULE$.println((Object)"--------------");
        Predef$.MODULE$.println((Object)" -mulProcedure=val         Handling of nonlinear integer formulae");
        Predef$.MODULE$.println((Object)"                             bitShift: shift-and-add axiom");
        Predef$.MODULE$.println((Object)"                             native:   built-in theory solver       (default)");
        Predef$.MODULE$.println((Object)" -mulSplitting=val         Splitting in nonlinear integer formulae");
        Predef$.MODULE$.println((Object)"                             sign:        +/-/interval splitting    (default)");
        Predef$.MODULE$.println((Object)"                             signMinimal: +/-/interval, minimal var set");
        Predef$.MODULE$.println((Object)" -adtMeasure=val           Measure to ensure acyclicity of ADTs");
        Predef$.MODULE$.println((Object)"                             relDepth: relative depth of terms");
        Predef$.MODULE$.println((Object)"                             size:     size of terms                (default)");
        Predef$.MODULE$.println((Object)" -stringSolver=val         Specify the used string solver");
        Predef$.MODULE$.println((Object)"                             (default: ap.theories.strings.SeqStringTheory)");
        Predef$.MODULE$.println((Object)" -seqSolver=val            Specify the used sequence solver");
        Predef$.MODULE$.println((Object)"                             (default: ap.theories.sequences.ArraySeqTheory)");
        Predef$.MODULE$.println((Object)" [+-]stringEscapes         Accept extended set of string escapes    (default: -)");
    }

    private void printSMT(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null ? string != null : !object.equals(string)) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_SMT_FILE$.MODULE$.apply(settings);
            String string2 = "-";
            if (object2 == null ? string2 != null : !object2.equals(string2)) {
                Predef$.MODULE$.println((Object)new StringBuilder(28).append("Saving in SMT format to ").append(Param$PRINT_SMT_FILE$.MODULE$.apply(settings)).append(" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_SMT_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CmdlMain$.linearise$1(prover, filename));
                out.close();
                return;
            }
            CmdlMain$.linearise$1(prover, filename);
            return;
        }
    }

    private void printTPTP(AbstractFileProver prover, String filename, GlobalSettings settings) {
        Object object = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null ? string != null : !object.equals(string)) {
            Predef$.MODULE$.println();
            Object object2 = Param$PRINT_TPTP_FILE$.MODULE$.apply(settings);
            String string2 = "-";
            if (object2 == null ? string2 != null : !object2.equals(string2)) {
                Predef$.MODULE$.println((Object)new StringBuilder(29).append("Saving in TPTP format to ").append(Param$PRINT_TPTP_FILE$.MODULE$.apply(settings)).append(" ...").toString());
                FileOutputStream out = new FileOutputStream((String)Param$PRINT_TPTP_FILE$.MODULE$.apply(settings));
                Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CmdlMain$.linearise$2(prover, filename));
                out.close();
                return;
            }
            CmdlMain$.linearise$2(prover, filename);
            return;
        }
    }

    private void printCertificate(Certificate cert, GlobalSettings settings, Prover prover, Enumeration.Value format) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$COMPUTE_UNSAT_CORE$.MODULE$.apply(settings))) {
            Console$.MODULE$.err().println();
            Console$.MODULE$.err().println("Unsatisfiable core:");
            scala.collection.immutable.Set usedNames = (scala.collection.immutable.Set)prover.getAssumedFormulaParts(cert).$minus((Object)PartName$.MODULE$.NO_NAME());
            scala.collection.immutable.Set nameStrings = (scala.collection.immutable.Set)usedNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PartName partName = x0$1;
                Option<String> option = TPTPTParser$ConjecturePartName$.MODULE$.unapply(partName);
                if (!option.isEmpty()) {
                    String n = (String)option.get();
                    return n;
                }
                return partName.toString();
            }, Set$.MODULE$.canBuildFrom());
            Predef$.MODULE$.println((Object)new StringBuilder(2).append("{").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameStrings.toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$))).mkString(", ")).append("}").toString());
        }
        if (BoxesRunTime.unboxToBoolean((Object)Param$PRINT_CERTIFICATE$.MODULE$.apply(settings))) {
            this.printTextCertificate(cert, settings, prover, format);
        }
        Object object = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
        String string = "";
        if (object == null ? string != null : !object.equals(string)) {
            this.printDOTCertificate(cert, settings);
            return;
        }
    }

    private void printTextCertificate(Certificate cert, GlobalSettings settings, Prover prover, Enumeration.Value format) {
        Predef$.MODULE$.println();
        this.doPrintTextCertificate(cert, prover.getFormulaParts(), prover.getPredTranslation(), format);
    }

    public void doPrintTextCertificate(Certificate cert, Map<PartName, Conjunction> rawFormulaParts, Map<Predicate, IFunction> predTranslation, Enumeration.Value format) {
        CertificatePrettyPrinter.FormulaPrinter formulaPrinter;
        Map formulaParts = rawFormulaParts.mapValues((Function1 & Serializable & scala.Serializable)f -> CertFormula$.MODULE$.apply(f.negate()));
        Seq<Certificate> dagCert = DagCertificateConverter$.MODULE$.apply(cert);
        Enumeration.Value value = format;
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.Princess();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            formulaPrinter = new CertificatePrettyPrinter.PrincessFormulaPrinter(predTranslation);
        } else {
            Enumeration.Value value4 = Param$InputFormat$.MODULE$.TPTP();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                formulaPrinter = new CertificatePrettyPrinter.TPTPFormulaPrinter(predTranslation);
            } else {
                Enumeration.Value value6 = Param$InputFormat$.MODULE$.SMTLIB();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    formulaPrinter = new CertificatePrettyPrinter.SMTLIBFormulaPrinter(predTranslation);
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        CertificatePrettyPrinter.PrincessFormulaPrinter formulaPrinter2 = formulaPrinter;
        CertificatePrettyPrinter printer = new CertificatePrettyPrinter(formulaPrinter2);
        Enumeration.Value value8 = format;
        Enumeration.Value value9 = Param$InputFormat$.MODULE$.TPTP();
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            Predef$.MODULE$.println((Object)"% SZS output start Proof for theBenchmark");
        }
        printer.apply(dagCert, (Map<PartName, CertFormula>)formulaParts);
        Enumeration.Value value10 = format;
        Enumeration.Value value11 = Param$InputFormat$.MODULE$.TPTP();
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            Predef$.MODULE$.println((Object)"% SZS output end Proof for theBenchmark");
            return;
        }
    }

    private void printDOTCertificate(Certificate cert, GlobalSettings settings) {
        Console$.MODULE$.err().println();
        Object object = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings);
        String string = "-";
        if (object == null ? string != null : !object.equals(string)) {
            Console$.MODULE$.err().println(new StringBuilder(45).append("Saving certificate in GraphViz format to ").append(Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings)).append(" ...").toString());
            FileOutputStream out = new FileOutputStream((String)Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings));
            Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DotLineariser$.MODULE$.apply(cert));
            out.close();
            return;
        }
        DotLineariser$.MODULE$.apply(cert);
    }

    public Enumeration.Value determineInputFormat(String filename, GlobalSettings settings) {
        Enumeration.Value value = (Enumeration.Value)Param$INPUT_FORMAT$.MODULE$.apply(settings);
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.Auto();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            if (filename.endsWith(".pri")) {
                return Param$InputFormat$.MODULE$.Princess();
            }
            if (filename.endsWith(".smt2")) {
                return Param$InputFormat$.MODULE$.SMTLIB();
            }
            if (filename.endsWith(".p")) {
                return Param$InputFormat$.MODULE$.TPTP();
            }
            throw new Exception("could not figure out the input format (recognised types: .pri, .smt2, .p)");
        }
        return value;
    }

    private void printFormula(IFormula f, Enumeration.Value format) {
        Enumeration.Value value = format;
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            SMTLineariser$.MODULE$.apply(f);
            Predef$.MODULE$.println();
            return;
        }
        PrincessLineariser$.MODULE$.printExpression(f);
        Predef$.MODULE$.println();
    }

    private void printModel(IFormula model, Enumeration.Value format) {
        Enumeration.Value value = format;
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            SMTLineariser$.MODULE$.printModel(model);
            return;
        }
        this.printFormula(model, format);
    }

    private void printFormula(Conjunction c, Enumeration.Value format) {
        this.printFormula(new Simplifier(Simplifier$.MODULE$.$lessinit$greater$default$1(), Simplifier$.MODULE$.$lessinit$greater$default$2()).apply(Internal2InputAbsy$.MODULE$.apply(c)), format);
    }

    private int existentialConstantNum(ProofTree p) {
        ProofTree proofTree = p;
        Option<Tuple3<Quantifier, Seq<ConstantTerm>, ProofTree>> option = QuantifiedTree$.MODULE$.unapply(proofTree);
        if (!option.isEmpty()) {
            Quantifier quantifier = (Quantifier)((Tuple3)option.get())._1();
            Seq consts = (Seq)((Tuple3)option.get())._2();
            ProofTree subtree = (ProofTree)((Tuple3)option.get())._3();
            if (Quantifier$EX$.MODULE$.equals(quantifier)) {
                return this.existentialConstantNum(subtree) + consts.size();
            }
        }
        return BoxesRunTime.unboxToInt((Object)proofTree.subtrees().iterator().map((Function1 & Serializable & scala.Serializable)st -> BoxesRunTime.boxToInteger((int)CmdlMain$.MODULE$.existentialConstantNum(st))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private boolean counterPrintingEnabled(GlobalSettings settings) {
        return !Seqs$.MODULE$.disjoint((Set)Param$LOG_LEVEL$.MODULE$.apply(settings), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Param.LOG_FLAG[]{Param$LOG_COUNTERS$.MODULE$, Param$LOG_COUNTERS_CONT$.MODULE$})));
    }

    private boolean needsCounters(GlobalSettings settings) {
        return this.counterPrintingEnabled(settings) || BoxesRunTime.unboxToLong((Object)Param$COUNTER_TIMEOUT$.MODULE$.apply(settings)) != Long.MAX_VALUE;
    }

    private void warmup(GlobalSettings settings) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$WARM_UP$.MODULE$.apply(settings))) {
            Warmup$.MODULE$.apply();
            return;
        }
    }

    private <A> A withStatistics(GlobalSettings settings, Function0<A> comp) {
        Object object;
        Debug$.MODULE$.enableAllAssertions(BoxesRunTime.unboxToBoolean((Object)Param$ASSERTIONS$.MODULE$.apply(settings)));
        long timeBefore = System.currentTimeMillis();
        if (this.needsCounters(settings)) {
            OpCounters$.MODULE$.init();
        } else {
            OpCounters$.MODULE$.disable();
        }
        try {
            object = comp.apply();
        }
        finally {
            long timeAfter = System.currentTimeMillis();
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (BoxesRunTime.unboxToBoolean((Object)Param$PRINT_RUNTIME$.MODULE$.apply(settings))) {
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)new StringBuilder(2).append(timeAfter - timeBefore).append("ms").toString());
                }
                if (((SetLike)Param$LOG_LEVEL$.MODULE$.apply(settings)).contains((Object)Param$LOG_STATS$.MODULE$)) {
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)"Statistics:");
                    Predef$.MODULE$.println((Object)Timer$.MODULE$);
                    Timer$.MODULE$.reset();
                }
                if (MODULE$.counterPrintingEnabled(settings)) {
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)"Counters:");
                    OpCounters$.MODULE$.printCounters();
                    return;
                }
            });
        }
        return (A)object;
    }

    public Option<Prover.Result> proveProblemNonInc(GlobalSettings settings, String name, Function0<Reader> reader, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        None$ none$;
        try {
            GlobalSettings baseSettings = Param$INPUT_FORMAT$.MODULE$.set(settings, format);
            none$ = (Option)this.withStatistics(settings, () -> CmdlMain$.$anonfun$proveProblemNonInc$1(settings, baseSettings, name, format, reader, userDefStoppingCond));
        }
        catch (StackOverflowError stackOverflowError) {
            Enumeration.Value value = format;
            Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                Predef$.MODULE$.println((Object)"unknown");
            }
            Console$.MODULE$.err().println("Stack overflow, giving up");
            none$ = None$.MODULE$;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Enumeration.Value value = format;
            Enumeration.Value value3 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(value != null ? !value.equals(value3) : value3 != null)) {
                Predef$.MODULE$.println((Object)"unknown");
            }
            Console$.MODULE$.err().println("Out of memory, giving up");
            System.gc();
            none$ = None$.MODULE$;
        }
        catch (Throwable e) {
            if (this.stackTraces()) {
                e.printStackTrace();
            }
            Enumeration.Value value = format;
            Enumeration.Value value4 = Param$InputFormat$.MODULE$.SMTLIB();
            if (!(value != null ? !value.equals(value4) : value4 != null)) {
                String string = e.getMessage();
                if (string == null) {
                    Predef$.MODULE$.println((Object)"error");
                } else {
                    Predef$.MODULE$.println((Object)new StringBuilder(10).append("(error \"").append(SMTLineariser$.MODULE$.escapeString(string)).append("\")").toString());
                }
            } else {
                String string = e.getMessage();
                if (string == null) {
                    Predef$.MODULE$.println((Object)"ERROR");
                } else {
                    Predef$.MODULE$.println((Object)new StringBuilder(7).append("ERROR: ").append(string).toString());
                }
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void proveProblemInc(GlobalSettings settings, Reader input, Function0<Object> userDefStoppingCond) {
        block4: {
            try {
                this.withStatistics(settings, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    boolean x$1 = BoxesRunTime.unboxToBoolean((Object)Param$ASSERTIONS$.MODULE$.apply(settings));
                    boolean x$2 = false;
                    boolean x$3 = BoxesRunTime.unboxToBoolean((Object)Param$GENERATE_TOTALITY_AXIOMS$.MODULE$.apply(settings));
                    Option x$4 = (Option)Param$RANDOM_SEED$.MODULE$.apply(settings);
                    boolean x$5 = package$.MODULE$.SimpleAPI().withProver$default$3();
                    String x$6 = package$.MODULE$.SimpleAPI().withProver$default$4();
                    boolean x$7 = package$.MODULE$.SimpleAPI().withProver$default$5();
                    String x$8 = package$.MODULE$.SimpleAPI().withProver$default$6();
                    File x$9 = package$.MODULE$.SimpleAPI().withProver$default$7();
                    boolean x$10 = package$.MODULE$.SimpleAPI().withProver$default$8();
                    GlobalSettings x$11 = package$.MODULE$.SimpleAPI().withProver$default$11();
                    Function1 & Serializable & scala.Serializable x$12 = (Function1 & Serializable & scala.Serializable)p -> {
                        CmdlMain$.$anonfun$proveProblemInc$2(settings, input, userDefStoppingCond, p);
                        return BoxedUnit.UNIT;
                    };
                    package$.MODULE$.SimpleAPI().withProver(x$1, x$2, x$5, x$6, x$7, x$8, x$9, x$10, x$3, (Option<Object>)x$4, x$11, x$12);
                });
            }
            catch (StackOverflowError stackOverflowError) {
                Predef$.MODULE$.println((Object)"unknown");
                Console$.MODULE$.err().println("Stack overflow, giving up");
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Predef$.MODULE$.println((Object)"unknown");
                Console$.MODULE$.err().println("Out of memory, giving up");
                System.gc();
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)"error");
                Console$.MODULE$.err().println(e.getMessage());
                if (!this.stackTraces()) break block4;
                e.printStackTrace();
            }
        }
    }

    public Object proveProblem(GlobalSettings settings, String name, Function0<Reader> input, Function0<Object> userDefStoppingCond, Enumeration.Value format) {
        Console$.MODULE$.err().println(new StringBuilder(12).append("Loading ").append(name).append(" ...").toString());
        Enumeration.Value value = format;
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null) && BoxesRunTime.unboxToBoolean((Object)Param$INCREMENTAL$.MODULE$.apply(settings))) {
            this.proveProblemInc(settings, (Reader)input.apply(), userDefStoppingCond);
            return BoxedUnit.UNIT;
        }
        return this.proveProblemNonInc(settings, name, input, userDefStoppingCond, format);
    }

    public void printResult(Prover prover, GlobalSettings settings, String name, Enumeration.Value format) {
        Enumeration.Value value = format;
        Enumeration.Value value2 = Param$InputFormat$.MODULE$.SMTLIB();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Prover.Result result = prover.result();
            if (result instanceof Prover.Proof) {
                Prover.Proof proof = (Prover.Proof)result;
                ProofTree tree = proof.tree();
                Predef$.MODULE$.println((Object)"unsat");
                this.maybePrintTree(tree, settings, true);
            } else if (result instanceof Prover.ProofWithModel) {
                Prover.ProofWithModel proofWithModel = (Prover.ProofWithModel)result;
                ProofTree tree = proofWithModel.tree();
                Predef$.MODULE$.println((Object)"unsat");
                this.maybePrintTree(tree, settings, true);
            } else if (result instanceof Prover.NoProof) {
                Predef$.MODULE$.println((Object)"unknown");
            } else if (result instanceof Prover.Invalid) {
                Predef$.MODULE$.println((Object)"sat");
            } else if (result instanceof Prover.CounterModel) {
                Prover.CounterModel counterModel = (Prover.CounterModel)result;
                Option<IFormula> optModel = counterModel.counterModel();
                Predef$.MODULE$.println((Object)"sat");
                optModel.foreach((Function1 & Serializable & scala.Serializable)model -> {
                    CmdlMain$.MODULE$.printModel(model, format);
                    return BoxedUnit.UNIT;
                });
            } else if (result instanceof Prover.MaybeCounterModel) {
                Prover.MaybeCounterModel maybeCounterModel = (Prover.MaybeCounterModel)result;
                Option<IFormula> optModel = maybeCounterModel.counterModel();
                Predef$.MODULE$.println((Object)"unknown");
                optModel.foreach((Function1 & Serializable & scala.Serializable)model -> {
                    CmdlMain$.MODULE$.printModel(model, format);
                    return BoxedUnit.UNIT;
                });
            } else if (Prover$NoCounterModel$.MODULE$.equals(result)) {
                Predef$.MODULE$.println((Object)"unsat");
            } else if (result instanceof Prover.NoCounterModelCert) {
                Prover.NoCounterModelCert noCounterModelCert = (Prover.NoCounterModelCert)result;
                Certificate cert = noCounterModelCert.certificate();
                Predef$.MODULE$.println((Object)"unsat");
                this.printCertificate(cert, settings, prover, format);
            } else if (result instanceof Prover.NoCounterModelCertInter) {
                Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result;
                Certificate cert = noCounterModelCertInter.certificate();
                Seq<IFormula> inters = noCounterModelCertInter.interpolants();
                Predef$.MODULE$.println((Object)"unsat");
                this.printCertificate(cert, settings, prover, format);
                Predef$.MODULE$.println((Object)"(");
                inters.foreach((Function1 & Serializable & scala.Serializable)i -> {
                    CmdlMain$.$anonfun$printResult$3(format, i);
                    return BoxedUnit.UNIT;
                });
                Predef$.MODULE$.println((Object)")");
            } else if (result instanceof Prover.Model) {
                Predef$.MODULE$.println((Object)"unsat");
            } else if (result instanceof Prover.AllModels) {
                Predef$.MODULE$.println((Object)"unsat");
            } else if (Prover$NoModel$.MODULE$.equals(result)) {
                Predef$.MODULE$.println((Object)"sat");
            } else if (result instanceof Prover.TimeoutProof) {
                Prover.TimeoutProof timeoutProof = (Prover.TimeoutProof)result;
                ProofTree tree = timeoutProof.unfinishedTree();
                Predef$.MODULE$.println((Object)"unknown");
                Console$.MODULE$.err().println("Cancelled or timeout");
                this.maybePrintTree(tree, settings, true);
            } else if (Prover$TimeoutResult$.MODULE$.unapply(result)) {
                Predef$.MODULE$.println((Object)"unknown");
                Console$.MODULE$.err().println("Cancelled or timeout");
            } else {
                throw new Exception(new StringBuilder(23).append("Unknown prover result: ").append(result).toString());
            }
            return;
        }
        Enumeration.Value value4 = Param$InputFormat$.MODULE$.TPTP();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            Prover.Result result = prover.result();
            if (result instanceof Prover.Proof) {
                Prover.Proof proof = (Prover.Proof)result;
                ProofTree tree = proof.tree();
                this.printTPTPResult(true, prover, name);
                this.maybePrintTree(tree, settings, true);
            } else if (result instanceof Prover.ProofWithModel) {
                Prover.ProofWithModel proofWithModel = (Prover.ProofWithModel)result;
                ProofTree tree = proofWithModel.tree();
                this.printTPTPResult(true, prover, name);
                this.maybePrintTree(tree, settings, true);
            } else if (result instanceof Prover.NoProof) {
                Predef$.MODULE$.println((Object)new StringBuilder(24).append("% SZS status GaveUp for ").append(name).toString());
            } else if (result instanceof Prover.Invalid) {
                this.printTPTPResult(false, prover, name);
            } else if (result instanceof Prover.CounterModel) {
                Prover.CounterModel counterModel = (Prover.CounterModel)result;
                Option<IFormula> optModel = counterModel.counterModel();
                this.printTPTPResult(false, prover, name);
                this.maybePrintModel(optModel, "Countermodel", true, format);
            } else if (result instanceof Prover.MaybeCounterModel) {
                Prover.MaybeCounterModel maybeCounterModel = (Prover.MaybeCounterModel)result;
                Option<IFormula> optModel = maybeCounterModel.counterModel();
                Predef$.MODULE$.println((Object)new StringBuilder(24).append("% SZS status GaveUp for ").append(name).toString());
                this.maybePrintModel(optModel, "Possible countermodel", true, format);
            } else if (Prover$NoCounterModel$.MODULE$.equals(result)) {
                this.printTPTPResult(true, prover, name);
            } else if (result instanceof Prover.NoCounterModelCert) {
                Prover.NoCounterModelCert noCounterModelCert = (Prover.NoCounterModelCert)result;
                Certificate cert = noCounterModelCert.certificate();
                this.printTPTPResult(true, prover, name);
                this.printCertificate(cert, settings, prover, format);
            } else if (result instanceof Prover.NoCounterModelCertInter) {
                Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result;
                Certificate cert = noCounterModelCertInter.certificate();
                Seq<IFormula> inters = noCounterModelCertInter.interpolants();
                this.printTPTPResult(true, prover, name);
                Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)"Interpolants:");
                    inters.foreach((Function1 & Serializable & scala.Serializable)i -> {
                        CmdlMain$.MODULE$.printFormula(i, format);
                        return BoxedUnit.UNIT;
                    });
                });
                this.printCertificate(cert, settings, prover, format);
            } else if (result instanceof Prover.Model) {
                Prover.Model model2 = (Prover.Model)result;
                Option<IFormula> optModel = model2.model();
                this.printTPTPResult(true, prover, name);
                this.maybePrintModel(optModel, "Under the assignment", true, format);
            } else if (result instanceof Prover.AllModels) {
                Prover.AllModels allModels = (Prover.AllModels)result;
                Option<IFormula> optModel = allModels.model();
                this.printTPTPResult(true, prover, name);
                this.maybePrintModel(optModel, "Concrete witness", true, format);
            } else if (Prover$NoModel$.MODULE$.equals(result)) {
                this.printTPTPResult(false, prover, name);
            } else if (result instanceof Prover.TimeoutProof) {
                Predef$.MODULE$.println((Object)new StringBuilder(25).append("% SZS status Timeout for ").append(name).toString());
            } else if (Prover$TimeoutResult$.MODULE$.unapply(result)) {
                Predef$.MODULE$.println((Object)new StringBuilder(25).append("% SZS status Timeout for ").append(name).toString());
            } else {
                throw new Exception(new StringBuilder(23).append("Unknown prover result: ").append(result).toString());
            }
            return;
        }
        Prover.Result result = prover.result();
        if (result instanceof Prover.Proof) {
            Prover.Proof proof = (Prover.Proof)result;
            ProofTree tree = proof.tree();
            IFormula constraint = proof.constraint();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintConstraint(constraint, settings, format);
            this.maybePrintTree(tree, settings, this.maybePrintTree$default$3());
        } else if (result instanceof Prover.ProofWithModel) {
            Prover.ProofWithModel proofWithModel = (Prover.ProofWithModel)result;
            ProofTree tree = proofWithModel.tree();
            IFormula constraint = proofWithModel.constraint();
            IFormula model3 = proofWithModel.model();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintConstraint(constraint, settings, format);
            IFormula iFormula = model3;
            if (LineariseVisitor$.MODULE$.apply(constraint, IBinJunctor$.MODULE$.And()).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CmdlMain$.$anonfun$printResult$6(x0$1)))) {
            } else {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Concrete witness:");
                this.printModel(model3, format);
            }
            this.maybePrintTree(tree, settings, this.maybePrintTree$default$3());
        } else if (result instanceof Prover.NoProof) {
            Predef$.MODULE$.println((Object)"UNKNOWN");
            this.maybePrintFixedConstraint(false, "Most-general constraint", settings);
        } else if (result instanceof Prover.Invalid) {
            Predef$.MODULE$.println((Object)"INVALID");
            this.maybePrintFixedConstraint(false, "Most-general constraint", settings);
        } else if (result instanceof Prover.CounterModel) {
            Prover.CounterModel counterModel = (Prover.CounterModel)result;
            Option<IFormula> optModel = counterModel.counterModel();
            Predef$.MODULE$.println((Object)"INVALID");
            this.maybePrintModel(optModel, "Countermodel", this.maybePrintModel$default$3(), format);
            this.maybePrintFixedConstraint(false, "Most-general constraint", settings);
        } else if (result instanceof Prover.MaybeCounterModel) {
            Prover.MaybeCounterModel maybeCounterModel = (Prover.MaybeCounterModel)result;
            Option<IFormula> optModel = maybeCounterModel.counterModel();
            Predef$.MODULE$.println((Object)"UNKNOWN");
            this.maybePrintModel(optModel, "Possible countermodel", this.maybePrintModel$default$3(), format);
            this.maybePrintFixedConstraint(false, "Most-general constraint", settings);
        } else if (Prover$NoCounterModel$.MODULE$.equals(result)) {
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintFixedConstraint(true, "Most-general constraint", settings);
        } else if (result instanceof Prover.NoCounterModelCert) {
            Prover.NoCounterModelCert noCounterModelCert = (Prover.NoCounterModelCert)result;
            Certificate cert = noCounterModelCert.certificate();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintFixedConstraint(true, "Most-general constraint", settings);
            this.printCertificate(cert, settings, prover, format);
        } else if (result instanceof Prover.NoCounterModelCertInter) {
            Prover.NoCounterModelCertInter noCounterModelCertInter = (Prover.NoCounterModelCertInter)result;
            Certificate cert = noCounterModelCertInter.certificate();
            Seq<IFormula> inters = noCounterModelCertInter.interpolants();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintFixedConstraint(true, "Most-general constraint", settings);
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Interpolants:");
            inters.foreach((Function1 & Serializable & scala.Serializable)i -> {
                CmdlMain$.MODULE$.printFormula(i, format);
                return BoxedUnit.UNIT;
            });
            this.printCertificate(cert, settings, prover, format);
        } else if (result instanceof Prover.Model) {
            Prover.Model model4 = (Prover.Model)result;
            Option<IFormula> optModel = model4.model();
            Predef$.MODULE$.println((Object)"VALID");
            this.maybePrintModel(optModel, "Under the assignment", this.maybePrintModel$default$3(), format);
        } else if (result instanceof Prover.AllModels) {
            Prover.AllModels allModels = (Prover.AllModels)result;
            IFormula constraint = allModels.constraint();
            Option<IFormula> optModel = allModels.model();
            Predef$.MODULE$.println((Object)"VALID");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Equivalent constraint:");
                this.printFormula(constraint, format);
            }
            this.maybePrintModel(optModel, "Concrete witness", this.maybePrintModel$default$3(), format);
        } else if (Prover$NoModel$.MODULE$.equals(result)) {
            Predef$.MODULE$.println((Object)"INVALID");
            this.maybePrintFixedConstraint(false, "Equivalent constraint", settings);
        } else if (result instanceof Prover.TimeoutProof) {
            Object object;
            Prover.TimeoutProof timeoutProof = (Prover.TimeoutProof)result;
            ProofTree tree = timeoutProof.unfinishedTree();
            Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
            if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Current constraint:");
                object = Timeout$.MODULE$.withTimeoutMillis(1000L, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.printFormula(tree.closingConstraint(), format), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.println((Object)"(timeout)"));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.maybePrintTree(tree, settings, this.maybePrintTree$default$3());
        } else if (Prover$TimeoutResult$.MODULE$.unapply(result)) {
            Predef$.MODULE$.println((Object)"CANCELLED/TIMEOUT");
            this.maybePrintFixedConstraint(false, "Current constraint", settings);
        } else {
            throw new Exception(new StringBuilder(23).append("Unknown prover result: ").append(result).toString());
        }
    }

    private boolean containsTPTPConjecture(Prover p) {
        return p.getInputFormulaParts().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CmdlMain$.$anonfun$containsTPTPConjecture$1(x0$1)));
    }

    /*
     * Unable to fully structure code
     */
    private void printTPTPResult(boolean positive, Prover prover, String name) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        var6_4 = new Tuple2.mcZZ.sp(positive, this.containsTPTPConjecture(prover));
                        if (var6_4 == null) break block2;
                        var7_5 = var6_4._1$mcZ$sp();
                        var8_6 = var6_4._2$mcZ$sp();
                        if (!var7_5 || !var8_6) break block2;
                        v0 = "Theorem";
                        break block3;
                    }
                    if (var6_4 == null) break block4;
                    var9_7 = var6_4._1$mcZ$sp();
                    var10_8 = var6_4._2$mcZ$sp();
                    if (!var9_7 || var10_8) break block4;
                    v0 = "Unsatisfiable";
                    break block3;
                }
                if (var6_4 == null) break block5;
                var11_9 = var6_4._1$mcZ$sp();
                var12_10 = var6_4._2$mcZ$sp();
                if (var11_9 || !var12_10) break block5;
                v0 = "CounterSatisfiable";
                break block3;
            }
            if (var6_4 == null) ** GOTO lbl-1000
            var13_11 = var6_4._1$mcZ$sp();
            var14_12 = var6_4._2$mcZ$sp();
            if (!var13_11 && !var14_12) {
                v0 = "Satisfiable";
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var6_4);
            }
        }
        status = v0;
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("% SZS status ").append(status).append(" for ").append(name).toString());
    }

    private void maybePrintTree(ProofTree tree, GlobalSettings settings, boolean stderr) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$PRINT_TREE$.MODULE$.apply(settings))) {
            Console$.MODULE$.withOut(stderr ? Console$.MODULE$.err() : Console$.MODULE$.out(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"Proof tree:");
                Predef$.MODULE$.println((Object)tree);
            });
            return;
        }
    }

    private boolean maybePrintTree$default$3() {
        return false;
    }

    private void maybePrintConstraint(IFormula constraint, GlobalSettings settings, Enumeration.Value format) {
        if (!constraint.isTrue() || BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Under the ").append((Object)(BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings)) ? "most-general " : "")).append("constraint:").toString());
            this.printFormula(constraint, format);
            return;
        }
    }

    private void maybePrintFixedConstraint(boolean value, String name, GlobalSettings settings) {
        if (BoxesRunTime.unboxToBoolean((Object)Param$MOST_GENERAL_CONSTRAINT$.MODULE$.apply(settings))) {
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)new StringBuilder(1).append(name).append(":").toString());
            Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)value));
            return;
        }
    }

    private void maybePrintModel(Option<IFormula> optModel, String name, boolean stderr, Enumeration.Value format) {
        optModel.foreach((Function1 & Serializable & scala.Serializable)model -> {
            Console$.MODULE$.withOut(stderr ? Console$.MODULE$.err() : Console$.MODULE$.out(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)new StringBuilder(1).append(name$3).append(":").toString());
                CmdlMain$.MODULE$.printModel(model, format$3);
            });
            return BoxedUnit.UNIT;
        });
    }

    private boolean maybePrintModel$default$3() {
        return false;
    }

    public void main(String[] args) {
        this.doMain(args, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doMain(String[] args, Function0<Object> userDefStoppingCond) {
        Object object = new Object();
        try {
            Tuple2 tuple2 = this.liftedTree1$1(args, object);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GlobalSettings settings = (GlobalSettings)tuple2._1();
            Seq inputs = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)settings, (Object)inputs);
            GlobalSettings settings2 = (GlobalSettings)tuple22._1();
            Seq inputs2 = (Seq)tuple22._2();
            if (BoxesRunTime.unboxToBoolean((Object)Param$VERSION$.MODULE$.apply(settings2))) {
                Predef$.MODULE$.println((Object)this.version());
                return;
            }
            if (BoxesRunTime.unboxToBoolean((Object)Param$FULL_HELP$.MODULE$.apply(settings2))) {
                Predef$.MODULE$.println((Object)this.version());
                Predef$.MODULE$.println();
                this.printUsage();
                Predef$.MODULE$.println();
                Predef$.MODULE$.println();
                this.printExoticOptions();
                Predef$.MODULE$.println();
                return;
            }
            if (BoxesRunTime.unboxToBoolean((Object)Param$QUIET$.MODULE$.apply(settings2))) {
                Console$.MODULE$.setErr((OutputStream)CmdlMain$NullStream$.MODULE$);
            }
            Object object2 = BoxesRunTime.unboxToBoolean((Object)Param$LOGO$.MODULE$.apply(settings2)) ? Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                MODULE$.printGreeting();
                Predef$.MODULE$.println();
            }) : BoxedUnit.UNIT;
            if (inputs2.isEmpty() && !BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings2))) {
                Console$.MODULE$.err().println("No inputs given, exiting");
                return;
            }
            this.warmup(settings2);
            inputs2.foreach((Function1 & Serializable & scala.Serializable)filename -> {
                Object object;
                block3: {
                    try {
                        Enumeration.Value format = MODULE$.determineInputFormat((String)filename, settings2);
                        object = MODULE$.proveProblem(settings2, (String)filename, (Function0<Reader>)(Function0 & Serializable & scala.Serializable)() -> new BufferedReader(new FileReader(new File((String)filename))), userDefStoppingCond, format);
                    }
                    catch (Throwable e) {
                        Predef$.MODULE$.println((Object)new StringBuilder(7).append("ERROR: ").append(e.getMessage()).toString());
                        if (MODULE$.stackTraces()) {
                            e.printStackTrace();
                            object = BoxedUnit.UNIT;
                            break block3;
                        }
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            });
            if (!BoxesRunTime.unboxToBoolean((Object)Param$STDIN$.MODULE$.apply(settings2))) return;
            Console$.MODULE$.err().println("Reading SMT-LIB 2 input from stdin ...");
            this.proveProblemInc(settings2, Console$.MODULE$.in(), userDefStoppingCond);
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) throw ex;
            ex.value$mcV$sp();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$printSMT$2(PartName name$1, INamedPart x0$1) {
        INamedPart iNamedPart = x0$1;
        if (iNamedPart != null) {
            PartName partName = iNamedPart.name();
            PartName partName2 = name$1;
            PartName partName3 = partName;
            if (!(partName2 != null ? !partName2.equals(partName3) : partName3 != null)) {
                return true;
            }
        }
        return false;
    }

    private static final IFormula formula$1(PartName name, AbstractFileProver prover$1) {
        return IExpression$.MODULE$.removePartName((IFormula)prover$1.inputFormulas().find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CmdlMain$.$anonfun$printSMT$2(name, x0$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> IExpression$.MODULE$.Boolean2IFormula(false)));
    }

    private static final void linearise$1(AbstractFileProver prover$1, String filename$1) {
        .colon.colon colon2;
        IInterpolantSpec iInterpolantSpec;
        List<IInterpolantSpec> list = prover$1.interpolantSpecs();
        Some some = List$.MODULE$.unapplySeq(list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(0) == 0) {
            List formulas;
            if (prover$1.signature().existentialConstants().isEmpty() && prover$1.signature().universalConstants().isEmpty()) {
                .colon.colon x$1 = new .colon.colon((Object)prover$1.rawInputFormula(), (List)Nil$.MODULE$);
                Signature x$2 = prover$1.rawSignature();
                String x$3 = filename$1;
                Seq<Theory> x$4 = SMTLineariser$.MODULE$.printWithDeclsSig$default$3();
                String x$5 = SMTLineariser$.MODULE$.printWithDeclsSig$default$5();
                String x$6 = SMTLineariser$.MODULE$.printWithDeclsSig$default$6();
                SMTLineariser$.MODULE$.printWithDeclsSig((Seq<IFormula>)x$1, x$2, x$4, x$3, x$5, x$6);
                return;
            }
            List x$7 = formulas = (List)prover$1.inputFormulas().map((Function1 & Serializable & scala.Serializable)f -> IExpression$.MODULE$.removePartName((IFormula)f), List$.MODULE$.canBuildFrom());
            Signature x$8 = prover$1.signature();
            String x$9 = filename$1;
            Seq<Theory> x$10 = SMTLineariser$.MODULE$.printWithDeclsSig$default$3();
            String x$11 = SMTLineariser$.MODULE$.printWithDeclsSig$default$5();
            String x$12 = SMTLineariser$.MODULE$.printWithDeclsSig$default$6();
            SMTLineariser$.MODULE$.printWithDeclsSig((Seq<IFormula>)x$7, x$8, x$10, x$9, x$11, x$12);
            return;
        }
        if (list instanceof .colon.colon && (iInterpolantSpec = (IInterpolantSpec)(colon2 = (.colon.colon)list).head()) != null) {
            List formulas;
            List<PartName> left = iInterpolantSpec.left();
            List<PartName> right = iInterpolantSpec.right();
            IFormula common = CmdlMain$.formula$1(PartName$.MODULE$.NO_NAME(), prover$1);
            List x$13 = formulas = (List)((List)left.$plus$plus(right, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)part -> common.$bar$bar$bar(CmdlMain$.formula$1(part, prover$1)), List$.MODULE$.canBuildFrom());
            Signature x$14 = prover$1.signature();
            String x$15 = filename$1;
            Seq<Theory> x$16 = SMTLineariser$.MODULE$.printWithDeclsSig$default$3();
            String x$17 = SMTLineariser$.MODULE$.printWithDeclsSig$default$5();
            String x$18 = SMTLineariser$.MODULE$.printWithDeclsSig$default$6();
            SMTLineariser$.MODULE$.printWithDeclsSig((Seq<IFormula>)x$13, x$14, x$16, x$15, x$17, x$18);
            return;
        }
        throw new MatchError(list);
    }

    private static final void linearise$2(AbstractFileProver prover$2, String filename$2) {
        TPTPLineariser$.MODULE$.apply(prover$2.rawInputFormula(), filename$2);
    }

    private static final void prelPrinter$1(Prover p, GlobalSettings baseSettings$1, String name$2, Enumeration.Value format$1) {
        Console$.MODULE$.err().println();
        MODULE$.printResult(p, baseSettings$1, name$2, format$1);
        Console$.MODULE$.err().println();
    }

    public static final /* synthetic */ void $anonfun$proveProblemNonInc$3() {
        Predef$.MODULE$.println();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Some $anonfun$proveProblemNonInc$1(GlobalSettings settings$2, GlobalSettings baseSettings$1, String name$2, Enumeration.Value format$1, Function0 reader$1, Function0 userDefStoppingCond$1) {
        block4: {
            block3: {
                block2: {
                    v0 = Param$PORTFOLIO$.MODULE$.apply(settings$2);
                    var8_6 = "none";
                    if (!(v0 == null ? var8_6 != null : v0.equals(var8_6) == false)) break block2;
                    if (BoxesRunTime.unboxToBoolean((Object)Param$COMPUTE_UNSAT_CORE$.MODULE$.apply(settings$2)) || BoxesRunTime.unboxToBoolean((Object)Param$PRINT_CERTIFICATE$.MODULE$.apply(settings$2))) ** GOTO lbl-1000
                    v1 = Param$PRINT_DOT_CERTIFICATE_FILE$.MODULE$.apply(settings$2);
                    var10_7 = "";
                    if (v1 == null ? var10_7 != null : v1.equals(var10_7) == false) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
                    needProof = v2;
                    args = new ParallelFileProver.ProverArguments((Function0<Reader>)reader$1, baseSettings$1, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings$2)), (Function0<Object>)userDefStoppingCond$1, needProof, (Function1<Prover, BoxedUnit>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$proveProblemNonInc$2$adapted(ap.parameters.GlobalSettings java.lang.String scala.Enumeration$Value ap.Prover ), (Lap/Prover;)Ljava/lang/Object;)((GlobalSettings)baseSettings$1, (String)name$2, (Enumeration.Value)format$1), BoxesRunTime.unboxToInt((Object)Param$PORTFOLIO_THREAD_NUM$.MODULE$.apply(settings$2)));
                    v3 /* !! */  = ParallelFileProver$.MODULE$.apply((String)Param$PORTFOLIO$.MODULE$.apply(settings$2), args);
                    break block3;
                }
                v3 /* !! */  = new IntelliFileProver((Reader)reader$1.apply(), AbstractFileProver$.MODULE$.timeoutFromSettings(settings$2), true, (Function0<Object>)userDefStoppingCond$1, baseSettings$1);
            }
            prover = v3 /* !! */ ;
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$proveProblemNonInc$3(), ()V)());
            CmdlMain$.MODULE$.printResult(prover, settings$2, name$2, format$1);
            var12_11 = prover;
            if (!(var12_11 instanceof AbstractFileProver)) break block4;
            var13_12 = var12_11;
            CmdlMain$.MODULE$.printSMT(var13_12, name$2, settings$2);
            CmdlMain$.MODULE$.printTPTP(var13_12, name$2, settings$2);
        }
        return new Some((Object)prover.result());
    }

    public static final /* synthetic */ void $anonfun$proveProblemInc$2(GlobalSettings settings$3, Reader input$1, Function0 userDefStoppingCond$2, SimpleAPI p) {
        SMTParser2InputAbsy parser2 = SMTParser2InputAbsy$.MODULE$.apply(settings$3.toParserSettings(), p);
        parser2.processIncrementally(input$1, BoxesRunTime.unboxToInt((Object)Param$TIMEOUT$.MODULE$.apply(settings$3)), BoxesRunTime.unboxToInt((Object)Param$TIMEOUT_PER$.MODULE$.apply(settings$3)), (Function0<Object>)userDefStoppingCond$2);
    }

    public static final /* synthetic */ void $anonfun$printResult$3(Enumeration.Value format$2, IFormula i) {
        Predef$.MODULE$.print((Object)"  ");
        MODULE$.printFormula(i, format$2);
    }

    public static final /* synthetic */ boolean $anonfun$printResult$6(IFormula x0$1) {
        IFormula iFormula = x0$1;
        Option<Tuple2<ITerm, ITerm>> option = IExpression$Eq$.MODULE$.unapply(iFormula);
        if (!option.isEmpty()) {
            ITerm iTerm = (ITerm)((Tuple2)option.get())._1();
            ITerm iTerm2 = (ITerm)((Tuple2)option.get())._2();
            if (iTerm instanceof IConstant && iTerm2 instanceof IIntLit) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$containsTPTPConjecture$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            PartName p = (PartName)tuple2._1();
            return p.toString().endsWith(TPTPTParser$.MODULE$.CONJECTURE_SUFFIX());
        }
        throw new MatchError((Object)tuple2);
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(String[] args$1, Object nonLocalReturnKey1$1) {
        Tuple2<GlobalSettings, Seq<String>> tuple2;
        try {
            tuple2 = GlobalSettings$.MODULE$.fromArguments((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args$1), GlobalSettings$.MODULE$.DEFAULT());
        }
        catch (Throwable e) {
            Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                MODULE$.printGreeting();
                Predef$.MODULE$.println();
            });
            Predef$.MODULE$.println((Object)e.getMessage());
            Predef$.MODULE$.println();
            this.printUsage();
            Predef$.MODULE$.println();
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        return tuple2;
    }

    private CmdlMain$() {
        MODULE$ = this;
        this.version = "2024-11-08";
        this.stackTraces = false;
    }

    public static final /* synthetic */ Object $anonfun$proveProblemNonInc$2$adapted(GlobalSettings baseSettings$1, String name$2, Enumeration.Value format$1, Prover p) {
        CmdlMain$.prelPrinter$1(p, baseSettings$1, name$2, format$1);
        return BoxedUnit.UNIT;
    }
}

