/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.ICompositionFactory;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.LiptonReduction;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.CachedIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.UnionIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceSettings;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SyntacticIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.PetriNetLargeBlockEncodingStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PetriNetLargeBlockEncoding<L extends IIcfgTransition<?>> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final BoundedPetriNet<L, IPredicate> mResult;
    private final BlockEncodingBacktranslator mBacktranslator;
    private final PetriNetLargeBlockEncodingStatisticsGenerator mStatistics;

    public PetriNetLargeBlockEncoding(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, BoundedPetriNet<L, IPredicate> boundedPetriNet, IndependenceSettings independenceSettings, IPLBECompositionFactory<L> iPLBECompositionFactory, Class<L> clazz) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        LiptonReduction liptonReduction;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(this.getClass());
        this.mServices = iUltimateServiceProvider;
        this.mManagedScript = cfgSmtToolkit.getManagedScript();
        SyntacticIndependenceRelation syntacticIndependenceRelation = new SyntacticIndependenceRelation();
        CachedIndependenceRelation cachedIndependenceRelation = switch (independenceSettings.getIndependenceType()) {
            case IndependenceSettings.IndependenceType.SEMANTIC -> {
                this.mLogger.info((Object)"Petri net LBE is using semantic-based independence relation.");
                SemanticIndependenceRelation var8_8 = new SemanticIndependenceRelation(this.mServices, this.mManagedScript, independenceSettings.useConditional(), !independenceSettings.useSemiCommutativity());
                liptonReduction = new UnionIndependenceRelation(Arrays.asList(syntacticIndependenceRelation, var8_8));
                yield new CachedIndependenceRelation((IIndependenceRelation)liptonReduction);
            }
            case IndependenceSettings.IndependenceType.SYNTACTIC -> {
                Object var8_9 = null;
                this.mLogger.info((Object)"Petri net LBE is using variable-based independence relation.");
                yield new CachedIndependenceRelation(syntacticIndependenceRelation);
            }
            default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)independenceSettings.getIndependenceType())));
        };
        this.mLogger.info((Object)("Starting large block encoding on Petri net that " + boundedPetriNet.sizeInformation()));
        try {
            liptonReduction = new LiptonReduction(new AutomataLibraryServices(iUltimateServiceProvider), boundedPetriNet, iPLBECompositionFactory, (IIndependenceRelation)cachedIndependenceRelation);
            this.mResult = liptonReduction.getResult();
            this.mBacktranslator = this.createBacktranslator(clazz, liptonReduction, iPLBECompositionFactory);
            this.mStatistics = new PetriNetLargeBlockEncodingStatisticsGenerator(liptonReduction.getStatistics(), cachedIndependenceRelation.getStatistics());
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), this.generateTimeoutMessage(boundedPetriNet));
            automataOperationCanceledException.addRunningTaskInfo(runningTaskInfo);
            throw automataOperationCanceledException;
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), this.generateTimeoutMessage(boundedPetriNet));
            toolchainCanceledException.addRunningTaskInfo(runningTaskInfo);
            throw toolchainCanceledException;
        }
    }

    private String generateTimeoutMessage(BoundedPetriNet<L, IPredicate> boundedPetriNet) {
        return "applying " + this.getClass().getSimpleName() + " to Petri net that " + boundedPetriNet.sizeInformation();
    }

    private BlockEncodingBacktranslator createBacktranslator(Class<L> clazz, LiptonReduction<L, IPredicate> liptonReduction, IPLBECompositionFactory<L> iPLBECompositionFactory) {
        BlockEncodingBacktranslator blockEncodingBacktranslator = new BlockEncodingBacktranslator(clazz, Term.class, this.mLogger);
        for (Map.Entry entry : liptonReduction.getSequentialCompositions().entrySet()) {
            IIcfgTransition iIcfgTransition = (IIcfgTransition)entry.getKey();
            for (IIcfgTransition iIcfgTransition2 : (List)entry.getValue()) {
                blockEncodingBacktranslator.mapEdges(iIcfgTransition, iIcfgTransition2);
            }
        }
        Map<L, TermVariable> map = iPLBECompositionFactory.getBranchEncoders();
        for (Map.Entry entry : liptonReduction.getChoiceCompositions().entrySet()) {
            IIcfgTransition iIcfgTransition2;
            iIcfgTransition2 = (IIcfgTransition)entry.getKey();
            for (IIcfgTransition iIcfgTransition : (Set)entry.getValue()) {
                TermVariable termVariable = map.get(iIcfgTransition);
                blockEncodingBacktranslator.mapEdges(iIcfgTransition2, iIcfgTransition, termVariable);
            }
        }
        return blockEncodingBacktranslator;
    }

    public BoundedPetriNet<L, IPredicate> getResult() {
        return this.mResult;
    }

    public BlockEncodingBacktranslator getBacktranslator() {
        return this.mBacktranslator;
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    public static interface IPLBECompositionFactory<L>
    extends ICompositionFactory<L> {
        public Map<L, TermVariable> getBranchEncoders();
    }
}

