/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class VarList
extends BoogieASTNode {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(VarList.class);
    ILocation loc;
    String[] identifiers;
    ASTType type;
    Expression whereClause;

    public VarList(ILocation iLocation, String[] stringArray, ASTType aSTType) {
        super(iLocation);
        this.loc = iLocation;
        this.identifiers = stringArray;
        this.type = aSTType;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid VarList: " + String.valueOf((Object)this);
    }

    public VarList(ILocation iLocation, String[] stringArray, ASTType aSTType, Expression expression) {
        super(iLocation);
        this.loc = iLocation;
        this.identifiers = stringArray;
        this.type = aSTType;
        this.whereClause = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid VarList: " + String.valueOf((Object)this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VarList").append('[');
        stringBuffer.append(this.loc);
        stringBuffer.append(',');
        if (this.identifiers == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.identifiers.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.identifiers[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append((Object)this.type);
        stringBuffer.append(',').append((Object)this.whereClause);
        return stringBuffer.append(']').toString();
    }

    public ILocation getLoc() {
        return this.loc;
    }

    public void setLoc(ILocation iLocation) {
        if (this.loc != null && iLocation != this.loc) {
            throw new AssertionError((Object)"Value is only writeable once");
        }
        this.loc = iLocation;
    }

    public String[] getIdentifiers() {
        return this.identifiers;
    }

    public ASTType getType() {
        return this.type;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.type);
        list.add(this.whereClause);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (generatedBoogieAstVisitor.visit(this)) {
            if (this.type != null) {
                this.type.accept(generatedBoogieAstVisitor);
            }
            if (this.whereClause != null) {
                this.whereClause.accept(generatedBoogieAstVisitor);
            }
        }
    }

    public VarList accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        VarList varList = generatedBoogieAstTransformer.transform(this);
        if (varList != this) {
            return varList;
        }
        ASTType aSTType = null;
        if (this.type != null) {
            aSTType = this.type.accept(generatedBoogieAstTransformer);
        }
        Expression expression = null;
        if (this.whereClause != null) {
            expression = this.whereClause.accept(generatedBoogieAstTransformer);
        }
        if (this.type != aSTType || this.whereClause != expression) {
            return new VarList(this.loc, this.identifiers, aSTType, expression);
        }
        return this;
    }
}

