/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.buchiprogramproduct;

import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.Activator;
import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.BuchiProductObserver;
import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.ProductBacktranslator;
import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BuchiProgramProduct
implements IGenerator {
    private ILogger mLogger;
    private BuchiProductObserver mBuchiProductObserver;
    private boolean mUseBuchiProductObserver;
    private boolean mPreviousToolFoundErrors;
    private IUltimateServiceProvider mServices;
    private int mUseful;
    private ProductBacktranslator mBacktranslator;

    public ModelType getOutputDefinition() {
        if (this.mPreviousToolFoundErrors) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("LTL+Program Product");
        return new ModelType(Activator.PLUGIN_ID, ModelType.Type.OTHER, arrayList);
    }

    public boolean isGuiRequired() {
        return false;
    }

    public ITool.ModelQuery getModelQuery() {
        if (this.mPreviousToolFoundErrors) {
            return ITool.ModelQuery.LAST;
        }
        return ITool.ModelQuery.ALL;
    }

    public void setInputDefinition(ModelType modelType) {
        switch (modelType.getCreator()) {
            case "de.uni_freiburg.informatik.ultimate.ltl2aut": 
            case "de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder": 
            case "de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder": {
                this.mUseBuchiProductObserver = true;
                ++this.mUseful;
                break;
            }
            default: {
                this.mUseBuchiProductObserver = false;
            }
        }
    }

    public List<IObserver> getObservers() {
        if (!this.mPreviousToolFoundErrors && this.mUseBuchiProductObserver) {
            BuchiProductObserver buchiProductObserver = this.getProductObserver();
            return Collections.singletonList(buchiProductObserver);
        }
        return Collections.emptyList();
    }

    private BuchiProductObserver getProductObserver() {
        if (this.mBuchiProductObserver == null) {
            this.mBuchiProductObserver = new BuchiProductObserver(this.mLogger, this.mServices, this.mBacktranslator);
        }
        return this.mBuchiProductObserver;
    }

    public void init() {
        this.mUseBuchiProductObserver = false;
        this.mUseful = 0;
    }

    public String getPluginName() {
        return "B\u00fcchi Program Product";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public IElement getModel() {
        return this.getProductObserver().getModel();
    }

    public List<String> getDesiredToolIds() {
        return Collections.emptyList();
    }

    public IPreferenceInitializer getPreferences() {
        return null;
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mPreviousToolFoundErrors = !ResultUtil.filterResults((Map)iUltimateServiceProvider.getResultService().getResults(), CounterExampleResult.class).isEmpty();
        this.mBacktranslator = new ProductBacktranslator(IcfgEdge.class, Term.class);
        if (!this.mPreviousToolFoundErrors) {
            this.mServices.getBacktranslationService().addTranslator((ITranslator)this.mBacktranslator);
        }
    }

    public void finish() {
        if (!this.mPreviousToolFoundErrors && this.mUseful == 0) {
            throw new IllegalStateException("Was used in a toolchain and did nothing");
        }
        if (this.mPreviousToolFoundErrors) {
            this.mLogger.info((Object)"Another plugin discovered errors, skipping...");
        }
    }
}

