/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class WhileStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(WhileStatement.class);
    Expression condition;
    LoopInvariantSpecification[] invariants;
    Statement[] body;

    public WhileStatement(ILocation iLocation, Expression expression, LoopInvariantSpecification[] loopInvariantSpecificationArray, Statement[] statementArray) {
        super(iLocation);
        this.condition = expression;
        this.invariants = loopInvariantSpecificationArray;
        this.body = statementArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid WhileStatement: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WhileStatement").append('[');
        stringBuffer.append((Object)this.condition);
        stringBuffer.append(',');
        if (this.invariants == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.invariants.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.invariants[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.body == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.body.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.body[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public Expression getCondition() {
        return this.condition;
    }

    public LoopInvariantSpecification[] getInvariants() {
        return this.invariants;
    }

    public Statement[] getBody() {
        return this.body;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.condition);
        if (this.invariants != null) {
            list.addAll(Arrays.asList(this.invariants));
        }
        if (this.body != null) {
            list.addAll(Arrays.asList(this.body));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            BoogieASTNode boogieASTNode;
            int n;
            int n2;
            BoogieASTNode[] boogieASTNodeArray;
            if (this.condition != null) {
                this.condition.accept(generatedBoogieAstVisitor);
            }
            if (this.invariants != null) {
                boogieASTNodeArray = this.invariants;
                n2 = this.invariants.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((LoopInvariantSpecification)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.body != null) {
                boogieASTNodeArray = this.body;
                n2 = this.body.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((Statement)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Object object;
        Object object2;
        int n;
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        Expression expression = null;
        if (this.condition != null) {
            expression = this.condition.accept(generatedBoogieAstTransformer);
        }
        boolean bl = false;
        ArrayList<Statement[]> arrayList = new ArrayList<Statement[]>();
        if (this.invariants != null) {
            LoopInvariantSpecification[] loopInvariantSpecificationArray = this.invariants;
            n = this.invariants.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = loopInvariantSpecificationArray[n2];
                object = (LoopInvariantSpecification)((LoopInvariantSpecification)((Object)object2)).accept(generatedBoogieAstTransformer);
                bl = bl || object != object2;
                arrayList.add((Statement[])object);
                ++n2;
            }
        }
        object2 = new ArrayList();
        if (this.body != null) {
            object = this.body;
            int n3 = this.body.length;
            n = 0;
            while (n < n3) {
                Statement statement2 = object[n];
                Statement statement3 = statement2.accept(generatedBoogieAstTransformer);
                bl = bl || statement3 != statement2;
                ((ArrayList)object2).add(statement3);
                ++n;
            }
        }
        if (bl || this.condition != expression) {
            return new WhileStatement(this.loc, expression, arrayList.toArray(new LoopInvariantSpecification[0]), ((ArrayList)object2).toArray(new Statement[0]));
        }
        return this;
    }
}

