/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.type;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePlaceholderType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;

public class BoogiePrimitiveType
extends BoogieType {
    private static final long serialVersionUID = -1842658349197318623L;
    public static final int BOOL = -1;
    public static final int INT = -2;
    public static final int REAL = -3;
    public static final int ERROR = -42;
    private final int mType;

    BoogiePrimitiveType(int n) {
        this.mType = n;
    }

    @Override
    public BoogieType getUnderlyingType() {
        return this;
    }

    @Override
    protected boolean hasPlaceholder(int n, int n2) {
        return false;
    }

    @Override
    protected BoogieType incrementPlaceholders(int n, int n2) {
        return this;
    }

    @Override
    protected boolean isUnifiableTo(int n, BoogieType boogieType, ArrayList<BoogieType> arrayList) {
        if (boogieType instanceof BoogiePlaceholderType) {
            return boogieType.isUnifiableTo(n, this, arrayList);
        }
        return this == TYPE_ERROR || boogieType == TYPE_ERROR || this == boogieType;
    }

    @Override
    protected BoogieType substitutePlaceholders(int n, BoogieType[] boogieTypeArray) {
        return this;
    }

    @Override
    protected String toString(int n, boolean bl) {
        switch (this.mType) {
            case -2: {
                return "int";
            }
            case -1: {
                return "bool";
            }
            case -3: {
                return "real";
            }
            case -42: {
                return "*type-error*";
            }
        }
        return "bv" + this.mType;
    }

    @Override
    protected ASTType toASTType(ILocation iLocation, int n) {
        return new PrimitiveType(iLocation, this, this.toString(n, false));
    }

    @Override
    protected boolean unify(int n, BoogieType boogieType, BoogieType[] boogieTypeArray) {
        return this == TYPE_ERROR || boogieType == TYPE_ERROR || this == boogieType;
    }

    public int getTypeCode() {
        return this.mType;
    }

    @Override
    public boolean isFinite() {
        return this.mType != -2;
    }

    public static BoogiePrimitiveType toPrimitiveType(String string) {
        switch (string.toLowerCase()) {
            case "bool": {
                return BoogieType.TYPE_BOOL;
            }
            case "real": {
                return BoogieType.TYPE_REAL;
            }
            case "int": {
                return BoogieType.TYPE_INT;
            }
        }
        return BoogieType.TYPE_ERROR;
    }
}

