/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.translation;

import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface IProgramExecution<TE, E>
extends Iterable<AtomicTraceElement<TE>> {
    public int getLength();

    public AtomicTraceElement<TE> getTraceElement(int var1);

    public ProgramState<E> getProgramState(int var1);

    public ProgramState<E> getInitialProgramState();

    public Class<E> getExpressionClass();

    public Class<? extends TE> getTraceElementClass();

    public String toString();

    public boolean isConcurrent();

    default public List<ProgramState<E>> getProgramStates() {
        ArrayList<ProgramState<ProgramState<E>>> arrayList = new ArrayList<ProgramState<ProgramState<E>>>(this.getLength() + 1);
        arrayList.add(this.getInitialProgramState());
        int n = 0;
        while (n < this.getLength()) {
            arrayList.add(this.getProgramState(n));
            ++n;
        }
        return arrayList;
    }

    @Override
    default public Spliterator<AtomicTraceElement<TE>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.getLength(), 1104);
    }

    default public Stream<AtomicTraceElement<TE>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    default public Iterator<AtomicTraceElement<TE>> iterator() {
        return new Iterator<AtomicTraceElement<TE>>(){
            private final int max;
            private int current;
            {
                this.max = IProgramExecution.this.getLength();
                this.current = 0;
            }

            @Override
            public boolean hasNext() {
                return this.current < this.max;
            }

            @Override
            public AtomicTraceElement<TE> next() {
                return IProgramExecution.this.getTraceElement(this.current++);
            }
        };
    }

    public IBacktranslationValueProvider<TE, E> getBacktranslationValueProvider();

    public static <TE, E> IProgramExecution<TE, E> emptyExecution(final Class<E> clazz, final Class<? extends TE> clazz2) {
        return new IProgramExecution<TE, E>(){

            @Override
            public int getLength() {
                return 0;
            }

            @Override
            public AtomicTraceElement<TE> getTraceElement(int n) {
                return null;
            }

            @Override
            public ProgramState<E> getProgramState(int n) {
                return null;
            }

            @Override
            public ProgramState<E> getInitialProgramState() {
                return null;
            }

            @Override
            public Class<E> getExpressionClass() {
                return clazz;
            }

            @Override
            public Class<? extends TE> getTraceElementClass() {
                return clazz2;
            }

            @Override
            public IBacktranslationValueProvider<TE, E> getBacktranslationValueProvider() {
                return null;
            }

            @Override
            public boolean isConcurrent() {
                return false;
            }
        };
    }

    public static class ProgramState<E> {
        private final Class<E> mClassOfExpression;
        private final Map<E, Collection<E>> mVariable2Values;

        public ProgramState(Map<E, Collection<E>> map, Class<E> clazz) {
            this.mClassOfExpression = clazz;
            this.mVariable2Values = map;
        }

        public Set<E> getVariables() {
            return this.mVariable2Values.keySet();
        }

        public Collection<E> getValues(E e) {
            return this.mVariable2Values.get(e);
        }

        public Class<E> getClassOfExpression() {
            return this.mClassOfExpression;
        }

        public String toString(Function<E, String> function) {
            List<Map.Entry<E, Collection<E>>> list = ProgramState.constructSortedListOfEntries(this.mVariable2Values);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (Map.Entry<E, Collection<E>> entry : list) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(function.apply(entry.getKey()));
                if (entry.getValue().size() == 1) {
                    stringBuilder.append("=");
                    E e = entry.getValue().iterator().next();
                    stringBuilder.append(function.apply(e));
                    continue;
                }
                stringBuilder.append(" in");
                stringBuilder.append(entry.getValue().stream().map(function).collect(Collectors.joining(",")));
            }
            return stringBuilder.toString();
        }

        private static <E> List<Map.Entry<E, Collection<E>>> constructSortedListOfEntries(Map<E, Collection<E>> map) {
            ArrayList<Map.Entry<E, Collection<E>>> arrayList = new ArrayList<Map.Entry<E, Collection<E>>>(map.entrySet());
            Collections.sort(arrayList, (entry, entry2) -> entry.getKey().toString().compareToIgnoreCase(entry2.getKey().toString()));
            return arrayList;
        }

        public String toString() {
            return this.toString(String::valueOf);
        }
    }
}

