/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet;

import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.ArrayList;
import java.util.List;

public class PetriNetRun<LETTER, PLACE>
implements IRun<LETTER, Marking<PLACE>> {
    private final Word<LETTER> mWord;
    private final List<Marking<PLACE>> mMarkingSequence;
    private final List<Transition<LETTER, PLACE>> mTransitionSequence;

    public PetriNetRun(Marking<PLACE> marking) {
        this.mWord = new NestedWord();
        this.mTransitionSequence = List.of();
        this.mMarkingSequence = List.of(marking);
    }

    public PetriNetRun(Marking<PLACE> marking, Transition<LETTER, PLACE> transition, Marking<PLACE> marking2) {
        this.mTransitionSequence = List.of(transition);
        this.mWord = new NestedWord<LETTER>(transition.getSymbol(), -2);
        this.mMarkingSequence = new ArrayList<Marking<PLACE>>();
        this.mMarkingSequence.add(marking);
        this.mMarkingSequence.add(marking2);
    }

    public PetriNetRun(List<Marking<PLACE>> list, Word<LETTER> word, List<Transition<LETTER, PLACE>> list2) {
        if (list.size() - 1 != word.length()) {
            throw new IllegalArgumentException("run consists of word length +1 markings");
        }
        if (list2.size() != word.length()) {
            throw new IllegalArgumentException("number of transitions differs from length of word");
        }
        this.mMarkingSequence = list;
        this.mTransitionSequence = list2;
        this.mWord = word;
    }

    @Override
    public LETTER getSymbol(int n) {
        return this.mWord.getSymbol(n);
    }

    @Override
    public Word<LETTER> getWord() {
        return this.mWord;
    }

    public Marking<PLACE> getMarking(int n) {
        return this.mMarkingSequence.get(n);
    }

    public Transition<LETTER, PLACE> getTransition(int n) {
        return this.mTransitionSequence.get(n);
    }

    public PetriNetRun<LETTER, PLACE> concatenate(PetriNetRun<LETTER, PLACE> petriNetRun) {
        if (!this.getMarking(this.mMarkingSequence.size() - 1).equals(petriNetRun.getMarking(0))) {
            throw new IllegalArgumentException("can only concatenate runs where last Marking of first run and first Marking of second run coincide");
        }
        List list = DataStructureUtils.concat(this.mMarkingSequence, petriNetRun.mMarkingSequence.subList(1, petriNetRun.getLength()));
        List list2 = DataStructureUtils.concat(this.mTransitionSequence, petriNetRun.mTransitionSequence);
        Word<LETTER> word = this.mWord.concatenate(petriNetRun.getWord());
        return new PetriNetRun<LETTER, PLACE>(list, word, list2);
    }

    @Override
    public int getLength() {
        return this.mMarkingSequence.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.mWord.length()) {
            stringBuilder.append(this.mMarkingSequence.get(n)).append(' ');
            stringBuilder.append(this.mWord.getSymbol(n)).append(' ');
            ++n;
        }
        stringBuilder.append(this.mMarkingSequence.get(this.mMarkingSequence.size() - 1));
        return stringBuilder.toString();
    }

    @Override
    public List<Marking<PLACE>> getStateSequence() {
        return this.mMarkingSequence;
    }
}

