/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.InitialTransition;
import de.uni_freiburg.informatik.ultimate.lib.pea.PEATestAutomaton;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import de.uni_freiburg.informatik.ultimate.lib.pea.reqcheck.PEAPhaseIndexMap;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.SimpleSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class PhaseEventAutomata
implements Comparable<Object> {
    public static final String TIMES = "_X_";
    protected final String mName;
    protected final List<Phase> mPhases;
    protected final List<InitialTransition> mInit;
    protected final List<String> mClocks;
    protected final Map<String, String> mVariables;
    protected final Set<String> mEvents;
    protected List<String> mDeclarations;

    public PhaseEventAutomata(String string, List<Phase> list, List<InitialTransition> list2) {
        this(string, list, list2, new ArrayList<String>());
    }

    public PhaseEventAutomata(String string, List<Phase> list, List<InitialTransition> list2, Map<String, String> map) {
        this(string, list, list2, Collections.emptyList(), map, null, null);
    }

    public PhaseEventAutomata(String string, List<Phase> list, List<InitialTransition> list2, List<String> list3, Map<String, String> map) {
        this(string, list, list2, list3, map, null, null);
    }

    public PhaseEventAutomata(String string, List<Phase> list, List<InitialTransition> list2, List<String> list3) {
        this(string, list, list2, list3, null, null);
    }

    public PhaseEventAutomata(String string, List<Phase> list, List<InitialTransition> list2, List<String> list3, Map<String, String> map, List<String> list4) {
        this(string, list, list2, list3, map, null, list4);
    }

    public PhaseEventAutomata(String string, List<Phase> list, List<InitialTransition> list2, List<String> list3, Map<String, String> map, Set<String> set, List<String> list4) {
        this.mClocks = list3 == null ? new ArrayList<String>() : list3;
        this.mEvents = set;
        this.mDeclarations = list4;
        this.mInit = list2;
        this.mName = string;
        this.mPhases = list;
        this.mVariables = map;
        for (InitialTransition initialTransition : list2) {
            initialTransition.getDest().setInitialTransition(initialTransition);
        }
    }

    public PhaseEventAutomata parallel(PhaseEventAutomata phaseEventAutomata) {
        Object object;
        Object object2;
        Object object4;
        if (phaseEventAutomata instanceof PEATestAutomaton) {
            return phaseEventAutomata.parallel(this);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
        class TodoEntry {
            Phase p1;
            Phase p2;
            Phase p;

            TodoEntry(Phase phase, Phase phase2, Phase phase3) {
                this.p1 = phase;
                this.p2 = phase2;
                this.p = phase3;
            }
        }
        LinkedList<TodoEntry> linkedList = new LinkedList<TodoEntry>();
        int n = 0;
        while (n < this.mInit.size()) {
            int n2 = 0;
            while (n2 < phaseEventAutomata.mInit.size()) {
                object4 = this.mInit.get(n).getDest().getStateInv().and(phaseEventAutomata.mInit.get(n2).getDest().getStateInv());
                if (object4 != CDD.FALSE) {
                    CDD object32 = this.mInit.get(n).getDest().getClockInv().and(phaseEventAutomata.mInit.get(n2).getDest().getClockInv());
                    Phase phase = new Phase(this.mInit.get(n).getDest().getName() + TIMES + phaseEventAutomata.mInit.get(n2).getDest().getName(), (CDD)object4, object32);
                    arrayList.add(phase);
                    treeMap.put(phase.getName(), phase);
                    linkedList.add(new TodoEntry(this.mInit.get(n).getDest(), phaseEventAutomata.mInit.get(n2).getDest(), phase));
                }
                ++n2;
            }
            ++n;
        }
        while (!linkedList.isEmpty()) {
            TodoEntry todoEntry = (TodoEntry)linkedList.remove(0);
            CDD cDD = todoEntry.p1.getStateInv().and(todoEntry.p2.getStateInv());
            for (Transition transition : todoEntry.p1.getTransitions()) {
                for (Transition transition2 : todoEntry.p2.getTransitions()) {
                    object2 = transition.getGuard().and(transition2.getGuard());
                    if (object2 == CDD.FALSE || (object = transition.getDest().getStateInv().and(transition2.getDest().getStateInv())) == CDD.FALSE || object2 != CDD.TRUE && cDD.and((CDD)object2).and(((CDD)object).prime(Collections.emptySet())) == CDD.FALSE) continue;
                    CDD cDD2 = transition.getDest().getClockInv().and(transition2.getDest().getClockInv());
                    String[] stringArray = new String[transition.getResets().length + transition2.getResets().length];
                    System.arraycopy(transition.getResets(), 0, stringArray, 0, transition.getResets().length);
                    System.arraycopy(transition2.getResets(), 0, stringArray, transition.getResets().length, transition2.getResets().length);
                    SimpleSet<String> simpleSet = new SimpleSet<String>(transition.getDest().getStoppedClocks().size() + transition2.getDest().getStoppedClocks().size());
                    simpleSet.addAll(transition.getDest().getStoppedClocks());
                    simpleSet.addAll(transition2.getDest().getStoppedClocks());
                    String string = transition.getDest().getName() + TIMES + transition2.getDest().getName();
                    Phase phase = (Phase)treeMap.get(string);
                    if (phase == null) {
                        phase = new Phase(string, (CDD)object, cDD2, simpleSet);
                        treeMap.put(string, phase);
                        linkedList.add(new TodoEntry(transition.getDest(), transition2.getDest(), phase));
                    }
                    todoEntry.p.addTransition(phase, (CDD)object2, stringArray);
                }
            }
        }
        Phase[] phaseArray = treeMap.values().toArray(new Phase[treeMap.size()]);
        Phase[] phaseArray2 = arrayList.toArray(new Phase[arrayList.size()]);
        object4 = new ArrayList();
        object2 = phaseArray2;
        int n2 = phaseArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            Phase phase = object2[n3];
            object = new InitialTransition(phase.getClockInv(), phase);
            phase.setInitialTransition((InitialTransition)object);
            object4.add(object);
            ++n3;
        }
        List<String> list = this.mergeClockLists(phaseEventAutomata);
        Map<String, String> map = this.mergeVariableLists(phaseEventAutomata);
        List<String> list2 = this.mergeDeclarationLists(phaseEventAutomata);
        return new PhaseEventAutomata(this.mName + TIMES + phaseEventAutomata.mName, Arrays.asList(phaseArray), (List<InitialTransition>)object4, list, map, list2);
    }

    protected List<String> mergeDeclarationLists(PhaseEventAutomata phaseEventAutomata) {
        List<String> list;
        if (this.mDeclarations == null) {
            list = phaseEventAutomata.getDeclarations();
        } else if (phaseEventAutomata.getDeclarations() == null) {
            list = this.mDeclarations;
        } else {
            list = new ArrayList<String>(this.mDeclarations);
            list.addAll(phaseEventAutomata.getDeclarations());
        }
        return list;
    }

    protected Map<String, String> mergeVariableLists(PhaseEventAutomata phaseEventAutomata) {
        Map<String, String> map;
        if (this.mVariables == null) {
            map = phaseEventAutomata.getVariables();
        } else if (phaseEventAutomata.getVariables() == null) {
            map = this.mVariables;
        } else {
            map = new HashMap<String, String>();
            for (String string : this.mVariables.keySet()) {
                if (phaseEventAutomata.getVariables().containsKey(string) && !phaseEventAutomata.getVariables().get(string).equals(this.mVariables.get(string))) {
                    throw new RuntimeException("Different type definitions of " + string + "found!");
                }
                map.put(string, this.mVariables.get(string));
            }
            map.putAll(phaseEventAutomata.getVariables());
        }
        return map;
    }

    protected List<String> mergeClockLists(PhaseEventAutomata phaseEventAutomata) {
        ArrayList<String> arrayList = new ArrayList<String>(this.mClocks);
        arrayList.addAll(phaseEventAutomata.getClocks());
        return arrayList;
    }

    public String toString() {
        return this.mName;
    }

    public List<Phase> getInit() {
        ArrayList<Phase> arrayList = new ArrayList<Phase>();
        for (InitialTransition initialTransition : this.mInit) {
            arrayList.add(initialTransition.getDest());
        }
        return arrayList;
    }

    public String getName() {
        return this.mName;
    }

    public List<Phase> getPhases() {
        return this.mPhases;
    }

    public List<String> getClocks() {
        return this.mClocks;
    }

    public Map<String, String> getVariables() {
        return this.mVariables;
    }

    public Set<String> getEvents() {
        return this.mEvents;
    }

    public List<String> getDeclarations() {
        return this.mDeclarations;
    }

    public void addToClocks(String string) {
        this.mClocks.add(string);
    }

    @Override
    public int compareTo(Object object) {
        return this.mName.compareTo(((PhaseEventAutomata)object).mName);
    }

    public boolean isEmpty() {
        return this.getPhases().size() <= 0;
    }

    public int getNumberOfLocations() {
        return this.getPhases().size();
    }

    public Phase getLocation(int n) {
        return this.getPhases().get(n);
    }

    public void rename() {
        int n = this.getNumberOfLocations();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object object;
            Phase phase = this.getLocation(n3);
            String[] stringArray = PhaseEventAutomata.splitForComponents(phase.getName());
            int n4 = 0;
            String[] stringArray2 = stringArray;
            int n5 = stringArray.length;
            int n6 = 0;
            while (n6 < n5) {
                object = stringArray2[n6];
                PEAPhaseIndexMap pEAPhaseIndexMap = new PEAPhaseIndexMap((String)object);
                if (n4 < pEAPhaseIndexMap.getIndex() - 1) {
                    n4 = pEAPhaseIndexMap.getIndex() - 1;
                }
                ++n6;
            }
            object = "st" + n2 + n4;
            ++n2;
            phase.setName((String)object);
            ++n3;
        }
    }

    private static String[] splitForComponents(String string) {
        Pattern pattern = Pattern.compile(TIMES);
        return pattern.split(string);
    }

    public void simplifyGuards() {
        List<Phase> list = this.getPhases();
        for (Phase phase : list) {
            List<Transition> list2 = phase.getTransitions();
            for (Transition transition : list2) {
                transition.simplifyGuard();
            }
        }
    }

    public boolean isStrict() {
        for (Phase phase : this.mPhases) {
            if (!phase.isStrict() && phase.getModifiedConstraints().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isTotalised() {
        return this.mName.endsWith("_total");
    }

    public boolean isComplemented() {
        return this.mName.endsWith("_complement");
    }
}

