/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisTermTransducer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CondisDepthCodeGenerator
extends CondisTermTransducer<CondisDepthCode> {
    private CondisDepthCodeGenerator() {
    }

    @Override
    protected CondisDepthCode transduceAtom(Term term) {
        return new CondisDepthCode(Adk.ATOM, Arrays.asList(1));
    }

    @Override
    protected CondisDepthCode transduceConjunction(ApplicationTerm applicationTerm, List<CondisDepthCode> list) {
        List<Integer> list2 = new ArrayList<Integer>();
        for (CondisDepthCode object2 : list) {
            if (object2.getAdk() == Adk.ATOM || object2.getAdk() == Adk.DISJUNCTION) {
                list2 = CondisDepthCodeGenerator.computeMaximum(list2, object2.getDualJuncts());
                continue;
            }
            throw new AssertionError((Object)"expected conjunction-disjunction alternation");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(list.size());
        arrayList.addAll(list2);
        return new CondisDepthCode(Adk.CONJUNCTION, arrayList);
    }

    @Override
    protected CondisDepthCode transduceDisjunction(ApplicationTerm applicationTerm, List<CondisDepthCode> list) {
        List<Integer> list2 = new ArrayList<Integer>();
        for (CondisDepthCode object2 : list) {
            if (object2.getAdk() == Adk.ATOM || object2.getAdk() == Adk.CONJUNCTION) {
                list2 = CondisDepthCodeGenerator.computeMaximum(list2, object2.getDualJuncts());
                continue;
            }
            throw new AssertionError((Object)"expected conjunction-disjunction alternation");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(list.size());
        arrayList.addAll(list2);
        return new CondisDepthCode(Adk.DISJUNCTION, arrayList);
    }

    private static List<Integer> computeMaximum(List<Integer> list, List<Integer> list2) {
        List<Integer> list3;
        List<Integer> list4;
        if (list.size() >= list2.size()) {
            list4 = list;
            list3 = list2;
        } else {
            list4 = list2;
            list3 = list;
        }
        int n = 0;
        while (n < list3.size()) {
            list4.set(n, Integer.max(list4.get(n), list3.get(n)));
            ++n;
        }
        return list4;
    }

    public static enum Adk {
        ATOM,
        DISJUNCTION,
        CONJUNCTION;


        public String getSymbol() {
            return switch (this) {
                case ATOM -> this.toString();
                case CONJUNCTION -> "\u2227";
                case DISJUNCTION -> "\u2228";
                default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)this)));
            };
        }
    }

    public static class CondisDepthCode {
        private final Adk mAdk;
        private final List<Integer> mDualJuncts;

        public CondisDepthCode(Adk adk, List<Integer> list) {
            this.mAdk = adk;
            this.mDualJuncts = list;
        }

        public Adk getAdk() {
            return this.mAdk;
        }

        public List<Integer> getDualJuncts() {
            return this.mDualJuncts;
        }

        public String toString() {
            return this.mAdk.getSymbol() + "-" + this.mDualJuncts.stream().map(Object::toString).collect(Collectors.joining("-"));
        }

        public static CondisDepthCode of(Term term) {
            return (CondisDepthCode)new CondisDepthCodeGenerator().transduce(term);
        }
    }
}

