/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IteratorConcatenation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class AutomatonWithImplicitSelfloops<LETTER, STATE>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    protected final AutomataLibraryServices mServices;
    protected final ILogger mLogger;
    protected final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mInputAutomaton;
    protected final Set<LETTER> mLooperLetters;
    protected final Predicate<STATE> mLooperStates;

    public AutomatonWithImplicitSelfloops(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, Set<LETTER> set, Predicate<STATE> predicate) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger("de.uni_freiburg.informatik.ultimate.core");
        this.mInputAutomaton = iNwaOutgoingLetterAndTransitionProvider;
        this.mLooperLetters = set;
        this.mLooperStates = predicate;
    }

    public AutomatonWithImplicitSelfloops(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, Set<LETTER> set) {
        this(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, set, object -> true);
    }

    @Override
    public int size() {
        return this.mInputAutomaton.size();
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mInputAutomaton.getAlphabet();
    }

    @Override
    public String sizeInformation() {
        return this.mInputAutomaton.size() + " states.";
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mInputAutomaton.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mInputAutomaton.getStateFactory();
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        return this.mInputAutomaton.getInitialStates();
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mInputAutomaton.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mInputAutomaton.isFinal(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mInputAutomaton.getEmptyStackState();
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        if (this.mLooperStates.test(STATE)) {
            HashSet<LETTER> hashSet = new HashSet<LETTER>();
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.internalSuccessors(STATE)) {
                hashSet.add(outgoingInternalTransition.getLetter());
            }
            return hashSet;
        }
        return this.mInputAutomaton.lettersInternal(STATE);
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        return Collections.emptySet();
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        return Collections.emptySet();
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        if (this.mLooperStates.test(STATE)) {
            if (this.mLooperLetters.contains(LETTER)) {
                return Collections.singleton(new OutgoingInternalTransition<LETTER, STATE>(LETTER, STATE));
            }
            return this.mInputAutomaton.internalSuccessors(STATE, LETTER);
        }
        return this.mInputAutomaton.internalSuccessors(STATE, LETTER);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        if (this.mLooperStates.test(STATE)) {
            ArrayList arrayList = new ArrayList();
            for (Object LETTER : this.mInputAutomaton.getAlphabet()) {
                arrayList.add(this.internalSuccessors(STATE, LETTER).iterator());
            }
            return () -> new IteratorConcatenation(arrayList);
        }
        return this.mInputAutomaton.internalSuccessors(STATE);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        if (this.mLooperStates.test(STATE)) {
            if (this.mLooperLetters.contains(LETTER)) {
                return Collections.singleton(new OutgoingCallTransition<LETTER, STATE>(LETTER, STATE));
            }
            return this.mInputAutomaton.callSuccessors(STATE, LETTER);
        }
        return this.mInputAutomaton.callSuccessors(STATE, LETTER);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        if (this.mLooperStates.test(STATE)) {
            ArrayList arrayList = new ArrayList();
            for (Object LETTER : this.mInputAutomaton.getVpAlphabet().getCallAlphabet()) {
                arrayList.add(this.callSuccessors(STATE, LETTER).iterator());
            }
            return () -> new IteratorConcatenation(arrayList);
        }
        return this.mInputAutomaton.callSuccessors(STATE);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        if (this.mLooperStates.test(STATE)) {
            if (this.mLooperLetters.contains(LETTER)) {
                return Collections.singleton(new OutgoingReturnTransition<LETTER, STATE>(STATE2, LETTER, STATE));
            }
            return this.mInputAutomaton.returnSuccessors(STATE, STATE2, LETTER);
        }
        return this.mInputAutomaton.returnSuccessors(STATE, STATE2, LETTER);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        if (this.mLooperStates.test(STATE)) {
            ArrayList arrayList = new ArrayList();
            for (Object LETTER : this.mInputAutomaton.getVpAlphabet().getReturnAlphabet()) {
                arrayList.add(this.returnSuccessors(STATE, STATE2, LETTER).iterator());
            }
            return () -> new IteratorConcatenation(arrayList);
        }
        return this.mInputAutomaton.returnSuccessorsGivenHier(STATE, STATE2);
    }

    public String toString() {
        return AutomatonDefinitionPrinter.toString(this.mServices, "nwa", this);
    }
}

