/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.dangerinvariants.DangerInvariantUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.LargeBlockEncodingIcfgTransformer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DangerInvariantGuesser {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final Map<IcfgLocation, IPredicate> mCandidateInvariant;
    private final IIcfg<IcfgLocation> mIcfg;
    private final CfgSmtToolkit mCsToolkit;
    private final PredicateFactory mPredicateFactory;

    public DangerInvariantGuesser(IIcfg<IcfgLocation> iIcfg, IUltimateServiceProvider iUltimateServiceProvider, IPredicate iPredicate, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mCsToolkit = cfgSmtToolkit;
        this.mPredicateFactory = predicateFactory;
        this.mIcfg = this.applyLargeBlockEncoding(iIcfg, predicateFactory, iPredicateUnifier);
        try {
            this.mCandidateInvariant = this.computeCandidateInvariant(iUltimateServiceProvider, predicateFactory, iPredicateUnifier, cfgSmtToolkit, this.mIcfg);
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            String string = "traversing ICFG of " + IcfgUtils.getNumberOfLocations(this.mIcfg) + " locations";
            toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), string));
            throw toolchainCanceledException;
        }
    }

    public Map<IcfgLocation, IPredicate> getCandidateInvariant() {
        return this.mCandidateInvariant;
    }

    public boolean isDangerInvariant() {
        IncrementalPlicationChecker.Validity validity = DangerInvariantUtils.checkDangerInvariant(this.mCandidateInvariant, this.mIcfg, (ManagedScript)this.mCsToolkit.getManagedScript(), (IUltimateServiceProvider)this.mServices, (BasicPredicateFactory)this.mPredicateFactory, (ILogger)this.mLogger);
        return validity == IncrementalPlicationChecker.Validity.VALID;
    }

    private IIcfg<IcfgLocation> applyLargeBlockEncoding(IIcfg<IcfgLocation> iIcfg, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier) {
        LargeBlockEncodingIcfgTransformer largeBlockEncodingIcfgTransformer = new LargeBlockEncodingIcfgTransformer(this.mServices, predicateFactory, iPredicateUnifier);
        IIcfg<IcfgLocation> iIcfg2 = largeBlockEncodingIcfgTransformer.transform(iIcfg);
        return iIcfg2;
    }

    private Map<IcfgLocation, IPredicate> computeCandidateInvariant(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, IIcfg<IcfgLocation> iIcfg) {
        IPredicate iPredicate;
        IcfgLocation icfgLocation2;
        Set set = IcfgUtils.getErrorLocations(iIcfg);
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        HashMap<IcfgLocation, IPredicate> hashMap = new HashMap<IcfgLocation, IPredicate>();
        for (IcfgLocation icfgLocation2 : set) {
            iPredicate = iPredicateUnifier.getTruePredicate();
            hashMap.put(icfgLocation2, iPredicate);
            linkedHashSet.add(icfgLocation2);
        }
        icfgLocation2 = new PredicateTransformer(cfgSmtToolkit.getManagedScript(), (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, cfgSmtToolkit.getManagedScript()));
        while (!linkedHashSet.isEmpty()) {
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(this.getClass(), "processing worklist containing " + linkedHashSet.size() + " elements");
            }
            Iterator iterator = linkedHashSet.iterator();
            iPredicate = (IcfgLocation)iterator.next();
            iterator.remove();
            for (IcfgEdge icfgEdge : iPredicate.getIncomingEdges()) {
                IPredicate iPredicate2;
                String string;
                Term term;
                String string2;
                IPredicate iPredicate3 = (IPredicate)hashMap.get(iPredicate);
                UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge.getTransformula();
                UnmodifiableTransFormula unmodifiableTransFormula2 = null;
                try {
                    unmodifiableTransFormula2 = TransFormulaUtils.computeGuardedHavoc((UnmodifiableTransFormula)unmodifiableTransFormula, (ManagedScript)cfgSmtToolkit.getManagedScript(), (IUltimateServiceProvider)iUltimateServiceProvider, (boolean)true);
                }
                catch (ToolchainCanceledException toolchainCanceledException) {
                    string2 = "computing guarded havoc for TransFormula of DAG size " + String.valueOf(new DagSizePrinter(unmodifiableTransFormula.getFormula()));
                    toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), string2));
                    throw toolchainCanceledException;
                }
                try {
                    term = this.computePre((PredicateTransformer<Term, IPredicate, TransFormula>)icfgLocation2, iPredicate3, unmodifiableTransFormula2, (BasicPredicateFactory)predicateFactory, cfgSmtToolkit);
                }
                catch (ToolchainCanceledException toolchainCanceledException) {
                    string = "computing PRE for IPredicate of DAG size " + String.valueOf(new DagSizePrinter(iPredicate3.getFormula())) + " and TransFormula of DAG size " + String.valueOf(new DagSizePrinter(unmodifiableTransFormula.getFormula()));
                    toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), string));
                    throw toolchainCanceledException;
                }
                string2 = (IcfgLocation)icfgEdge.getSource();
                string = (IPredicate)hashMap.get(string2);
                if (string == null) {
                    iPredicate2 = iPredicateUnifier.getOrConstructPredicate(term);
                    hashMap.put((IcfgLocation)string2, iPredicate2);
                    linkedHashSet.add(string2);
                    continue;
                }
                iPredicate2 = iPredicateUnifier.getOrConstructPredicate(SmtUtils.or((Script)cfgSmtToolkit.getManagedScript().getScript(), (Term[])new Term[]{string.getFormula(), term}));
                if (iPredicate2 == string) continue;
                hashMap.put((IcfgLocation)string2, iPredicate2);
                linkedHashSet.add(string2);
            }
        }
        this.addFalseToRemainingLocations(iIcfg, hashMap, iPredicateUnifier.getFalsePredicate());
        return hashMap;
    }

    private void addFalseToRemainingLocations(IIcfg<IcfgLocation> iIcfg, Map<IcfgLocation, IPredicate> map, IPredicate iPredicate) {
        for (Map.Entry entry : iIcfg.getProgramPoints().entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                IcfgLocation icfgLocation = (IcfgLocation)entry2.getValue();
                if (map.containsKey(icfgLocation)) continue;
                map.put(icfgLocation, iPredicate);
            }
        }
    }

    private Term computePre(PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula, BasicPredicateFactory basicPredicateFactory, CfgSmtToolkit cfgSmtToolkit) {
        Term term = (Term)predicateTransformer.weakestPrecondition((IAbstractPredicate)basicPredicateFactory.not(iPredicate), (ITransitionRelation)unmodifiableTransFormula);
        Term term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)cfgSmtToolkit.getManagedScript(), (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term);
        Term term3 = SmtUtils.not((Script)cfgSmtToolkit.getManagedScript().getScript(), (Term)term2);
        return term3;
    }
}

