/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.benchmark;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsGeneratorWithStopwatches;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.Collection;
import java.util.function.Function;

public final class AcceleratedInterpolationBenchmark
extends StatisticsGeneratorWithStopwatches
implements IStatisticsDataProvider {
    private static final String[] STOPWATCHES = new String[]{AcceleratedInterpolationStatisticsDefinitions.ACCELINTERPOL_CORE.toString(), AcceleratedInterpolationStatisticsDefinitions.ACCELINTERPOL_OVERALL.toString(), AcceleratedInterpolationStatisticsDefinitions.ACCELINTERPOL_LOOPDETECTOR.toString(), AcceleratedInterpolationStatisticsDefinitions.ACCELINTERPOL_LOOPACCELERATOR.toString()};

    public Collection<String> getKeys() {
        return this.getBenchmarkType().getKeys();
    }

    public Object getValue(String string) {
        Long l;
        AcceleratedInterpolationStatisticsDefinitions acceleratedInterpolationStatisticsDefinitions = AcceleratedInterpolationStatisticsDefinitions.valueOf(string);
        switch (acceleratedInterpolationStatisticsDefinitions) {
            case ACCELINTERPOL_CORE: 
            case ACCELINTERPOL_OVERALL: 
            case ACCELINTERPOL_LOOPDETECTOR: 
            case ACCELINTERPOL_LOOPACCELERATOR: {
                try {
                    l = this.getElapsedTime(string);
                    break;
                }
                catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
                    throw new AssertionError((Object)("clock still running: " + string));
                }
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        return l;
    }

    public IStatisticsType getBenchmarkType() {
        return AccelInterpolStatisticsType.getInstance();
    }

    public String[] getStopwatches() {
        return STOPWATCHES;
    }

    private static final class AccelInterpolStatisticsType
    extends StatisticsType<AcceleratedInterpolationStatisticsDefinitions> {
        private static final AccelInterpolStatisticsType INSTANCE = new AccelInterpolStatisticsType();

        AccelInterpolStatisticsType() {
            super(AcceleratedInterpolationStatisticsDefinitions.class);
        }

        public static AccelInterpolStatisticsType getInstance() {
            return INSTANCE;
        }
    }

    public static enum AcceleratedInterpolationStatisticsDefinitions implements IStatisticsElement
    {
        ACCELINTERPOL_CORE(StatisticsType.LONG_ADDITION, StatisticsType.NANOS_BEFORE_KEY),
        ACCELINTERPOL_OVERALL(StatisticsType.LONG_ADDITION, StatisticsType.NANOS_BEFORE_KEY),
        ACCELINTERPOL_LOOPDETECTOR(StatisticsType.LONG_ADDITION, StatisticsType.NANOS_BEFORE_KEY),
        ACCELINTERPOL_LOOPACCELERATOR(StatisticsType.LONG_ADDITION, StatisticsType.NANOS_BEFORE_KEY);

        private final Function<Object, Function<Object, Object>> mAggr;
        private final Function<String, Function<Object, String>> mPrettyprinter;

        private AcceleratedInterpolationStatisticsDefinitions(Function<Object, Function<Object, Object>> function, Function<String, Function<Object, String>> function2) {
            this.mAggr = function;
            this.mPrettyprinter = function2;
        }

        public Object aggregate(Object object, Object object2) {
            return this.mAggr.apply(object).apply(object2);
        }

        public String prettyprint(Object object) {
            return this.mPrettyprinter.apply(CoreUtil.getUpperToCamelCase((String)this.name())).apply(object);
        }
    }
}

