/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QuantClause {
    private final QuantifierTheory mQuantTheory;
    private final Literal[] mGroundLits;
    private final QuantLiteral[] mQuantLits;
    private final SourceAnnotation mSource;
    private final SourceAnnotation mQuantSource;
    private final Term mClauseWithProof;
    private final TermVariable[] mVars;
    private final VarInfo[] mVarInfos;
    private final LinkedHashMap<Term, Term>[] mInterestingTermsForVars;

    QuantClause(TermVariable[] termVariableArray, Literal[] literalArray, QuantLiteral[] quantLiteralArray, QuantifierTheory quantifierTheory, SourceAnnotation sourceAnnotation, Term term) {
        assert (quantLiteralArray.length != 0);
        this.mQuantTheory = quantifierTheory;
        this.mGroundLits = literalArray;
        this.mQuantLits = this.mQuantTheory.getLiteralCopies(quantLiteralArray, this);
        this.mSource = sourceAnnotation;
        this.mQuantSource = new SourceAnnotation(sourceAnnotation, true);
        this.mClauseWithProof = term;
        this.mVars = termVariableArray;
        this.mVarInfos = new VarInfo[this.mVars.length];
        int n = 0;
        while (n < this.mVars.length) {
            this.mVarInfos[n] = new VarInfo();
            ++n;
        }
        this.collectVarInfos();
        this.mInterestingTermsForVars = new LinkedHashMap[this.mVars.length];
        n = 0;
        while (n < this.mVars.length) {
            this.mInterestingTermsForVars[n] = new LinkedHashMap();
            ++n;
        }
    }

    public void updateInterestingTermsAllVars() {
        int n = 0;
        while (n < this.mVars.length) {
            this.collectBoundAndDefaultTerms(n);
            if (this.mVars[n].getSort().getName() != "Bool") {
                this.updateInterestingTermsForFuncArgs(this.mVars[n], n);
            }
            ++n;
        }
        this.synchronizeInterestingTermsAllVars();
    }

    public boolean hasTrueGroundLits() {
        Literal[] literalArray = this.mGroundLits;
        int n = this.mGroundLits.length;
        int n2 = 0;
        while (n2 < n) {
            Literal literal = literalArray[n2];
            if (literal.getAtom().getDecideStatus() == literal) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public QuantifierTheory getQuantTheory() {
        return this.mQuantTheory;
    }

    public Literal[] getGroundLits() {
        return this.mGroundLits;
    }

    public QuantLiteral[] getQuantLits() {
        return this.mQuantLits;
    }

    public SourceAnnotation getSource() {
        return this.mSource;
    }

    public SourceAnnotation getQuantSource() {
        return this.mQuantSource;
    }

    public TermVariable[] getVars() {
        return this.mVars;
    }

    public Set<Term> getGroundBounds(TermVariable termVariable) {
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        linkedHashSet.addAll(this.mVarInfos[this.getVarIndex((TermVariable)termVariable)].mUpperGroundBounds);
        linkedHashSet.addAll(this.mVarInfos[this.getVarIndex((TermVariable)termVariable)].mLowerGroundBounds);
        return linkedHashSet;
    }

    public Set<TermVariable> getVarBounds(TermVariable termVariable) {
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        linkedHashSet.addAll(this.mVarInfos[this.getVarIndex((TermVariable)termVariable)].mUpperVarBounds);
        linkedHashSet.addAll(this.mVarInfos[this.getVarIndex((TermVariable)termVariable)].mLowerVarBounds);
        return linkedHashSet;
    }

    public LinkedHashMap<Term, Term>[] getInterestingTerms() {
        return this.mInterestingTermsForVars;
    }

    public String toString() {
        return Arrays.toString(this.mGroundLits).concat(Arrays.toString(this.mQuantLits));
    }

    public Term toTerm(Theory theory) {
        int n = this.mGroundLits.length;
        int n2 = this.mQuantLits.length;
        Term[] termArray = new Term[n + n2];
        int n3 = 0;
        while (n3 < n) {
            termArray[n3] = this.mGroundLits[n3].getSMTFormula(theory);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            termArray[n3 + n] = this.mQuantLits[n3].getTerm();
            ++n3;
        }
        return theory.or(termArray);
    }

    public Term getClauseWithProof() {
        return this.mClauseWithProof;
    }

    void clearInterestingTerms() {
        int n = 0;
        while (n < this.mVars.length) {
            this.mInterestingTermsForVars[n].clear();
            ++n;
        }
    }

    int getVarIndex(TermVariable termVariable) {
        return Arrays.asList(this.mVars).indexOf(termVariable);
    }

    public boolean hasArrayIndices() {
        int n = 0;
        while (n < this.mVars.length) {
            for (ApplicationTerm applicationTerm : this.mVarInfos[n].mArrayTermsWithVar) {
                if (applicationTerm.getParameters()[1] != this.mVars[n]) continue;
                return true;
            }
            ++n;
        }
        return false;
    }

    private void collectVarInfos() {
        QuantLiteral[] quantLiteralArray = this.mQuantLits;
        int n = this.mQuantLits.length;
        int n2 = 0;
        while (n2 < n) {
            QuantLiteral quantLiteral = quantLiteralArray[n2];
            QuantLiteral quantLiteral2 = quantLiteral.getAtom();
            if (quantLiteral2 instanceof QuantBoundConstraint) {
                if (quantLiteral.isArithmetical()) {
                    Term[] termArray = QuantUtil.getArithmeticalTermLtTerm(quantLiteral, this.mQuantTheory.getClausifier().getTermCompiler());
                    if (termArray[0] instanceof TermVariable) {
                        var7_10 = (TermVariable)termArray[0];
                        object = this.mVarInfos[this.getVarIndex((TermVariable)var7_10)];
                        if (termArray[1] instanceof TermVariable) {
                            ((VarInfo)object).addUpperVarBound((TermVariable)termArray[1]);
                        } else {
                            assert (termArray[1].getFreeVars().length == 0);
                            ((VarInfo)object).addUpperGroundBound(termArray[1]);
                        }
                    }
                    if (termArray[1] instanceof TermVariable) {
                        var7_10 = (TermVariable)termArray[1];
                        object = this.mVarInfos[this.getVarIndex((TermVariable)var7_10)];
                        if (termArray[0] instanceof TermVariable) {
                            ((VarInfo)object).addLowerVarBound((TermVariable)termArray[0]);
                        } else {
                            assert (termArray[0].getFreeVars().length == 0);
                            ((VarInfo)object).addLowerGroundBound(termArray[0]);
                        }
                    }
                } else {
                    for (Map map : ((QuantBoundConstraint)quantLiteral2).getAffineTerm().getSummands().keySet()) {
                        for (Object object : map.keySet()) {
                            if (!(object instanceof ApplicationTerm) || object.getFreeVars().length == 0) continue;
                            this.addVarArgInfo((ApplicationTerm)object);
                        }
                    }
                }
            } else {
                assert (quantLiteral2 instanceof QuantEquality);
                QuantEquality quantEquality = (QuantEquality)quantLiteral2;
                var7_10 = quantEquality.getLhs();
                object = quantEquality.getRhs();
                if (quantLiteral.isArithmetical()) {
                    assert (var7_10 instanceof TermVariable && var7_10.getSort().getName() == "Int" && object.getFreeVars().length == 0);
                    int n3 = this.getVarIndex((TermVariable)var7_10);
                    VarInfo varInfo = this.mVarInfos[n3];
                    SMTAffineTerm sMTAffineTerm = new SMTAffineTerm((Term)object);
                    sMTAffineTerm.add(Rational.MONE);
                    SMTAffineTerm sMTAffineTerm2 = new SMTAffineTerm((Term)object);
                    sMTAffineTerm2.add(Rational.ONE);
                    Term term = sMTAffineTerm.toTerm(object.getSort());
                    Term term2 = sMTAffineTerm2.toTerm(object.getSort());
                    varInfo.addLowerGroundBound(term);
                    varInfo.addUpperGroundBound(term2);
                } else {
                    if (!(var7_10 instanceof TermVariable) && var7_10.getFreeVars().length != 0) {
                        assert (var7_10 instanceof ApplicationTerm);
                        this.addVarArgInfo((ApplicationTerm)var7_10);
                    }
                    if (!(object instanceof TermVariable) && object.getFreeVars().length != 0) {
                        assert (object instanceof ApplicationTerm);
                        this.addVarArgInfo((ApplicationTerm)object);
                    }
                }
            }
            ++n2;
        }
    }

    private void addVarArgInfo(ApplicationTerm applicationTerm) {
        block14: {
            FunctionSymbol functionSymbol;
            block15: {
                Term[] termArray;
                block13: {
                    functionSymbol = applicationTerm.getFunction();
                    termArray = applicationTerm.getParameters();
                    if (functionSymbol.isInterpreted()) break block13;
                    int n = 0;
                    while (n < termArray.length) {
                        Term term = termArray[n];
                        if (term instanceof TermVariable) {
                            int n2 = this.getVarIndex((TermVariable)term);
                            VarInfo varInfo = this.mVarInfos[n2];
                            varInfo.addPosition(functionSymbol, n);
                        } else if (term.getFreeVars().length != 0) {
                            assert (term instanceof ApplicationTerm);
                            this.addVarArgInfo((ApplicationTerm)term);
                        }
                        ++n;
                    }
                    break block14;
                }
                if (functionSymbol.getName() != "select" && functionSymbol.getName() != "store") break block15;
                int n = 0;
                while (n < termArray.length) {
                    Term term = termArray[n];
                    if (n != 0 || !(term instanceof TermVariable)) {
                        if (n != 0 && term instanceof TermVariable) {
                            int n3 = this.getVarIndex((TermVariable)term);
                            VarInfo varInfo = this.mVarInfos[n3];
                            varInfo.addArrayTerm(applicationTerm);
                        } else if (term.getFreeVars().length != 0) {
                            assert (term instanceof ApplicationTerm);
                            this.addVarArgInfo((ApplicationTerm)term);
                        }
                    }
                    ++n;
                }
                break block14;
            }
            if (functionSymbol.getName() != "+" && functionSymbol.getName() != "-" && functionSymbol.getName() != "*") break block14;
            Polynomial polynomial = new Polynomial((Term)applicationTerm);
            for (Map<Term, Integer> map : polynomial.getSummands().keySet()) {
                for (Term term : map.keySet()) {
                    if (!(term instanceof ApplicationTerm)) continue;
                    this.addVarArgInfo((ApplicationTerm)term);
                }
            }
        }
    }

    private void collectBoundAndDefaultTerms(int n) {
        this.addAllInteresting(this.mInterestingTermsForVars[n], this.mVarInfos[n].mLowerGroundBounds);
        this.addAllInteresting(this.mInterestingTermsForVars[n], this.mVarInfos[n].mUpperGroundBounds);
        if (this.mVars[n].getSort().getName() == "Bool") {
            ApplicationTerm applicationTerm = this.mQuantTheory.getTheory().mTrue;
            ApplicationTerm applicationTerm2 = this.mQuantTheory.getTheory().mFalse;
            this.mInterestingTermsForVars[n].put((Term)applicationTerm, (Term)applicationTerm);
            this.mInterestingTermsForVars[n].put((Term)applicationTerm2, (Term)applicationTerm2);
        } else {
            Term term = this.mQuantTheory.getLambda(this.mVars[n].getSort());
            this.mInterestingTermsForVars[n].put(term, term);
        }
    }

    private void synchronizeInterestingTermsAllVars() {
        boolean bl = true;
        while (bl && !this.mQuantTheory.getEngine().isTerminationRequested()) {
            bl = false;
            int n = 0;
            while (n < this.mVars.length) {
                for (TermVariable termVariable : this.getVarBounds(this.mVars[n])) {
                    int n2 = this.getVarIndex(termVariable);
                    bl = this.addAllInteresting(this.mInterestingTermsForVars[n], this.mInterestingTermsForVars[n2].values());
                }
                ++n;
            }
        }
    }

    private void updateInterestingTermsForFuncArgs(TermVariable termVariable, int n) {
        CCTerm cCTerm;
        Iterator iterator;
        Object object;
        Object object2;
        FunctionSymbol functionSymbol;
        VarInfo varInfo = this.mVarInfos[this.getVarIndex(termVariable)];
        assert (varInfo != null);
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        for (Map.Entry<FunctionSymbol, BitSet> applicationTerm : varInfo.mFuncArgPositions.entrySet()) {
            if (this.mQuantTheory.getEngine().isTerminationRequested()) {
                return;
            }
            functionSymbol = applicationTerm.getKey();
            object2 = applicationTerm.getValue();
            int termArray = ((BitSet)object2).nextSetBit(0);
            while (termArray >= 0) {
                object = this.mQuantTheory.mCClosure.getArgTermsForFunc(functionSymbol, termArray);
                if (object != null) {
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        cCTerm = (CCTerm)iterator.next();
                        linkedHashSet.add(cCTerm.getFlatTerm());
                    }
                }
                termArray = ((BitSet)object2).nextSetBit(termArray + 1);
            }
        }
        for (ApplicationTerm applicationTerm : varInfo.mArrayTermsWithVar) {
            Object object3;
            List<CCTerm> list;
            FunctionSymbol functionSymbol2;
            Sort[] sortArray;
            functionSymbol = applicationTerm.getFunction();
            object2 = functionSymbol.getName();
            Term[] termArray = applicationTerm.getParameters();
            object = termArray[0];
            cCTerm = this.mQuantTheory.getCClosure().getCCTermRep((Term)object);
            Iterator iterator2 = iterator = cCTerm == null ? null : this.mQuantTheory.getClausifier().getArrayTheory().getWeakRep(cCTerm);
            if (termArray[1] == termVariable) {
                Rational rational;
                Object object4;
                sortArray = object2 == "store" ? functionSymbol.getParameterSorts() : new Sort[]{functionSymbol.getParameterSorts()[0], functionSymbol.getParameterSorts()[1], functionSymbol.getReturnSort()};
                functionSymbol2 = this.mQuantTheory.getTheory().getFunction("store", sortArray);
                list = this.mQuantTheory.getCClosure().getAllFuncApps(functionSymbol2);
                for (CCTerm cCTerm2 : list) {
                    object3 = ArrayTheory.getArrayFromStore((CCAppTerm)cCTerm2);
                    if (!(iterator == null ? ((CCTerm)object3).getFlatTerm().getSort() == object.getSort() : iterator == this.mQuantTheory.getClausifier().getArrayTheory().getWeakRep((CCTerm)object3))) continue;
                    object4 = ArrayTheory.getIndexFromStore((CCAppTerm)cCTerm2).getFlatTerm();
                    linkedHashSet.add((Term)object4);
                    if (object2 != "select" || termVariable.getSort().getName() != "Int" || QuantUtil.isLambda(object4)) continue;
                    Rational[] rationalArray = new Rational[]{Rational.ONE, Rational.MONE};
                    int n2 = rationalArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        rational = rationalArray[n3];
                        SMTAffineTerm sMTAffineTerm = new SMTAffineTerm((Term)object4);
                        sMTAffineTerm.add(rational);
                        Term term = sMTAffineTerm.toTerm(object4.getSort());
                        linkedHashSet.add(term);
                        ++n3;
                    }
                }
                if (object2 == "select") {
                    Sort[] sortArray2 = functionSymbol.getParameterSorts();
                    FunctionSymbol functionSymbol3 = this.mQuantTheory.getTheory().getFunction("select", sortArray2);
                    object3 = this.mQuantTheory.getCClosure().getAllFuncApps(functionSymbol3);
                    rational = object3.iterator();
                    while (rational.hasNext()) {
                        object4 = (CCTerm)rational.next();
                        CCTerm cCTerm3 = ArrayTheory.getArrayFromSelect((CCAppTerm)object4);
                        if (!(iterator == null ? cCTerm3.getFlatTerm().getSort() == object.getSort() : iterator == this.mQuantTheory.getClausifier().getArrayTheory().getWeakRep(cCTerm3))) continue;
                        CCTerm cCTerm4 = ArrayTheory.getIndexFromSelect((CCAppTerm)object4);
                        linkedHashSet.add(cCTerm4.getFlatTerm());
                    }
                }
            }
            if (object2 != "store" || termArray[2] != termVariable) continue;
            sortArray = Arrays.copyOf(functionSymbol.getParameterSorts(), 2);
            functionSymbol2 = this.mQuantTheory.getTheory().getFunction("select", sortArray);
            list = this.mQuantTheory.getCClosure().getAllFuncApps(functionSymbol2);
            for (CCTerm cCTerm5 : list) {
                object3 = ArrayTheory.getArrayFromSelect((CCAppTerm)cCTerm5);
                if (!(iterator == null ? ((CCTerm)object3).getFlatTerm().getSort() == object.getSort() : iterator == this.mQuantTheory.getClausifier().getArrayTheory().getWeakRep((CCTerm)object3))) continue;
                linkedHashSet.add(cCTerm5.getFlatTerm());
            }
        }
        this.addAllInteresting(this.mInterestingTermsForVars[n], linkedHashSet);
    }

    private boolean addAllInteresting(Map<Term, Term> map, Collection<Term> collection) {
        boolean bl = false;
        for (Term term : collection) {
            Term term2 = this.mQuantTheory.getRepresentativeTerm(term);
            if (map.containsKey(term2)) continue;
            map.put(term2, term);
            bl = true;
        }
        return bl;
    }

    private class VarInfo {
        private final Map<FunctionSymbol, BitSet> mFuncArgPositions = new LinkedHashMap<FunctionSymbol, BitSet>();
        private final Set<ApplicationTerm> mArrayTermsWithVar = new LinkedHashSet<ApplicationTerm>();
        private final Set<Term> mLowerGroundBounds = new LinkedHashSet<Term>();
        private final Set<Term> mUpperGroundBounds = new LinkedHashSet<Term>();
        private final Set<TermVariable> mLowerVarBounds = new LinkedHashSet<TermVariable>();
        private final Set<TermVariable> mUpperVarBounds = new LinkedHashSet<TermVariable>();

        VarInfo() {
        }

        void addPosition(FunctionSymbol functionSymbol, int n) {
            if (this.mFuncArgPositions.containsKey(functionSymbol)) {
                BitSet bitSet = this.mFuncArgPositions.get(functionSymbol);
                bitSet.set(n);
            } else {
                BitSet bitSet = new BitSet(functionSymbol.getParameterSorts().length);
                bitSet.set(n);
                this.mFuncArgPositions.put(functionSymbol, bitSet);
            }
        }

        void addArrayTerm(ApplicationTerm applicationTerm) {
            this.mArrayTermsWithVar.add(applicationTerm);
        }

        void addLowerGroundBound(Term term) {
            this.mLowerGroundBounds.add(term);
        }

        void addUpperGroundBound(Term term) {
            this.mUpperGroundBounds.add(term);
        }

        void addLowerVarBound(TermVariable termVariable) {
            this.mLowerVarBounds.add(termVariable);
        }

        void addUpperVarBound(TermVariable termVariable) {
            this.mUpperVarBounds.add(termVariable);
        }
    }
}

