/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.translation;

import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ProgramExecutionFormatter<TE, E> {
    private final IBacktranslationValueProvider<TE, E> mStringProvider;

    public ProgramExecutionFormatter(IBacktranslationValueProvider<TE, E> iBacktranslationValueProvider) {
        this.mStringProvider = iBacktranslationValueProvider;
    }

    public String formatProgramExecution(IProgramExecution<TE, E> iProgramExecution) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getValuesAsString(iProgramExecution.getInitialProgramState());
        String string2 = CoreUtil.getPlatformLineSeparator();
        List<String> list = this.getLineNumberColumn(iProgramExecution);
        int n = ProgramExecutionFormatter.getColumnMaxLength(list);
        List<String> list2 = this.getStepInfoColum(iProgramExecution);
        int n2 = ProgramExecutionFormatter.getColumnMaxLength(list2);
        if (n2 < 6) {
            n2 = 6;
        }
        List<String> list3 = this.getThreadIdColumn(iProgramExecution);
        int n3 = ProgramExecutionFormatter.getColumnMaxLength(list3);
        List<String> list4 = this.getRelevanceInformationColumn(iProgramExecution);
        int n4 = ProgramExecutionFormatter.getColumnMaxLength(list4);
        int n5 = n2 + n4 + n3;
        if (string != null) {
            stringBuilder.append(ProgramExecutionFormatter.fillWithChar(" ", n));
            ProgramExecutionFormatter.addFixedLength(stringBuilder, "IVAL", n5, " ");
            stringBuilder.append(string);
            stringBuilder.append(string2);
        }
        int n6 = 0;
        while (n6 < iProgramExecution.getLength()) {
            ProgramExecutionFormatter.addFixedLength(stringBuilder, list, n6, n, " ");
            ProgramExecutionFormatter.addFixedLength(stringBuilder, list2, n6, n2, " ");
            ProgramExecutionFormatter.addFixedLength(stringBuilder, list4, n6, n4, " ");
            ProgramExecutionFormatter.addFixedLength(stringBuilder, list3, n6, n3, " ");
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n6);
            this.appendStepAsString(stringBuilder, atomicTraceElement, false);
            stringBuilder.append(string2);
            string = this.getValuesAsString(iProgramExecution.getProgramState(n6));
            if (string != null) {
                stringBuilder.append(ProgramExecutionFormatter.fillWithChar(" ", n));
                ProgramExecutionFormatter.addFixedLength(stringBuilder, "VAL", n5, " ");
                stringBuilder.append(string);
                stringBuilder.append(string2);
            }
            ++n6;
        }
        return stringBuilder.toString();
    }

    private void appendStepAsString(StringBuilder stringBuilder, AtomicTraceElement<TE> atomicTraceElement, boolean bl) {
        boolean bl2;
        Object object = atomicTraceElement.getStep();
        String string = this.mStringProvider.getStringFromStep(object);
        boolean bl3 = bl2 = bl && (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE) || atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE));
        if (bl2) {
            stringBuilder.append("[");
        }
        if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE)) {
            stringBuilder.append("!(");
            stringBuilder.append(string);
            stringBuilder.append(")");
        } else {
            stringBuilder.append(string);
        }
        if (bl2) {
            stringBuilder.append("]");
        }
    }

    private String getValuesAsString(IProgramExecution.ProgramState<E> programState) {
        if (programState == null || programState.getVariables().isEmpty()) {
            return null;
        }
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        for (Object e : programState.getVariables()) {
            String string = this.mStringProvider.getStringFromExpression(e);
            for (Object e2 : programState.getValues(e)) {
                arrayList.add((CallSite)((Object)(string + "=" + this.mStringProvider.getStringFromExpression(e2))));
            }
        }
        return "[" + arrayList.stream().sorted().collect(Collectors.joining(", ")) + "]";
    }

    private static void addFixedLength(StringBuilder stringBuilder, String string, int n, String string2) {
        stringBuilder.append(string);
        stringBuilder.append(ProgramExecutionFormatter.fillWithChar(string2, n - string.length()));
    }

    private static void addFixedLength(StringBuilder stringBuilder, List<String> list, int n, int n2, String string) {
        if (list == null) {
            return;
        }
        ProgramExecutionFormatter.addFixedLength(stringBuilder, list.get(n), n2, string);
    }

    private static String fillWithChar(String string, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(string);
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static int getColumnMaxLength(List<String> list) {
        if (list == null) {
            return 0;
        }
        return ProgramExecutionFormatter.getMaxLength(list) + 2;
    }

    private static int getMaxLength(List<String> list) {
        int n = 0;
        for (String string : list) {
            int n2 = string.length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private List<String> getThreadIdColumn(IProgramExecution<TE, E> iProgramExecution) {
        if (!iProgramExecution.isConcurrent()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < iProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n);
            arrayList.add(String.valueOf(atomicTraceElement.getThreadId()));
            ++n;
        }
        return arrayList;
    }

    private List<String> getStepInfoColum(IProgramExecution<TE, E> iProgramExecution) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < iProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n);
            if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.NONE)) {
                arrayList.add("");
            } else {
                String string = atomicTraceElement.getStepInfo().toString();
                arrayList.add(string.substring(1, string.length() - 1));
            }
            ++n;
        }
        return arrayList;
    }

    private List<String> getLineNumberColumn(IProgramExecution<TE, E> iProgramExecution) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < iProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n);
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = this.mStringProvider.getStartLineNumberFromStep(atomicTraceElement.getStep());
            int n3 = this.mStringProvider.getEndLineNumberFromStep(atomicTraceElement.getStep());
            if (n2 < 0) {
                stringBuilder.append("[?]");
            } else {
                stringBuilder.append("[L");
                if (n2 == n3) {
                    stringBuilder.append(n2);
                } else {
                    stringBuilder.append(n2);
                    stringBuilder.append("-L");
                    stringBuilder.append(n3);
                }
                stringBuilder.append("]");
            }
            arrayList.add(stringBuilder.toString());
            ++n;
        }
        return arrayList;
    }

    private List<String> getRelevanceInformationColumn(IProgramExecution<TE, E> iProgramExecution) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while (n2 < iProgramExecution.getLength()) {
            IRelevanceInformation iRelevanceInformation = iProgramExecution.getTraceElement(n2).getRelevanceInformation();
            if (iRelevanceInformation == null) {
                arrayList.add("?");
            } else {
                arrayList.add(iRelevanceInformation.getShortString());
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        return arrayList;
    }
}

