/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.FunctionDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.IFloatingPointHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.IPointerIntegerConversion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.NonBijectiveMapping;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.OverapproximationUF;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.ISOIEC9899TC3;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;

public abstract class ExpressionTranslation {
    protected final FunctionDeclarations mFunctionDeclarations;
    protected final TypeSizes mTypeSizes;
    protected final ITypeHandler mTypeHandler;
    protected final IPointerIntegerConversion mPointerIntegerConversion;
    protected final FlatSymbolTable mSymboltable;
    protected final TranslationSettings mSettings;

    public ExpressionTranslation(TypeSizes typeSizes, TranslationSettings translationSettings, ITypeHandler iTypeHandler, FlatSymbolTable flatSymbolTable) {
        this.mSettings = translationSettings;
        this.mTypeSizes = typeSizes;
        this.mTypeHandler = iTypeHandler;
        this.mSymboltable = flatSymbolTable;
        this.mFunctionDeclarations = new FunctionDeclarations(this.mTypeHandler, this.mTypeSizes);
        this.mPointerIntegerConversion = switch (this.mSettings.getPointerIntegerCastMode()) {
            case CACSLPreferenceInitializer.PointerIntegerConversion.NonBijectiveMapping -> new NonBijectiveMapping(this, this.mTypeSizes);
            case CACSLPreferenceInitializer.PointerIntegerConversion.Overapproximate -> new OverapproximationUF(this, this.mFunctionDeclarations, this.mTypeHandler, this.mTypeSizes);
            default -> throw new MatchException(null, null);
        };
    }

    public final Expression constructBinaryComparisonExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE || cPrimitive2.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE) {
            return this.constructBinaryComparisonFloatingPointExpression(iLocation, n, expression, cPrimitive, expression2, cPrimitive2);
        }
        return this.constructBinaryComparisonIntegerExpression(iLocation, n, expression, cPrimitive, expression2, cPrimitive2);
    }

    public final ExpressionResult handleBinaryBitwiseExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2, AuxVarInfoBuilder auxVarInfoBuilder) {
        if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE || cPrimitive2.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE) {
            throw new UnsupportedSyntaxException(LocationFactory.createIgnoreCLocation(), "we do not support floats");
        }
        return this.handleBinaryBitwiseIntegerExpression(iLocation, n, expression, cPrimitive, expression2, cPrimitive2, auxVarInfoBuilder);
    }

    public final ExpressionResult handleBitshiftExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2, AuxVarInfoBuilder auxVarInfoBuilder) {
        ExpressionResult expressionResult = this.handleBinaryBitwiseIntegerExpression(iLocation, n, expression, cPrimitive, expression2, cPrimitive2, auxVarInfoBuilder);
        if (this.mSettings.checkSignedIntegerBounds() == CACSLPreferenceInitializer.CheckMode.IGNORE || !cPrimitive.isIntegerType() || this.mTypeSizes.isUnsigned(cPrimitive)) {
            return expressionResult;
        }
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        this.addOverflowCheck(iLocation, this.constructTypeCheckForShift(iLocation, expression, cPrimitive, cPrimitive2, expression2, n), expressionResultBuilder);
        expressionResultBuilder.addAllIncludingLrValue(expressionResult);
        if (n == 6 || n == 23) {
            Pair<Expression, Expression> pair = this.constructOverflowCheckForLeftShift(iLocation, cPrimitive, expression, expression2, expressionResult);
            this.addOverflowCheck(iLocation, (Expression)pair.getFirst(), expressionResultBuilder);
            this.addOverflowCheck(iLocation, (Expression)pair.getSecond(), expressionResultBuilder);
        }
        return expressionResultBuilder.build();
    }

    protected abstract Pair<Expression, Expression> constructOverflowCheckForLeftShift(ILocation var1, CPrimitive var2, Expression var3, Expression var4, ExpressionResult var5);

    private Expression constructTypeCheckForShift(ILocation iLocation, Expression expression, CPrimitive cPrimitive, CPrimitive cPrimitive2, Expression expression2, int n) {
        Expression expression3 = this.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.ZERO);
        Expression expression4 = this.constructBinaryComparisonExpression(iLocation, 10, expression3, cPrimitive2, expression2, cPrimitive2);
        BigInteger bigInteger = BigInteger.valueOf(8 * this.mTypeSizes.getSize(cPrimitive.getType()));
        Expression expression5 = this.constructLiteralForIntegerType(iLocation, cPrimitive2, bigInteger);
        expression3 = this.constructBinaryComparisonExpression(iLocation, 8, expression2, cPrimitive2, expression5, cPrimitive2);
        if (n == 7 || n == 24) {
            return ExpressionFactory.and((ILocation)iLocation, List.of(expression4, expression3));
        }
        expression5 = this.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
        bigInteger = this.constructBinaryComparisonExpression(iLocation, 10, expression5, cPrimitive, expression, cPrimitive);
        return ExpressionFactory.and((ILocation)iLocation, List.of(bigInteger, expression4, expression3));
    }

    public final Expression constructUnaryExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive) {
        if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE) {
            return this.constructUnaryFloatingPointExpression(iLocation, n, expression, cPrimitive);
        }
        return this.constructUnaryIntegerExpression(iLocation, n, expression, cPrimitive);
    }

    public final Expression constructArithmeticExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        try {
            if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE || cPrimitive2.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE) {
                return this.constructArithmeticFloatingPointExpression(iLocation, n, expression, cPrimitive, expression2, cPrimitive2);
            }
            return this.constructArithmeticIntegerExpression(iLocation, n, expression, cPrimitive, expression2, cPrimitive2);
        }
        catch (ArithmeticException arithmeticException) {
            String string = arithmeticException.getMessage().contains("divide by zero") ? "Division by zero" : arithmeticException.getMessage();
            throw new IncorrectSyntaxException(iLocation, string);
        }
    }

    public abstract Expression constructBinaryComparisonIntegerExpression(ILocation var1, int var2, Expression var3, CPrimitive var4, Expression var5, CPrimitive var6);

    protected abstract ExpressionResult handleBinaryBitwiseIntegerExpression(ILocation var1, int var2, Expression var3, CPrimitive var4, Expression var5, CPrimitive var6, AuxVarInfoBuilder var7);

    protected abstract Expression constructUnaryIntegerExpression(ILocation var1, int var2, Expression var3, CPrimitive var4);

    public abstract Expression constructArithmeticIntegerExpression(ILocation var1, int var2, Expression var3, CPrimitive var4, Expression var5, CPrimitive var6);

    public abstract Expression constructBinaryComparisonFloatingPointExpression(ILocation var1, int var2, Expression var3, CPrimitive var4, Expression var5, CPrimitive var6);

    protected abstract Expression constructUnaryFloatingPointExpression(ILocation var1, int var2, Expression var3, CPrimitive var4);

    protected abstract Expression constructArithmeticFloatingPointExpression(ILocation var1, int var2, Expression var3, CPrimitive var4, Expression var5, CPrimitive var6);

    public final Expression constructBinaryEqualityExpression(ILocation iLocation, int n, Expression expression, ICType iCType, Expression expression2, ICType iCType2) {
        if (iCType.isRealFloatingType() || iCType2.isRealFloatingType()) {
            return this.constructBinaryEqualityExpressionFloating(iLocation, n, expression, iCType, expression2, iCType2);
        }
        return this.constructBinaryEqualityExpressionInteger(iLocation, n, expression, iCType, expression2, iCType2);
    }

    protected abstract Expression constructBinaryEqualityExpressionFloating(ILocation var1, int var2, Expression var3, ICType var4, Expression var5, ICType var6);

    protected abstract Expression constructBinaryEqualityExpressionInteger(ILocation var1, int var2, Expression var3, ICType var4, Expression var5, ICType var6);

    public abstract RValue translateIntegerLiteral(ILocation var1, String var2);

    public final RValue translateFloatingLiteral(ILocation iLocation, String string) {
        ISOIEC9899TC3.FloatingPointLiteral floatingPointLiteral;
        try {
            floatingPointLiteral = ISOIEC9899TC3.handleFloatConstant(string, iLocation);
        }
        catch (ArithmeticException arithmeticException) {
            throw new UnsupportedSyntaxException(iLocation, "Unable to represent float literal " + string + " (" + arithmeticException.getMessage() + ")");
        }
        Expression expression = this.constructLiteralForFloatingType(iLocation, floatingPointLiteral.getCPrimitive(), floatingPointLiteral.getDecimalRepresenation());
        return new RValue(expression, floatingPointLiteral.getCPrimitive());
    }

    public abstract Expression constructLiteralForIntegerType(ILocation var1, CPrimitive var2, BigInteger var3);

    public abstract Expression constructLiteralForFloatingType(ILocation var1, CPrimitive var2, BigDecimal var3);

    public FunctionDeclarations getFunctionDeclarations() {
        return this.mFunctionDeclarations;
    }

    protected abstract ExpressionResult convertIntToIntNonBool(ILocation var1, ExpressionResult var2, CPrimitive var3);

    public final ExpressionResult convertIntToInt(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        if (cPrimitive.getType() == CPrimitive.CPrimitives.BOOL) {
            return this.convertToBool(iLocation, expressionResult);
        }
        return this.convertIntToIntNonBool(iLocation, expressionResult, cPrimitive);
    }

    public abstract CPrimitive getCTypeOfPointerComponents();

    public final ExpressionResult convertPointerToInt(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        return this.mPointerIntegerConversion.convertPointerToInt(iLocation, expressionResult, cPrimitive);
    }

    public final ExpressionResult convertIntToPointer(ILocation iLocation, ExpressionResult expressionResult, CPointer cPointer) {
        return this.mPointerIntegerConversion.convertIntToPointer(iLocation, expressionResult, cPointer);
    }

    public ExpressionResult convertFloatToInt(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        if (cPrimitive.getType() == CPrimitive.CPrimitives.BOOL) {
            return this.convertToBool(iLocation, expressionResult);
        }
        return this.convertFloatToIntNonBool(iLocation, expressionResult, cPrimitive);
    }

    public abstract ExpressionResult convertFloatToFloat(ILocation var1, ExpressionResult var2, CPrimitive var3);

    public abstract ExpressionResult convertIntToFloat(ILocation var1, ExpressionResult var2, CPrimitive var3);

    protected abstract ExpressionResult convertFloatToIntNonBool(ILocation var1, ExpressionResult var2, CPrimitive var3);

    public abstract void declareFloatingPointConstructors(ILocation var1, CPrimitive var2);

    ExpressionResult convertToBool(ILocation iLocation, ExpressionResult expressionResult) {
        Expression expression;
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        iCType = CEnum.replaceEnumWithInt(iCType);
        Expression expression2 = this.constructZero(iLocation, iCType);
        if (iCType instanceof CPointer) {
            expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expressionResult.getLrValue().getValue(), (Expression)expression2);
        } else if (iCType instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType;
            expression = this.constructBinaryComparisonExpression(iLocation, 28, expressionResult.getLrValue().getValue(), cPrimitive, expression2, cPrimitive);
        } else {
            throw new UnsupportedOperationException("unsupported: conversion from " + String.valueOf(iCType) + " to _Bool");
        }
        Expression expression3 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.BOOL), BigInteger.ZERO);
        Expression expression4 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.BOOL), BigInteger.ONE);
        Expression expression5 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression, (Expression)expression3, (Expression)expression4);
        RValue rValue = new RValue(expression5, new CPrimitive(CPrimitive.CPrimitives.BOOL), false, false);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    public void addAssumeValueInRangeStatements(ILocation iLocation, Expression expression, ICType iCType, ExpressionResultBuilder expressionResultBuilder) {
        Optional<Expression> optional = this.getTypeConstraint(iLocation, expression, iCType);
        if (optional.isPresent()) {
            expressionResultBuilder.addStatement((Statement)new AssumeStatement(iLocation, optional.get()));
        }
    }

    public abstract Optional<Expression> getTypeConstraint(ILocation var1, Expression var2, ICType var3);

    public Expression constructNullPointer(ILocation iLocation) {
        return this.constructPointerForIntegerValues(iLocation, BigInteger.ZERO, BigInteger.ZERO);
    }

    public Expression constructPointerForIntegerValues(ILocation iLocation, BigInteger bigInteger, BigInteger bigInteger2) {
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.getCTypeOfPointerComponents(), bigInteger);
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.getCTypeOfPointerComponents(), bigInteger2);
        return MemoryHandler.constructPointerFromBaseAndOffset(expression, expression2, iLocation);
    }

    public Expression constructZero(ILocation iLocation, ICType iCType) {
        if (iCType instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType;
            return switch (cPrimitive.getGeneralType()) {
                case CPrimitive.CPrimitiveCategory.FLOATTYPE -> this.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ZERO);
                case CPrimitive.CPrimitiveCategory.INTTYPE -> this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
                case CPrimitive.CPrimitiveCategory.VOID -> throw new UnsupportedSyntaxException(iLocation, "no 0 value of type VOID");
                default -> throw new MatchException(null, null);
            };
        }
        if (iCType instanceof CPointer || iCType instanceof CArray) {
            return this.constructNullPointer(iLocation);
        }
        throw new UnsupportedSyntaxException(iLocation, "don't know 0 value for type " + String.valueOf(iCType));
    }

    public abstract Expression extractBits(ILocation var1, Expression var2, int var3, int var4);

    public abstract Expression eraseBits(ILocation var1, Expression var2, CPrimitive var3, int var4);

    public abstract Expression concatBits(ILocation var1, List<Expression> var2, int var3);

    public abstract Expression signExtend(ILocation var1, Expression var2, int var3, int var4);

    public abstract Expression getCurrentRoundingMode();

    public abstract void declareFloatConstant(ILocation var1, String var2, CPrimitive var3);

    public abstract void declareBinaryBitvectorFunctionsForAllIntegerDatatypes(ILocation var1, BitvectorConstant.BvOp[] var2);

    public Expression constructOverapproximationFloatLiteral(ILocation iLocation, String string, CPrimitive cPrimitive) {
        String string2 = "floatingLiteral_" + ExpressionTranslation.makeBoogieIdentifierSuffix(string) + "_" + String.valueOf(cPrimitive);
        String string3 = "~" + string2;
        if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string3)) {
            NamedAttribute namedAttribute = new NamedAttribute(iLocation, "overapproximation", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string2)});
            Attribute[] attributeArray = new Attribute[]{namedAttribute};
            ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
            this.mFunctionDeclarations.declareFunction(iLocation, string3, attributeArray, aSTType, new ASTType[0]);
        }
        return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string3, (Expression[])new Expression[0], (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
    }

    private static String makeBoogieIdentifierSuffix(String string) {
        return string;
    }

    protected Attribute[] generateAttributes(ILocation iLocation, boolean bl, String string, int[] nArray) {
        Attribute[] attributeArray;
        if (bl) {
            NamedAttribute namedAttribute = new NamedAttribute(iLocation, "overapproximation", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
            attributeArray = new Attribute[]{namedAttribute};
        } else if (nArray == null) {
            NamedAttribute namedAttribute = new NamedAttribute(iLocation, "builtin", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
            attributeArray = new Attribute[]{namedAttribute};
        } else {
            IntegerLiteral[] integerLiteralArray = new IntegerLiteral[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                integerLiteralArray[n] = ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)String.valueOf(nArray[n]));
                ++n;
            }
            NamedAttribute namedAttribute = new NamedAttribute(iLocation, "builtin", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)string)});
            NamedAttribute namedAttribute2 = new NamedAttribute(iLocation, "indices", (Expression[])integerLiteralArray);
            attributeArray = new Attribute[]{namedAttribute, namedAttribute2};
        }
        return attributeArray;
    }

    public void addOverflowCheck(ILocation iLocation, Expression expression, ExpressionResultBuilder expressionResultBuilder) {
        if (ExpressionFactory.isTrueLiteral((Expression)expression) || this.mSettings.checkSignedIntegerBounds() == CACSLPreferenceInitializer.CheckMode.IGNORE) {
            return;
        }
        if (this.mSettings.checkSignedIntegerBounds() == CACSLPreferenceInitializer.CheckMode.CHECK) {
            AssertStatement assertStatement = new AssertStatement(iLocation, expression);
            new Check(Spec.INTEGER_OVERFLOW).annotate((IElement)assertStatement);
            expressionResultBuilder.addStatement((Statement)assertStatement);
        } else {
            expressionResultBuilder.addStatement((Statement)new AssumeStatement(iLocation, expression));
        }
    }

    public Expression boolToInt(ILocation iLocation, Expression expression) {
        return this.boolToInt(iLocation, expression, CPrimitive.CPrimitives.INT);
    }

    public Expression boolToInt(ILocation iLocation, Expression expression, CPrimitive.CPrimitives cPrimitives) {
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(cPrimitives), BigInteger.ONE);
        Expression expression3 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(cPrimitives), BigInteger.ZERO);
        return ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression, (Expression)expression2, (Expression)expression3);
    }

    public Expression toBool(ILocation iLocation, Expression expression, ICType iCType) {
        ICType iCType2 = CEnum.replaceEnumWithInt(iCType.getUnderlyingType());
        Expression expression2 = this.constructZero(iLocation, iCType2);
        if (iCType2 instanceof CPrimitive) {
            return this.constructBinaryEqualityExpression(iLocation, 29, expression, iCType, expression2, iCType2);
        }
        if (iCType2 instanceof CPointer || iCType2 instanceof CArray) {
            return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPNEQ, (Expression)expression, (Expression)expression2);
        }
        throw new UnsupportedSyntaxException(iLocation, "unsupported type " + String.valueOf(iCType2));
    }

    public abstract Expression transformBitvectorToFloat(ILocation var1, Expression var2, CPrimitive.CPrimitives var3);

    public abstract Expression transformFloatToBitvector(ILocation var1, Expression var2, CPrimitive.CPrimitives var3);

    public abstract RValue constructBuiltinFegetround(ILocation var1);

    public abstract ExpressionResult constructBuiltinFesetround(ILocation var1, ExpressionResult var2, AuxVarInfoBuilder var3);

    public abstract Expression applyWraparound(ILocation var1, CPrimitive var2, Expression var3);

    public abstract Pair<Expression, Expression> constructOverflowCheckForArithmeticExpression(ILocation var1, int var2, CPrimitive var3, Expression var4, Expression var5);

    public abstract Pair<Expression, Expression> constructOverflowCheckForUnaryExpression(ILocation var1, int var2, CPrimitive var3, Expression var4);

    public abstract Pair<Expression, ASTType> constructInfinitePrecisionOperation(ILocation var1, int var2, Expression var3, Expression var4, CPrimitive var5);

    public abstract Expression checkInRangeInfinitePrecision(ILocation var1, Expression var2, ASTType var3, CPrimitive var4);

    public abstract Expression convertInfinitePrecisionExpression(ILocation var1, Expression var2, CPrimitive var3);

    public static Statement modelUnsupportedFeature(ILocation iLocation, String string) {
        AssertStatement assertStatement = new AssertStatement(iLocation, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)false));
        new Overapprox(string, iLocation).annotate((IElement)assertStatement);
        new Check(Spec.UNSUPPORTED_FEATURE).annotate((IElement)assertStatement);
        return new WhileStatement(iLocation, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)true), new LoopInvariantSpecification[0], new Statement[]{assertStatement});
    }

    public abstract IFloatingPointHandler getFloatingPointHandler();
}

