/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomatonFilteredStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.boogie.annotation.LTLPropertyCheck;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.FixpointNonTerminationResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GeometricNonTerminationArgumentResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.LTLInfiniteCounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.LassoShapedNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.core.lib.results.NonTerminationArgumentResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.NonterminatingLassoResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TerminationAnalysisResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lassoranker.BacktranslationUtil;
import de.uni_freiburg.informatik.ultimate.lassoranker.NonterminationArgumentStatistics;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.InfiniteFixpointRepetition;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.InfiniteFixpointRepetitionWithExecution;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgPetrifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiAutomizerTimingBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiCegarLoopBenchmarkGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar.BuchiCegarLoopFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar.BuchiCegarLoopResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IWitnessTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking.WitnessModelToAutomatonTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking.WitnessUtils;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomataTestFileAST;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BuchiAutomizerObserver
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final List<IIcfg<?>> mIcfgs;
    private IElement mRootOfNewModel;
    private IWitnessTransformer<IcfgEdge> mWitnessTransformer;
    private final List<AutomataTestFileAST> mAutomataTestFileAsts;
    private boolean mLastModel;
    private ModelType mCurrentGraphType;

    public BuchiAutomizerObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mLastModel = false;
        this.mIcfgs = new ArrayList();
        this.mAutomataTestFileAsts = new ArrayList<AutomataTestFileAST>();
    }

    public boolean process(IElement iElement) throws IOException {
        if (iElement instanceof IIcfg) {
            this.mIcfgs.add((IIcfg)iElement);
        }
        if (iElement instanceof WitnessNode && this.mCurrentGraphType.getType() == ModelType.Type.VIOLATION_WITNESS) {
            if (this.mWitnessTransformer != null) {
                throw new UnsupportedOperationException("two witness models");
            }
            this.mLogger.warn((Object)"Found a witness automaton. I will only consider traces that are accepted by the witness automaton");
            INestedWordAutomaton iNestedWordAutomaton = new WitnessModelToAutomatonTransformer((WitnessNode)iElement, this.mServices).getResult();
            this.mWitnessTransformer = (iNwaOutgoingLetterAndTransitionProvider, predicateFactory) -> WitnessUtils.constructGraphMLWitnessProduct((IUltimateServiceProvider)this.mServices, (INwaOutgoingLetterAndTransitionProvider)iNwaOutgoingLetterAndTransitionProvider, this.extendWitnessAutomaton((INwaOutgoingLetterAndTransitionProvider<WitnessEdge, WitnessNode>)iNestedWordAutomaton), (PredicateFactory)predicateFactory, (ILogger)this.mLogger, (WitnessUtils.Property)WitnessUtils.Property.TERMINATION);
        }
        if (iElement instanceof AutomataTestFileAST) {
            this.mAutomataTestFileAsts.add((AutomataTestFileAST)iElement);
        }
        return false;
    }

    private BuchiCegarLoopResult<IcfgEdge> runCegarLoops(IIcfg<?> iIcfg, BuchiCegarLoopFactory<IcfgEdge> buchiCegarLoopFactory) throws IOException {
        if (!IcfgUtils.isConcurrent(iIcfg)) {
            return buchiCegarLoopFactory.constructCegarLoop(iIcfg, this.mWitnessTransformer).runCegarLoop();
        }
        if (this.mWitnessTransformer != null) {
            throw new UnsupportedOperationException("Witness validation for concurrency is currently not supported.");
        }
        int n = 1;
        while (true) {
            IcfgPetrifier icfgPetrifier = new IcfgPetrifier(this.mServices, iIcfg, n, true);
            this.mServices.getBacktranslationService().addTranslator(icfgPetrifier.getBacktranslator());
            IIcfg iIcfg2 = icfgPetrifier.getPetrifiedIcfg();
            BuchiCegarLoopResult<IcfgEdge> buchiCegarLoopResult = buchiCegarLoopFactory.constructCegarLoop(iIcfg2, null).runCegarLoop();
            if (buchiCegarLoopResult.getResult() != BuchiCegarLoopResult.Result.INSUFFICIENT_THREADS) {
                return buchiCegarLoopResult;
            }
            this.mLogger.warn((Object)(n + " thread instances were not sufficient, I will increase this number and restart the analysis"));
            ++n;
        }
    }

    private INestedWordAutomaton<WitnessEdge, WitnessNode> extendWitnessAutomaton(INwaOutgoingLetterAndTransitionProvider<WitnessEdge, WitnessNode> iNwaOutgoingLetterAndTransitionProvider) {
        AutomataLibraryServices automataLibraryServices = new AutomataLibraryServices(this.mServices);
        NestedWordAutomatonReachableStates nestedWordAutomatonReachableStates = null;
        try {
            nestedWordAutomatonReachableStates = new NestedWordAutomatonReachableStates(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider);
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "extending witness automaton");
            automataOperationCanceledException.addRunningTaskInfo(runningTaskInfo);
            throw new ToolchainExceptionWrapper(Activator.PLUGIN_ID, (Throwable)automataOperationCanceledException);
        }
        return new NestedWordAutomatonFilteredStates(automataLibraryServices, nestedWordAutomatonReachableStates, nestedWordAutomatonReachableStates.getStates(), nestedWordAutomatonReachableStates.getInitialStates(), nestedWordAutomatonReachableStates.getStates());
    }

    private IIcfg<?> doTerminationAnalysis(IIcfg<?> iIcfg) throws IOException, AssertionError {
        BuchiAutomizerTimingBenchmark buchiAutomizerTimingBenchmark;
        BuchiCegarLoopBenchmarkGenerator buchiCegarLoopBenchmarkGenerator = new BuchiCegarLoopBenchmarkGenerator();
        BuchiCegarLoopResult<IcfgEdge> buchiCegarLoopResult = this.runCegarLoops(iIcfg, new BuchiCegarLoopFactory<IcfgEdge>(this.mServices, new TAPreferences(this.mServices), IcfgEdge.class, buchiCegarLoopBenchmarkGenerator));
        buchiCegarLoopBenchmarkGenerator.stop(CegarLoopStatisticsDefinitions.OverallTime);
        StatisticsResult statisticsResult = new StatisticsResult(Activator.PLUGIN_ID, "Constructed decomposition of program", (ICsvProviderProvider)buchiCegarLoopResult.getMDBenchmark());
        this.reportResult((IResult)statisticsResult);
        boolean bl = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Construct termination proof for TermComp");
        if (bl) {
            buchiAutomizerTimingBenchmark = new StatisticsResult(Activator.PLUGIN_ID, "Constructed termination proof in form of nested word automata", (ICsvProviderProvider)buchiCegarLoopResult.getTermcompProofBenchmark());
            this.reportResult((IResult)buchiAutomizerTimingBenchmark);
        }
        buchiAutomizerTimingBenchmark = new BuchiAutomizerTimingBenchmark(buchiCegarLoopBenchmarkGenerator);
        StatisticsResult statisticsResult2 = new StatisticsResult(Activator.PLUGIN_ID, "Timing statistics", (ICsvProviderProvider)buchiAutomizerTimingBenchmark);
        this.reportResult((IResult)statisticsResult2);
        this.interpretAndReportResult(buchiCegarLoopResult, iIcfg);
        return iIcfg;
    }

    private NonTerminationArgumentResult<IcfgEdge, Term> getNonTerminationResult(NonTerminationArgument nonTerminationArgument, IcfgProgramExecution<IcfgEdge> icfgProgramExecution, IcfgProgramExecution<IcfgEdge> icfgProgramExecution2, IcfgEdge icfgEdge) {
        if (nonTerminationArgument instanceof GeometricNonTerminationArgument) {
            GeometricNonTerminationArgument geometricNonTerminationArgument = (GeometricNonTerminationArgument)nonTerminationArgument;
            ArrayList<Map> arrayList = new ArrayList<Map>();
            arrayList.add(geometricNonTerminationArgument.getStateInit());
            arrayList.add(geometricNonTerminationArgument.getStateHonda());
            arrayList.addAll(geometricNonTerminationArgument.getGEVs());
            List list = BacktranslationUtil.rank2Rcfg(arrayList);
            return new GeometricNonTerminationArgumentResult((IElement)icfgEdge, "TraceAbstraction", (Map)list.get(0), (Map)list.get(1), list.subList(2, list.size()), geometricNonTerminationArgument.getLambdas(), geometricNonTerminationArgument.getNus(), this.mServices.getBacktranslationService(), Term.class, icfgProgramExecution, icfgProgramExecution2);
        }
        if (nonTerminationArgument instanceof InfiniteFixpointRepetitionWithExecution) {
            return new LassoShapedNonTerminationArgument((IElement)icfgEdge, "TraceAbstraction", this.mServices.getBacktranslationService(), Term.class, icfgProgramExecution, icfgProgramExecution2);
        }
        if (nonTerminationArgument instanceof InfiniteFixpointRepetition) {
            InfiniteFixpointRepetition infiniteFixpointRepetition = (InfiniteFixpointRepetition)nonTerminationArgument;
            return new FixpointNonTerminationResult((IElement)icfgEdge, "TraceAbstraction", infiniteFixpointRepetition.getValuesAtInit(), infiniteFixpointRepetition.getValuesAtHonda(), this.mServices.getBacktranslationService(), Term.class, icfgProgramExecution, icfgProgramExecution2);
        }
        throw new IllegalArgumentException("Unknown NonTerminationArgument " + String.valueOf(nonTerminationArgument.getClass()));
    }

    private void interpretAndReportResult(BuchiCegarLoopResult<IcfgEdge> buchiCegarLoopResult, IIcfg<?> iIcfg) throws AssertionError {
        LTLPropertyCheck lTLPropertyCheck = LTLPropertyCheck.getAnnotation(iIcfg);
        String string = lTLPropertyCheck != null ? lTLPropertyCheck.getUltimateLTLProperty() : "termination";
        switch (buchiCegarLoopResult.getResult()) {
            case NONTERMINATING: {
                this.reportNonTermination(buchiCegarLoopResult, lTLPropertyCheck);
                return;
            }
            case TERMINATING: {
                this.reportTermination(lTLPropertyCheck);
                return;
            }
            case TIMEOUT: {
                this.reportTimeout(buchiCegarLoopResult, string);
                return;
            }
            case UNKNOWN: {
                this.reportUnknown(buchiCegarLoopResult, string);
                return;
            }
        }
        throw new AssertionError((Object)("Extend the switch with the new enum member " + String.valueOf(buchiCegarLoopResult)));
    }

    private void reportTermination(LTLPropertyCheck lTLPropertyCheck) {
        if (lTLPropertyCheck == null) {
            this.reportResult((IResult)new TerminationAnalysisResult(Activator.PLUGIN_ID, TerminationAnalysisResult.Termination.TERMINATING, "Buchi Automizer proved that your program is terminating"));
        } else {
            this.reportResult((IResult)new AllSpecificationsHoldResult(Activator.PLUGIN_ID, "Buchi Automizer proved that the LTL property " + lTLPropertyCheck.getUltimateLTLProperty() + " holds"));
        }
    }

    private void reportNonTermination(BuchiCegarLoopResult<IcfgEdge> buchiCegarLoopResult, LTLPropertyCheck lTLPropertyCheck) {
        IcfgProgramExecution icfgProgramExecution = buchiCegarLoopResult.getStem().length() == 0 ? IcfgProgramExecution.create(IcfgEdge.class) : (buchiCegarLoopResult.getNonTerminationArgument() instanceof InfiniteFixpointRepetitionWithExecution ? (IcfgProgramExecution)((InfiniteFixpointRepetitionWithExecution)buchiCegarLoopResult.getNonTerminationArgument()).getStemExecution() : TraceCheckUtils.computeSomeIcfgProgramExecutionWithoutValues(buchiCegarLoopResult.getStem()));
        IcfgProgramExecution icfgProgramExecution2 = TraceCheckUtils.computeSomeIcfgProgramExecutionWithoutValues(buchiCegarLoopResult.getLoop());
        IcfgEdge icfgEdge = (IcfgEdge)buchiCegarLoopResult.getLoop().getSymbol(0);
        if (lTLPropertyCheck == null) {
            this.reportResult((IResult)new TerminationAnalysisResult(Activator.PLUGIN_ID, TerminationAnalysisResult.Termination.NONTERMINATING, "Buchi Automizer proved that your program is nonterminating for some inputs"));
            NonTerminationArgument nonTerminationArgument = buchiCegarLoopResult.getNonTerminationArgument();
            this.reportResult((IResult)this.getNonTerminationResult(nonTerminationArgument, (IcfgProgramExecution<IcfgEdge>)icfgProgramExecution, (IcfgProgramExecution<IcfgEdge>)icfgProgramExecution2, icfgEdge));
            this.reportResult((IResult)new StatisticsResult("TraceAbstraction", NonterminationArgumentStatistics.class.getSimpleName(), (ICsvProviderProvider)new NonterminationArgumentStatistics(nonTerminationArgument)));
            this.reportResult((IResult)new NonterminatingLassoResult((IElement)icfgEdge, Activator.PLUGIN_ID, this.mServices.getBacktranslationService(), (IProgramExecution)icfgProgramExecution, (IProgramExecution)icfgProgramExecution2));
        } else {
            this.reportResult((IResult)new LTLInfiniteCounterExampleResult((IElement)icfgEdge, Activator.PLUGIN_ID, this.mServices.getBacktranslationService(), (IProgramExecution)icfgProgramExecution, (IProgramExecution)icfgProgramExecution2, lTLPropertyCheck.getUltimateLTLProperty()));
        }
    }

    private void reportUnknown(BuchiCegarLoopResult<IcfgEdge> buchiCegarLoopResult, String string) {
        HashRelation<String, ILocation> hashRelation = buchiCegarLoopResult.getOverapproximations();
        StringBuilder stringBuilder = new StringBuilder();
        if (hashRelation.isEmpty()) {
            stringBuilder.append("Buchi Automizer is unable to decide " + string + " for the following lasso. ");
        } else {
            stringBuilder.append("Buchi Automizer cannot decide " + string + " for the following lasso because it contains the following overapproximations. ");
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            stringBuilder.append("Overapproximations");
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            for (Map.Entry entry : hashRelation) {
                stringBuilder.append(String.format("%s (Reason %s)", entry.getValue(), entry.getKey()));
            }
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            stringBuilder.append("Lasso");
        }
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("Stem: ");
        stringBuilder.append(buchiCegarLoopResult.getStem());
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("Loop: ");
        stringBuilder.append(buchiCegarLoopResult.getLoop());
        this.reportResult((IResult)new TerminationAnalysisResult(Activator.PLUGIN_ID, TerminationAnalysisResult.Termination.UNKNOWN, stringBuilder.toString()));
    }

    private void reportTimeout(BuchiCegarLoopResult<IcfgEdge> buchiCegarLoopResult, String string) {
        String string2 = "Buchi Automizer is unable to decide " + string + ": Timeout " + buchiCegarLoopResult.getToolchainCancelledException().printRunningTaskMessage();
        this.reportResult((IResult)new TimeoutResult(Activator.PLUGIN_ID, string2));
    }

    private void reportResult(IResult iResult) {
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, iResult);
    }

    public void finish() throws IOException {
        if (this.mLastModel) {
            IIcfg iIcfg3 = this.mIcfgs.stream().filter(iIcfg -> IcfgLocation.class.isAssignableFrom(iIcfg.getLocationClass())).reduce((iIcfg, iIcfg2) -> iIcfg2).orElseThrow(UnsupportedOperationException::new);
            if (iIcfg3 == null) {
                throw new UnsupportedOperationException("TraceAbstraction needs an RCFG");
            }
            this.mLogger.info((Object)("Analyzing ICFG " + iIcfg3.getIdentifier()));
            this.mRootOfNewModel = this.doTerminationAnalysis(iIcfg3);
        }
    }

    public void init(ModelType modelType, int n, int n2) {
        this.mCurrentGraphType = modelType;
        if (n == n2 - 1) {
            this.mLastModel = true;
        }
    }

    public boolean performedChanges() {
        return false;
    }

    public IElement getModel() {
        return this.mRootOfNewModel;
    }
}

