/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class RotPosPathInterpolator
extends PathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Vector3f pos = new Vector3f();
    private Quat4f tQuat = new Quat4f();
    private Matrix4d tMat = new Matrix4d();
    private Quat4f[] quats;
    private Point3f[] positions;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotPosPathInterpolator() {
    }

    public RotPosPathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray, Quat4f[] quat4fArray, Point3f[] point3fArray) {
        super(alpha, transformGroup, transform3D, fArray);
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosPathInterpolator0"));
        }
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosPathInterpolator0"));
        }
        this.setPathArrays(quat4fArray, point3fArray);
    }

    public void setQuat(int n, Quat4f quat4f) {
        this.quats[n].set(quat4f);
    }

    public void getQuat(int n, Quat4f quat4f) {
        quat4f.set(this.quats[n]);
    }

    public void setPosition(int n, Point3f point3f) {
        this.positions[n].set(point3f);
    }

    public void getPosition(int n, Point3f point3f) {
        point3f.set(this.positions[n]);
    }

    public void setPathArrays(float[] fArray, Quat4f[] quat4fArray, Point3f[] point3fArray) {
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosPathInterpolator0"));
        }
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotPosPathInterpolator0"));
        }
        this.setKnots(fArray);
        this.setPathArrays(quat4fArray, point3fArray);
    }

    private void setPathArrays(Quat4f[] quat4fArray, Point3f[] point3fArray) {
        this.quats = new Quat4f[quat4fArray.length];
        int n = 0;
        while (n < quat4fArray.length) {
            this.quats[n] = new Quat4f();
            this.quats[n].set(quat4fArray[n]);
            ++n;
        }
        this.positions = new Point3f[point3fArray.length];
        int n2 = 0;
        while (n2 < point3fArray.length) {
            this.positions[n2] = new Point3f();
            this.positions[n2].set(point3fArray[n2]);
            ++n2;
        }
    }

    public void getQuats(Quat4f[] quat4fArray) {
        int n = 0;
        while (n < this.quats.length) {
            quat4fArray[n].set(this.quats[n]);
            ++n;
        }
    }

    public void getPositions(Point3f[] point3fArray) {
        int n = 0;
        while (n < this.positions.length) {
            point3fArray[n].set(this.positions[n]);
            ++n;
        }
    }

    public void setAxisOfRotPos(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfRotPos() {
        return this.getTransformAxis();
    }

    public void computeTransform(float f, Transform3D transform3D) {
        this.computePathInterpolation(f);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.tQuat.x = this.quats[0].x;
            this.tQuat.y = this.quats[0].y;
            this.tQuat.z = this.quats[0].z;
            this.tQuat.w = this.quats[0].w;
            this.pos.x = this.positions[0].x;
            this.pos.y = this.positions[0].y;
            this.pos.z = this.positions[0].z;
        } else {
            double d = this.quats[this.currentKnotIndex].x * this.quats[this.currentKnotIndex + 1].x + this.quats[this.currentKnotIndex].y * this.quats[this.currentKnotIndex + 1].y + this.quats[this.currentKnotIndex].z * this.quats[this.currentKnotIndex + 1].z + this.quats[this.currentKnotIndex].w * this.quats[this.currentKnotIndex + 1].w;
            if (d < 0.0) {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (-this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (-this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (-this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (-this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            } else {
                this.tQuat.x = this.quats[this.currentKnotIndex].x + (this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                this.tQuat.y = this.quats[this.currentKnotIndex].y + (this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                this.tQuat.z = this.quats[this.currentKnotIndex].z + (this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                this.tQuat.w = this.quats[this.currentKnotIndex].w + (this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
            }
            this.pos.x = this.positions[this.currentKnotIndex].x + (this.positions[this.currentKnotIndex + 1].x - this.positions[this.currentKnotIndex].x) * this.currentInterpolationValue;
            this.pos.y = this.positions[this.currentKnotIndex].y + (this.positions[this.currentKnotIndex + 1].y - this.positions[this.currentKnotIndex].y) * this.currentInterpolationValue;
            this.pos.z = this.positions[this.currentKnotIndex].z + (this.positions[this.currentKnotIndex + 1].z - this.positions[this.currentKnotIndex].z) * this.currentInterpolationValue;
        }
        this.tQuat.normalize();
        this.tMat.set(this.tQuat);
        this.tMat.m03 = this.pos.x;
        this.tMat.m13 = this.pos.y;
        this.tMat.m23 = this.pos.z;
        this.rotation.set(this.tMat);
        transform3D.mul(this.axis, this.rotation);
        transform3D.mul(transform3D, this.axisInverse);
    }

    public Node cloneNode(boolean bl) {
        RotPosPathInterpolator rotPosPathInterpolator = new RotPosPathInterpolator();
        rotPosPathInterpolator.duplicateNode(this, bl);
        return rotPosPathInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        RotPosPathInterpolator rotPosPathInterpolator = (RotPosPathInterpolator)node;
        int n = rotPosPathInterpolator.getArrayLengths();
        this.positions = new Point3f[n];
        this.quats = new Quat4f[n];
        Point3f point3f = new Point3f();
        Quat4f quat4f = new Quat4f();
        int n2 = 0;
        while (n2 < n) {
            this.positions[n2] = new Point3f();
            rotPosPathInterpolator.getPosition(n2, point3f);
            this.setPosition(n2, point3f);
            this.quats[n2] = new Quat4f();
            rotPosPathInterpolator.getQuat(n2, quat4f);
            this.setQuat(n2, quat4f);
            ++n2;
        }
    }
}

