/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetSuccessorProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ConditionEventsCoRelation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ConditionEventsCoRelationB32;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ConfigurationOrder;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ICoRelation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.BranchingProcessToUltimateModel;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class BranchingProcess<LETTER, PLACE>
implements IAutomaton<LETTER, PLACE> {
    private static final boolean ADD_CUTOFF_EVENTS_TO_CORELATION = true;
    private final AutomataLibraryServices mServices;
    private final Collection<Condition<LETTER, PLACE>> mConditions;
    private final Collection<Event<LETTER, PLACE>> mEvents;
    private final ICoRelation<LETTER, PLACE> mCoRelation;
    private final HashRelation<PLACE, Condition<LETTER, PLACE>> mPlace2Conds;
    private final Event<LETTER, PLACE> mDummyRoot;
    private final IPetriNetSuccessorProvider<LETTER, PLACE> mNet;
    private final HashRelation<PLACE, Transition<LETTER, PLACE>> mYetKnownPredecessorTransitions = new HashRelation();
    private final ConfigurationOrder<LETTER, PLACE> mOrder;
    private int mConditionSerialnumberCounter;
    private final HashRelation<Integer, Event<LETTER, PLACE>> mMarkingNonCutoffEventRelation = new HashRelation();
    private final boolean mNewFiniteComprehensivePrefixMode = false;
    private final boolean mUseFirstbornCutoffCheck;
    public Set<Event<LETTER, PLACE>> mCutoffEvents = new HashSet<Event<LETTER, PLACE>>();

    public BranchingProcess(AutomataLibraryServices automataLibraryServices, IPetriNetSuccessorProvider<LETTER, PLACE> iPetriNetSuccessorProvider, ConfigurationOrder<LETTER, PLACE> configurationOrder, boolean bl, boolean bl2) throws PetriNetNot1SafeException {
        this.mServices = automataLibraryServices;
        this.mNet = iPetriNetSuccessorProvider;
        this.mOrder = configurationOrder;
        this.mPlace2Conds = new HashRelation();
        this.mConditions = new HashSet<Condition<LETTER, PLACE>>();
        this.mEvents = new HashSet<Event<LETTER, PLACE>>();
        this.mCoRelation = bl2 ? new ConditionEventsCoRelationB32(this) : new ConditionEventsCoRelation(this);
        this.mUseFirstbornCutoffCheck = bl;
        this.mDummyRoot = new Event(this);
        this.addEvent(this.mDummyRoot);
    }

    public Event<LETTER, PLACE> getDummyRoot() {
        return this.mDummyRoot;
    }

    public Condition<LETTER, PLACE> constructCondition(Event<LETTER, PLACE> event, PLACE PLACE) {
        return new Condition<LETTER, PLACE>(event, PLACE, this.mConditionSerialnumberCounter++);
    }

    boolean addEvent(Event<LETTER, PLACE> event) throws PetriNetNot1SafeException {
        if (event != this.getDummyRoot()) {
            for (Condition<LETTER, PLACE> condition : event.getSuccessorConditions()) {
                this.mYetKnownPredecessorTransitions.addPair(condition.getPlace(), event.getTransition());
            }
        }
        if (event.isCutoffEvent()) {
            this.mCutoffEvents.add(event);
        }
        event.setSerialNumber(this.mEvents.size());
        this.mEvents.add(event);
        if (!this.mUseFirstbornCutoffCheck && !event.isCutoffEvent()) {
            this.mMarkingNonCutoffEventRelation.addPair((Object)event.getMark().hashCode(), event);
        }
        for (Condition<LETTER, PLACE> condition : event.getPredecessorConditions()) {
            assert (!condition.getPredecessorEvent().isCutoffEvent()) : "Cut-off events must not have successors.";
            condition.addSuccesssor(event);
        }
        boolean bl = false;
        for (Condition<LETTER, PLACE> condition : event.getSuccessorConditions()) {
            this.mConditions.add(condition);
            this.mPlace2Conds.addPair(condition.getPlace(), condition);
            if (!this.mNet.isAccepting(condition.getPlace())) continue;
            bl = true;
        }
        this.mCoRelation.update(event);
        return bl;
    }

    public boolean isCutoffEvent(Event<LETTER, PLACE> event, Comparator<Event<LETTER, PLACE>> comparator, boolean bl) {
        for (Event event2 : this.mMarkingNonCutoffEventRelation.getImage((Object)event.getMark().hashCode())) {
            if (!event.checkCutOffAndSetCompanion(event2, comparator, bl)) continue;
            return true;
        }
        return false;
    }

    public Set<Event<LETTER, PLACE>> getCutoffEvents() {
        return this.mCutoffEvents;
    }

    public Set<Condition<LETTER, PLACE>> place2cond(PLACE PLACE) {
        return this.mPlace2Conds.getImage(PLACE);
    }

    public ICoRelation<LETTER, PLACE> getCoRelation() {
        return this.mCoRelation;
    }

    public Collection<Condition<LETTER, PLACE>> getConditions() {
        return this.mConditions;
    }

    public Collection<Event<LETTER, PLACE>> getEvents() {
        return this.mEvents;
    }

    public Set<Condition<LETTER, PLACE>> getConditions(PLACE PLACE) {
        return Collections.unmodifiableSet(this.mPlace2Conds.getImage(PLACE));
    }

    public Collection<Condition<LETTER, PLACE>> initialConditions() {
        return this.mDummyRoot.getSuccessorConditions();
    }

    public Collection<Event<LETTER, PLACE>> minEvents() {
        HashSet<Event<LETTER, PLACE>> hashSet = new HashSet<Event<LETTER, PLACE>>();
        for (Condition<LETTER, PLACE> condition : this.initialConditions()) {
            hashSet.addAll(condition.getSuccessorEvents());
        }
        HashSet<Event<LETTER, PLACE>> hashSet2 = new HashSet<Event<LETTER, PLACE>>();
        for (Event event : hashSet) {
            if (!this.initialConditions().containsAll(event.getPredecessorConditions())) continue;
            hashSet2.add(event);
        }
        return hashSet2;
    }

    public IPetriNetSuccessorProvider<LETTER, PLACE> getNet() {
        return this.mNet;
    }

    public boolean inCausalRelation(Condition<LETTER, PLACE> condition, Condition<LETTER, PLACE> condition2) {
        if (condition == condition2) {
            return false;
        }
        Set<Object> set = this.ancestorNodes(condition);
        if (set.contains(condition2)) {
            return true;
        }
        Set<Object> set2 = this.ancestorNodes(condition2);
        return set2.contains(condition);
    }

    public boolean inCausalRelation(Condition<LETTER, PLACE> condition, Event<LETTER, PLACE> event) {
        Set<Object> set = this.ancestorNodes(condition);
        if (set.contains(event)) {
            return true;
        }
        Set<Object> set2 = this.ancestorNodes(event);
        return set2.contains(condition);
    }

    public boolean inConflict(Condition<LETTER, PLACE> condition, Condition<LETTER, PLACE> condition2) {
        if (condition == condition2) {
            return false;
        }
        Set<Object> set = this.ancestorNodes(condition2);
        return this.conflictPathCheck(condition, condition2, set);
    }

    private boolean conflictPathCheck(Condition<LETTER, PLACE> condition, Condition<LETTER, PLACE> condition2, Set<Object> set) {
        ArrayDeque arrayDeque = new ArrayDeque();
        HashSet<Condition> hashSet = new HashSet<Condition>();
        arrayDeque.add(condition);
        while (!arrayDeque.isEmpty()) {
            Condition condition3 = (Condition)arrayDeque.pop();
            if (hashSet.contains(condition3)) continue;
            hashSet.add(condition3);
            if (condition3 == condition2) {
                throw new IllegalArgumentException(String.valueOf(condition3) + " ancestor of " + String.valueOf(condition2));
            }
            if (set.contains(condition3)) {
                return true;
            }
            Event event = condition3.getPredecessorEvent();
            if (set.contains(event) || event == this.mDummyRoot) continue;
            arrayDeque.addAll(event.getPredecessorConditions());
        }
        return false;
    }

    private Set<Object> ancestorNodes(Condition<LETTER, PLACE> condition) {
        Event<LETTER, PLACE> event = condition.getPredecessorEvent();
        if (event.equals(this.mDummyRoot)) {
            return Collections.emptySet();
        }
        return this.ancestorNodes(event);
    }

    private Set<Object> ancestorNodes(Event<LETTER, PLACE> event) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Event<LETTER, PLACE> event2 : event.getLocalConfiguration()) {
            hashSet.add(event2);
            hashSet.addAll(event2.getPredecessorConditions());
        }
        return hashSet;
    }

    public boolean pairwiseConflictOrCausalRelation(Collection<Condition<LETTER, PLACE>> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("method only defined for non-empty set of conditions");
        }
        boolean bl = true;
        for (Condition<LETTER, PLACE> condition : collection) {
            for (Condition<LETTER, PLACE> condition2 : collection) {
                if (this.inCausalRelation(condition, condition2) || this.inConflict(condition, condition2)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean getNewFiniteComprehensivePrefixMode() {
        return false;
    }

    public Set<PLACE> computeCoRelatedPlaces(Condition<LETTER, PLACE> condition) {
        HashSet<PLACE> hashSet = new HashSet<PLACE>();
        for (Condition<LETTER, PLACE> condition2 : this.mCoRelation.computeCoRelatatedConditions(condition)) {
            hashSet.add(condition2.getPlace());
        }
        return hashSet;
    }

    public Set<Transition<LETTER, PLACE>> computeVitalTransitions() {
        Object object2;
        Condition<LETTER, PLACE> condition22;
        HashRelation hashRelation = new HashRelation();
        for (Event<LETTER, PLACE> serializable2 : this.getEvents()) {
            if (!serializable2.isCutoffEvent()) continue;
            hashRelation.addPair(serializable2.getCompanion(), serializable2);
        }
        HashSet<Condition<LETTER, PLACE>> hashSet = new HashSet<Condition<LETTER, PLACE>>();
        for (Condition<LETTER, PLACE> condition22 : this.getConditions()) {
            if (!this.mNet.isAccepting(condition22.getPlace())) continue;
            hashSet.add(condition22);
        }
        condition22 = new HashSet();
        ArrayDeque arrayDeque = new ArrayDeque();
        for (Object object2 : hashSet) {
            Event event2 = ((Condition)object2).getPredecessorEvent();
            if (condition22.contains(event2)) continue;
            condition22.add(event2);
            arrayDeque.add(event2);
        }
        this.computeAncestors((HashRelation<Event<LETTER, PLACE>, Event<LETTER, PLACE>>)hashRelation, (Set<Event<LETTER, PLACE>>)((Object)condition22), arrayDeque);
        for (Object object2 : hashSet) {
            for (Event event2 : this.mCoRelation.computeCoRelatatedEvents((Condition<LETTER, PLACE>)object2)) {
                if (condition22.contains(event2)) continue;
                condition22.add(event2);
                arrayDeque.add(event2);
            }
        }
        this.computeAncestors((HashRelation<Event<LETTER, PLACE>, Event<LETTER, PLACE>>)hashRelation, (Set<Event<LETTER, PLACE>>)((Object)condition22), arrayDeque);
        object2 = condition22.stream().filter(event -> event != this.mDummyRoot).map(Event::getTransition).collect(Collectors.toSet());
        return object2;
    }

    private void computeAncestors(HashRelation<Event<LETTER, PLACE>, Event<LETTER, PLACE>> hashRelation, Set<Event<LETTER, PLACE>> set, ArrayDeque<Event<LETTER, PLACE>> arrayDeque) {
        while (!arrayDeque.isEmpty()) {
            Event<LETTER, PLACE> event = arrayDeque.remove();
            for (Serializable serializable : event.getPredecessorConditions()) {
                Event<LETTER, PLACE> event2 = serializable.getPredecessorEvent();
                if (set.contains(event2)) continue;
                set.add(event2);
                arrayDeque.add(event2);
            }
            for (Serializable serializable : hashRelation.getImage(event)) {
                if (!set.contains(serializable)) {
                    set.add((Event<LETTER, PLACE>)serializable);
                    arrayDeque.add((Event<LETTER, PLACE>)serializable);
                }
                for (Event<LETTER, PLACE> event2 : this.mCoRelation.computeCoRelatatedEvents((Event<LETTER, PLACE>)serializable)) {
                    if (set.contains(event2)) continue;
                    set.add(event2);
                    arrayDeque.add(event2);
                }
            }
        }
    }

    @Override
    public String sizeInformation() {
        return "has " + this.mConditions.size() + " conditions, " + (this.mEvents.size() - 1) + " events";
    }

    public ConfigurationOrder<LETTER, PLACE> getOrder() {
        return this.mOrder;
    }

    @Override
    public int size() {
        return this.mConditions.size();
    }

    public int computeConditionPerPlaceMax() {
        int n = this.mPlace2Conds.getDomain().stream().map(object -> this.mPlace2Conds.getImage(object).size()).max(Integer::compare).orElse(0);
        return n;
    }

    public HashRelation<PLACE, Transition<LETTER, PLACE>> getYetKnownPredecessorTransitions() {
        return this.mYetKnownPredecessorTransitions;
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mNet.getAlphabet();
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        return new BranchingProcessToUltimateModel().transformToUltimateModel(this);
    }

    public String toString() {
        return AutomatonDefinitionPrinter.toString(this.mServices, "branchingProcess", this);
    }

    public Collection<Condition<LETTER, PLACE>> getAcceptingConditions() {
        return this.mConditions.stream().filter(condition -> this.mNet.isAccepting(condition.getPlace())).collect(Collectors.toSet());
    }
}

