/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser.yaml;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Location {
    private final String mFileName;
    private final Integer mLine;
    private final Integer mColumn;
    private final String mFunction;

    public Location(String string, Integer n, Integer n2, String string2) {
        this.mFileName = string;
        this.mLine = n;
        this.mColumn = n2;
        this.mFunction = string2;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public Integer getLine() {
        return this.mLine;
    }

    public Integer getColumn() {
        return this.mColumn;
    }

    public String getFunction() {
        return this.mFunction;
    }

    public String toString() {
        return "(L" + String.valueOf(this.mLine) + "-" + String.valueOf(this.mColumn) + ")";
    }

    public int hashCode() {
        return Objects.hash(this.mColumn, this.mFileName, this.mFunction, this.mLine);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Location location = (Location)object;
        return Objects.equals(this.mColumn, location.mColumn) && Objects.equals(this.mFileName, location.mFileName) && Objects.equals(this.mFunction, location.mFunction) && Objects.equals(this.mLine, location.mLine);
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("file_name", this.mFileName);
        linkedHashMap.put("line", this.mLine);
        if (this.mColumn != null) {
            linkedHashMap.put("column", this.mColumn);
        }
        if (this.mFunction != null) {
            linkedHashMap.put("function", this.mFunction);
        }
        return linkedHashMap;
    }
}

