/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Dnf;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.livevariable.LiveVariableState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.AbstractInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.InvariantSynthesisSettings;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.LargeBlockEncodingIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.NonInductiveAnnotationGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractLinearInvariantPattern;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AllProgramVariablesStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.DangerInvariantPatternStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.DefaultTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.DynamicPatternSettingsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.IInvariantPatternProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.IInvariantPatternProcessorFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.ILinearInequalityInvariantPatternStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.InvariantSynthesisStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.KindOfInvariant;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LinearInequalityInvariantPatternProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LinearInequalityInvariantPatternProcessorFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LiveVariablesStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.SuccessorConstraintIngredients;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class CFGInvariantsGenerator {
    private static final boolean USE_UNSAT_CORES_FOR_DYNAMIC_PATTERN_CHANGES = true;
    private static final boolean USE_DYNAMIC_PATTERN_WITH_BOUNDS = false;
    private static final boolean USE_DYNAMIC_PATTERN_CHANGES_WITH_GLOBAL_TEMPLATE_LEVEL = false;
    private static final boolean USE_UNDER_APPROX_FOR_MAX_CONJUNCTS = false;
    private static final boolean USE_OVER_APPROX_FOR_MIN_DISJUNCTS = false;
    private static final boolean ALWAYS_STRICT_AND_NON_STRICT_COPIES = false;
    private static final boolean USE_STRICT_INEQUALITIES_ALTERNATINGLY = false;
    private static final int MAX_ROUNDS = 10;
    private static final boolean USE_LIVE_VARIABLES = true;
    private static final boolean TEMPLATE_STATISTICS_MODE = true;
    private static boolean INIT_USE_EMPTY_PATTERNS = true;
    private static boolean USE_VARS_FROM_UNSAT_CORE_FOR_EACH_LOC = true;
    private final boolean mApplyLargeBlockEncoding;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final PredicateFactory mPredicateFactory;
    private final IPredicateUnifier mPredicateUnifier;
    private final IPredicate mPredicateOfInitialLocations;
    private final IPredicate mPredicateOfErrorLocations;
    private final IIcfg<IcfgLocation> mIcfg;
    private final InvariantSynthesisStatisticsGenerator mPathInvariantsStatistics;
    private final Map<Integer, InvariantSynthesisStatisticsGenerator> mRound2InvariantSynthesisStatistics;
    private final InvariantSynthesisSettings mInvariantSynthesisSettings;
    private final CfgSmtToolkit mCsToolKit;
    private final KindOfInvariant mKindOfInvariant;

    public CFGInvariantsGenerator(IIcfg<IcfgLocation> iIcfg, IUltimateServiceProvider iUltimateServiceProvider, IPredicate iPredicate, IPredicate iPredicate2, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, InvariantSynthesisSettings invariantSynthesisSettings, CfgSmtToolkit cfgSmtToolkit, KindOfInvariant kindOfInvariant) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mCsToolKit = cfgSmtToolkit;
        this.mKindOfInvariant = kindOfInvariant;
        this.mPredicateFactory = predicateFactory;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mPredicateOfInitialLocations = iPredicate;
        this.mPredicateOfErrorLocations = iPredicate2;
        if (!IcfgUtils.areReachableProgramPointsRegistered(iIcfg)) {
            throw new IllegalArgumentException("ICFGs that have unreachable program points are not supported");
        }
        this.mIcfg = iIcfg;
        this.mInvariantSynthesisSettings = invariantSynthesisSettings;
        this.mApplyLargeBlockEncoding = this.mInvariantSynthesisSettings.useLargeBlockEncoding();
        this.mPathInvariantsStatistics = new InvariantSynthesisStatisticsGenerator();
        this.mPathInvariantsStatistics.initializeStatistics();
        this.mRound2InvariantSynthesisStatistics = new HashMap<Integer, InvariantSynthesisStatisticsGenerator>();
    }

    private static IInvariantPatternProcessorFactory<?> createDefaultFactory(IUltimateServiceProvider iUltimateServiceProvider, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, boolean bl, boolean bl2, SolverBuilder.SolverSettings solverSettings, SmtUtils.SimplificationTechnique simplificationTechnique, ILinearInequalityInvariantPatternStrategy<Dnf<AbstractLinearInvariantPattern>> iLinearInequalityInvariantPatternStrategy, Map<IcfgLocation, IPredicate> map, Map<IcfgLocation, IPredicate> map2, boolean bl3, KindOfInvariant kindOfInvariant) {
        return new LinearInequalityInvariantPatternProcessorFactory(iUltimateServiceProvider, iPredicateUnifier, cfgSmtToolkit, iLinearInequalityInvariantPatternStrategy, bl, bl2, solverSettings, simplificationTechnique, cfgSmtToolkit.getSmtFunctionsAndAxioms(), map, map2, bl3, kindOfInvariant);
    }

    private static ILinearInequalityInvariantPatternStrategy<Dnf<AbstractLinearInvariantPattern>> getStrategy(boolean bl, boolean bl2, Set<IProgramVar> set, Map<IcfgLocation, Set<IProgramVar>> map, AbstractTemplateIncreasingDimensionsStrategy abstractTemplateIncreasingDimensionsStrategy, KindOfInvariant kindOfInvariant) {
        if (kindOfInvariant == KindOfInvariant.DANGER) {
            return new DangerInvariantPatternStrategy(abstractTemplateIncreasingDimensionsStrategy, 10, set, set, false, false);
        }
        assert (kindOfInvariant == KindOfInvariant.SAFETY);
        if (bl) {
            return new DynamicPatternSettingsStrategy(abstractTemplateIncreasingDimensionsStrategy, 10, set, map, false, false);
        }
        if (bl2) {
            return new LiveVariablesStrategy(abstractTemplateIncreasingDimensionsStrategy, 10, set, map, false, false);
        }
        return new AllProgramVariablesStrategy(abstractTemplateIncreasingDimensionsStrategy, 10, set, set, false, false);
    }

    private Map<IcfgLocation, IPredicate> generateInvariantsForPathProgram(IIcfg<IcfgLocation> iIcfg, SmtUtils.SimplificationTechnique simplificationTechnique, CfgSmtToolkit cfgSmtToolkit, InvariantSynthesisSettings invariantSynthesisSettings) {
        Object object;
        Object object2;
        boolean bl;
        IcfgLocation icfgLocation = (IcfgLocation)new ArrayList(iIcfg.getInitialNodes()).get(0);
        Set set = IcfgUtils.getErrorLocations(iIcfg);
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        ArrayList<IcfgInternalTransition> arrayList2 = new ArrayList<IcfgInternalTransition>();
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        CFGInvariantsGenerator.extractLocationsTransitionsAndVariablesFromPathProgram(iIcfg, arrayList, arrayList2, hashSet);
        this.mLogger.info((Object)("Built projected CFG, " + arrayList.size() + " states and " + arrayList2.size() + " transitions."));
        Map<IcfgLocation, Set<IProgramVar>> map = null;
        boolean bl2 = bl = this.mKindOfInvariant != KindOfInvariant.DANGER;
        if (bl) {
            map = this.generateLiveVariables(iIcfg);
            map.put(icfgLocation, new HashSet());
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Live variables computed: " + String.valueOf(map)));
            }
        }
        Map<IcfgLocation, IPredicate> map2 = null;
        Map<IcfgLocation, IPredicate> map3 = null;
        if (invariantSynthesisSettings.useUnsatCores()) {
            object2 = new NonInductiveAnnotationGenerator(this.mServices, this.mPredicateUnifier.getPredicateFactory(), iIcfg, NonInductiveAnnotationGenerator.Approximation.UNDERAPPROXIMATION);
            map2 = CFGInvariantsGenerator.convertHashRelation(((NonInductiveAnnotationGenerator)object2).getResult(), cfgSmtToolkit.getManagedScript());
        }
        if (invariantSynthesisSettings.useUnsatCores() || invariantSynthesisSettings.useWeakestPrecondition()) {
            object2 = new NonInductiveAnnotationGenerator(this.mServices, this.mPredicateUnifier.getPredicateFactory(), iIcfg, NonInductiveAnnotationGenerator.Approximation.OVERAPPROXIMATION);
            map3 = CFGInvariantsGenerator.convertHashRelation(((NonInductiveAnnotationGenerator)object2).getResult(), cfgSmtToolkit.getManagedScript());
        }
        object2 = new HashMap();
        if (invariantSynthesisSettings.useWeakestPrecondition()) {
            object2.putAll(map3);
        }
        if (invariantSynthesisSettings.useAbstractInterpretation()) {
            object = this.generatePredicatesViaAbstractInterpretation(iIcfg);
            object2.putAll(object);
        }
        if ((object = invariantSynthesisSettings.getTemplateDimensionsStrategy()) == null) {
            object = new DefaultTemplateIncreasingDimensionsStrategy(1, 1, 1, 1);
        }
        ILinearInequalityInvariantPatternStrategy<Dnf<AbstractLinearInvariantPattern>> iLinearInequalityInvariantPatternStrategy = CFGInvariantsGenerator.getStrategy(invariantSynthesisSettings.useUnsatCores(), bl, hashSet, map, (AbstractTemplateIncreasingDimensionsStrategy)object, this.mKindOfInvariant);
        boolean bl3 = this.mKindOfInvariant == KindOfInvariant.DANGER;
        IInvariantPatternProcessorFactory<?> iInvariantPatternProcessorFactory = CFGInvariantsGenerator.createDefaultFactory(this.mServices, this.mPredicateUnifier, cfgSmtToolkit, invariantSynthesisSettings.useNonLinearConstraints(), invariantSynthesisSettings.useUnsatCores(), invariantSynthesisSettings.getSolverSettings(), simplificationTechnique, iLinearInequalityInvariantPatternStrategy, map2, map3, bl3, this.mKindOfInvariant);
        Map<IcfgLocation, IPredicate> map4 = this.generateInvariantsForTransitions(arrayList, arrayList2, this.mPredicateOfInitialLocations, this.mPredicateOfErrorLocations, icfgLocation, set, iInvariantPatternProcessorFactory, invariantSynthesisSettings.useUnsatCores(), hashSet, map, CFGInvariantsGenerator.convertMapToPredsToMapToUnmodTrans((Map<IcfgLocation, IPredicate>)object2, cfgSmtToolkit.getManagedScript()), invariantSynthesisSettings.useWeakestPrecondition() || invariantSynthesisSettings.useAbstractInterpretation());
        return map4;
    }

    private Map<IcfgLocation, UnmodifiableTransFormula> extractAbstractInterpretationPredicates(IAbstractInterpretationResult<LiveVariableState<IcfgEdge>, IcfgEdge, IcfgLocation> iAbstractInterpretationResult, ManagedScript managedScript) {
        HashMap<IcfgLocation, UnmodifiableTransFormula> hashMap = new HashMap<IcfgLocation, UnmodifiableTransFormula>();
        Map map = iAbstractInterpretationResult.getLoc2Term();
        ArrayList arrayList = new ArrayList(iAbstractInterpretationResult.getTerms());
        if (arrayList.isEmpty() || arrayList.size() == 1 && "true".equals(((Term)arrayList.get(0)).toString())) {
            return hashMap;
        }
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put((IcfgLocation)entry.getKey(), TransFormulaBuilder.constructTransFormulaFromPredicate((IPredicate)this.mPredicateUnifier.getOrConstructPredicate((Term)entry.getValue()), (ManagedScript)managedScript));
        }
        return hashMap;
    }

    private static Map<IcfgLocation, IPredicate> convertHashRelation(HashRelation<IcfgLocation, IPredicate> hashRelation, ManagedScript managedScript) {
        HashMap<IcfgLocation, IPredicate> hashMap = new HashMap<IcfgLocation, IPredicate>(hashRelation.getDomain().size());
        for (IcfgLocation icfgLocation : hashRelation.getDomain()) {
            ArrayList arrayList = new ArrayList(hashRelation.getImage((Object)icfgLocation));
            hashMap.put(icfgLocation, (IPredicate)arrayList.get(0));
        }
        return hashMap;
    }

    private static void extractLocationsTransitionsAndVariablesFromPathProgram(IIcfg<IcfgLocation> iIcfg, List<IcfgLocation> list, List<IcfgInternalTransition> list2, Set<IProgramVar> set) {
        LinkedList<IcfgLocation> linkedList = new LinkedList<IcfgLocation>(iIcfg.getInitialNodes());
        LinkedHashSet<IcfgLocation> linkedHashSet = new LinkedHashSet<IcfgLocation>();
        LinkedList<IcfgInternalTransition> linkedList2 = new LinkedList<IcfgInternalTransition>();
        while (!linkedList.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)linkedList.removeFirst();
            if (!linkedHashSet.add(icfgLocation)) continue;
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                linkedList.addLast((IcfgLocation)icfgEdge.getTarget());
                if (!(icfgEdge instanceof IInternalAction)) {
                    throw new UnsupportedOperationException("interprocedural path programs are not supported (yet)");
                }
                UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge.getTransformula();
                set.addAll(unmodifiableTransFormula.getInVars().keySet());
                set.addAll(unmodifiableTransFormula.getOutVars().keySet());
                linkedList2.addLast(iIcfg.getCfgSmtToolkit().getIcfgEdgeFactory().createInternalTransition((IcfgLocation)icfgEdge.getSource(), (IcfgLocation)icfgEdge.getTarget(), icfgEdge.getPayload(), unmodifiableTransFormula));
            }
        }
        list.addAll(linkedHashSet);
        list2.addAll(linkedList2);
    }

    private static List<Integer> getDisjunctsAndConjunctsFromTerm(Term term) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        int n = 1;
        int n2 = 1;
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        arrayList2.add(term);
        while (!arrayList2.isEmpty()) {
            Term term2 = (Term)arrayList2.remove(0);
            if (!(term2 instanceof ApplicationTerm)) continue;
            ApplicationTerm applicationTerm = (ApplicationTerm)term2;
            if ("and".equals(applicationTerm.getFunction().getName())) {
                if (applicationTerm.getParameters().length > n) {
                    n = applicationTerm.getParameters().length;
                }
            } else if ("or".equals(applicationTerm.getFunction().getName()) && applicationTerm.getParameters().length > n2) {
                n2 = applicationTerm.getParameters().length;
            }
            Collections.addAll(arrayList2, applicationTerm.getParameters());
        }
        arrayList.add(0, n2);
        arrayList.add(1, n);
        return arrayList;
    }

    private Map<IcfgLocation, IPredicate> generatePredicatesViaAbstractInterpretation(IIcfg<IcfgLocation> iIcfg) {
        IProgressAwareTimer iProgressAwareTimer = this.mServices.getProgressMonitorService().getChildTimer(0.2);
        IAbstractInterpretationResult iAbstractInterpretationResult = AbstractInterpreter.runFuture(iIcfg, (IProgressAwareTimer)iProgressAwareTimer, (IUltimateServiceProvider)this.mServices, (boolean)true, (ILogger)this.mLogger);
        HashMap<IcfgLocation, IPredicate> hashMap = new HashMap<IcfgLocation, IPredicate>();
        Map map = iAbstractInterpretationResult.getLoc2Term();
        for (Map.Entry entry : map.entrySet()) {
            IPredicate iPredicate = this.mPredicateUnifier.getOrConstructPredicate((Term)entry.getValue());
            hashMap.put((IcfgLocation)entry.getKey(), iPredicate);
        }
        return hashMap;
    }

    private Map<IcfgLocation, Set<IProgramVar>> generateLiveVariables(IIcfg<IcfgLocation> iIcfg) {
        IProgressAwareTimer iProgressAwareTimer = this.mServices.getProgressMonitorService().getChildTimer(0.2);
        Map map = AbstractInterpreter.runFutureLiveVariableDomain(iIcfg, (IProgressAwareTimer)iProgressAwareTimer, (IUltimateServiceProvider)this.mServices, (boolean)true, (ILogger)this.mLogger).getLoc2SingleStates();
        HashMap<IcfgLocation, Set<IProgramVar>> hashMap = new HashMap<IcfgLocation, Set<IProgramVar>>();
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put((IcfgLocation)entry.getKey(), ((LiveVariableState)entry.getValue()).getLiveVariablesAsProgramVars());
        }
        return hashMap;
    }

    private <IPT> Map<IcfgLocation, IPredicate> generateInvariantsForTransitions(List<IcfgLocation> list, List<IcfgInternalTransition> list2, IPredicate iPredicate, IPredicate iPredicate2, IcfgLocation icfgLocation, Set<IcfgLocation> set, IInvariantPatternProcessorFactory<IPT> iInvariantPatternProcessorFactory, boolean bl, Set<IProgramVar> set2, Map<IcfgLocation, Set<IProgramVar>> map, Map<IcfgLocation, UnmodifiableTransFormula> map2, boolean bl2) {
        Object object;
        Object object2;
        IInvariantPatternProcessor<Object> iInvariantPatternProcessor = iInvariantPatternProcessorFactory.produce(list, list2, iPredicate, iPredicate2, icfgLocation, set);
        this.mLogger.info((Object)("(Path)program has " + list.size() + " locations"));
        this.mPathInvariantsStatistics.setNumOfVars(set2.size());
        HashMap<IcfgLocation, IPT> hashMap = new HashMap<IcfgLocation, IPT>(list.size());
        HashMap<IcfgLocation, Set<IProgramVar>> hashMap2 = new HashMap<IcfgLocation, Set<IProgramVar>>(list.size());
        HashMap<TermVariable, IProgramVar> hashMap3 = new HashMap<TermVariable, IProgramVar>();
        if (bl) {
            object2 = list2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                for (Map.Entry entry : object.getTransformula().getInVars().entrySet()) {
                    hashMap3.put((TermVariable)entry.getValue(), (IProgramVar)entry.getKey());
                }
                for (Map.Entry entry : object.getTransformula().getOutVars().entrySet()) {
                    hashMap3.put((TermVariable)entry.getValue(), (IProgramVar)entry.getKey());
                }
            }
        }
        object = new HashSet();
        if (bl && INIT_USE_EMPTY_PATTERNS && (object2 = this.executePreRoundWithEmptyPatterns(iInvariantPatternProcessor, 0, (Set<IProgramVar>)object, hashMap, hashMap2, hashMap3, icfgLocation, set, list, list2, set2, map2, bl2)) != null) {
            return object2;
        }
        int n = 1;
        while (n < iInvariantPatternProcessor.getMaxRounds()) {
            Object object3;
            Object object4;
            IcfgLocation icfgLocation22;
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(CFGInvariantsGenerator.class);
            }
            iInvariantPatternProcessor.startRound(n);
            this.mLogger.info((Object)("Round " + n + " started"));
            hashMap.clear();
            hashMap2.clear();
            for (IcfgLocation icfgLocation3 : list) {
                if (bl && USE_VARS_FROM_UNSAT_CORE_FOR_EACH_LOC && n > 0) {
                    hashMap.put(icfgLocation3, iInvariantPatternProcessor.getInvariantPatternForLocation(icfgLocation3, n, (Set<IProgramVar>)object));
                } else {
                    hashMap.put(icfgLocation3, iInvariantPatternProcessor.getInvariantPatternForLocation(icfgLocation3, n));
                }
                hashMap2.put(icfgLocation3, iInvariantPatternProcessor.getVariablesForInvariantPattern(icfgLocation3, n));
            }
            if (bl2 && map2 != null) {
                this.addWP_PredicatesToInvariantPatterns(iInvariantPatternProcessor, hashMap, hashMap2, map2);
            }
            this.mLogger.info((Object)"Built pattern map.");
            ArrayList arrayList = new ArrayList(list.size());
            int n2 = 0;
            int n3 = Integer.MAX_VALUE;
            int n4 = 0;
            for (IcfgLocation icfgLocation22 : list) {
                object4 = hashMap.get(icfgLocation22);
                object3 = (Set)hashMap2.get(icfgLocation22);
                SuccessorConstraintIngredients successorConstraintIngredients = new SuccessorConstraintIngredients(icfgLocation22, (Set<IProgramVar>)object3, object4);
                for (Object object5 : icfgLocation22.getOutgoingEdges()) {
                    Object v = hashMap.get(object5.getTarget());
                    Set set3 = (Set)hashMap2.get(object5.getTarget());
                    if (this.mKindOfInvariant == KindOfInvariant.DANGER) {
                        IPT IPT = iInvariantPatternProcessor.getPatternForTransition((IcfgEdge)object5, n);
                        successorConstraintIngredients.addTransition((IcfgEdge)object5, v, set3, IPT);
                    } else {
                        successorConstraintIngredients.addTransition((IcfgEdge)object5, v, set3);
                    }
                    int n5 = ((LinearInequalityInvariantPatternProcessor)iInvariantPatternProcessor).getTotalNumberOfConjunctsInPattern((Dnf<AbstractLinearInvariantPattern>)((Dnf)v));
                    n2 += n5;
                    if (set.contains(object5.getTarget())) continue;
                    if (n5 < n3) {
                        n3 = n5;
                    }
                    if (n5 <= n4) continue;
                    n4 = n5;
                }
                arrayList.add(successorConstraintIngredients);
            }
            this.prepareAndSetPathInvariantsStatisticsBeforeCheckSat(list, icfgLocation, set, set2, map, n2, n3, n4, n);
            icfgLocation22 = iInvariantPatternProcessor.checkForValidConfiguration(arrayList, n);
            Object object6 = null;
            object = null;
            if (icfgLocation22 == Script.LBool.UNSAT) {
                if (bl) {
                    object6 = ((LinearInequalityInvariantPatternProcessor)iInvariantPatternProcessor).getLocationsInUnsatCore();
                    object4 = ((LinearInequalityInvariantPatternProcessor)iInvariantPatternProcessor).getVarsFromUnsatCore();
                    if (object4 != null) {
                        this.mLogger.info((Object)(object4.size() + " out of " + hashMap3.size() + " SMT variables in unsat core"));
                        object = new HashSet(object4.size());
                        Iterator iterator = object4.iterator();
                        while (iterator.hasNext()) {
                            object3 = (TermVariable)iterator.next();
                            if (hashMap3.get(object3) == null) continue;
                            object.add((IProgramVar)hashMap3.get(object3));
                        }
                        if (this.mLogger.isInfoEnabled()) {
                            this.mLogger.info((Object)("Vars in unsat core: " + String.valueOf(object)));
                        }
                        this.mLogger.info((Object)(object.size() + " out of " + new HashSet(hashMap3.values()).size() + " program variables in unsat core"));
                        if (this.mLogger.isInfoEnabled()) {
                            this.mLogger.info((Object)("Locations in unsat core: " + String.valueOf(object6)));
                        }
                        this.mLogger.info((Object)(object6.size() + " out of " + list.size() + " locations in unsat core"));
                    }
                } else {
                    object = null;
                }
            }
            object4 = ((LinearInequalityInvariantPatternProcessor)iInvariantPatternProcessor).getStatistics();
            this.prepareAndSetPathInvariantsStatisticsAfterCheckSat(list, (Set<IcfgLocation>)object6, icfgLocation, set, set2, (Set<IProgramVar>)object, n, icfgLocation22.toString(), (Map<LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics, Object>)object4);
            object3 = new StatisticsData();
            object3.aggregateBenchmarkData((IStatisticsDataProvider)this.mRound2InvariantSynthesisStatistics.get(n));
            StatisticsResult statisticsResult = new StatisticsResult(Activator.PLUGIN_ID, "InvariantSynthesisStatistics", (ICsvProviderProvider)object3);
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)statisticsResult);
            if (icfgLocation22 == Script.LBool.SAT) {
                this.mLogger.info((Object)("Found valid configuration in round " + n + "."));
                object3 = new HashMap(list.size());
                iInvariantPatternProcessor.extractValuesForPatternCoefficients();
                for (IcfgLocation icfgLocation4 : list) {
                    object3.put(icfgLocation4, iInvariantPatternProcessor.applyConfiguration(hashMap.get(icfgLocation4)));
                }
                return object3;
            }
            if (icfgLocation22 == Script.LBool.UNKNOWN) {
                this.mLogger.info((Object)("Got \"UNKNOWN\" in round " + n + ", giving up the invariant search."));
                break;
            }
            if (n == iInvariantPatternProcessor.getMaxRounds() - 1) {
                this.mLogger.info((Object)("Maximal number of rounds (round = " + iInvariantPatternProcessor.getMaxRounds() + ") reached, giving up the invariant search."));
            }
            ++n;
        }
        return null;
    }

    public static Map<IcfgLocation, UnmodifiableTransFormula> convertMapToPredsToMapToUnmodTrans(Map<IcfgLocation, IPredicate> map, ManagedScript managedScript) {
        if (map == null) {
            return null;
        }
        Map<IcfgLocation, UnmodifiableTransFormula> map2 = map.keySet().stream().collect(Collectors.toMap(icfgLocation -> icfgLocation, icfgLocation -> TransFormulaBuilder.constructTransFormulaFromPredicate((IPredicate)((IPredicate)map.get(icfgLocation)), (ManagedScript)managedScript)));
        return map2;
    }

    public Map<Integer, InvariantSynthesisStatisticsGenerator> getRound2PathInvariantsStatistics() {
        return this.mRound2InvariantSynthesisStatistics;
    }

    public InvariantSynthesisStatisticsGenerator getInvariantSynthesisStatistics() {
        return this.mPathInvariantsStatistics;
    }

    private void prepareAndSetPathInvariantsStatisticsBeforeCheckSat(List<IcfgLocation> list, IcfgLocation icfgLocation, Set<IcfgLocation> set, Set<IProgramVar> set2, Map<IcfgLocation, Set<IProgramVar>> map, int n, int n2, int n3, int n4) {
        int n5 = set2.size() * (list.size() - 2);
        int n6 = 0;
        for (IcfgLocation object2 : list) {
            if (object2 == icfgLocation || set.contains(object2) || map == null || !map.containsKey(object2)) continue;
            n6 += set2.size() - map.get(object2).size();
        }
        this.mPathInvariantsStatistics.addStatisticsDataBeforeCheckSat(n, n3, n2, n5, n6, n4);
        InvariantSynthesisStatisticsGenerator invariantSynthesisStatisticsGenerator = new InvariantSynthesisStatisticsGenerator();
        invariantSynthesisStatisticsGenerator.initializeStatistics();
        int n7 = (Integer)this.mPathInvariantsStatistics.getValue("ProgramLocs");
        int n8 = (Integer)this.mPathInvariantsStatistics.getValue("ProgramLocsLbe");
        invariantSynthesisStatisticsGenerator.setNumOfPathProgramLocations(n7, n8);
        invariantSynthesisStatisticsGenerator.setNumOfVars(set2.size());
        invariantSynthesisStatisticsGenerator.addStatisticsDataBeforeCheckSat(n, n3, n2, n5, n6, n4);
        this.mRound2InvariantSynthesisStatistics.put(n4, invariantSynthesisStatisticsGenerator);
    }

    private void prepareAndSetPathInvariantsStatisticsAfterCheckSat(List<IcfgLocation> list, Set<IcfgLocation> set, IcfgLocation icfgLocation, Set<IcfgLocation> set2, Set<IProgramVar> set3, Set<IProgramVar> set4, int n, String string, Map<LinearInequalityInvariantPatternProcessor.LinearInequalityPatternProcessorStatistics, Object> map) {
        int n2 = 0;
        int n3 = 0;
        if (set != null && !set.isEmpty()) {
            n3 = list.size() - set.size();
        }
        for (IcfgLocation icfgLocation2 : list) {
            if (icfgLocation2 == icfgLocation || set2.contains(icfgLocation2) || set4 == null) continue;
            n2 += set3.size() - set4.size();
        }
        this.mPathInvariantsStatistics.addStatisticsDataAfterCheckSat(n3, n2, string, map);
        this.mRound2InvariantSynthesisStatistics.get(n).addStatisticsDataAfterCheckSat(n3, n2, string, map);
    }

    private <IPT> void addWP_PredicatesToInvariantPatterns(IInvariantPatternProcessor<IPT> iInvariantPatternProcessor, Map<IcfgLocation, IPT> map, Map<IcfgLocation, Set<IProgramVar>> map2, Map<IcfgLocation, UnmodifiableTransFormula> map3) {
        this.mLogger.info((Object)"Add weakest precondition to invariant patterns.");
        for (Map.Entry<IcfgLocation, UnmodifiableTransFormula> entry : map3.entrySet()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Loc: " + String.valueOf(entry.getKey()) + " WP: " + String.valueOf(entry.getValue())));
            }
            IPT IPT = iInvariantPatternProcessor.addTransFormulaToEachConjunctInPattern(map.get(entry.getKey()), entry.getValue());
            map.put(entry.getKey(), IPT);
            HashSet hashSet = new HashSet(entry.getValue().getInVars().keySet());
            hashSet.addAll(entry.getValue().getOutVars().keySet());
            hashSet.addAll((Collection)map2.get(entry.getKey()));
            map2.put(entry.getKey(), hashSet);
        }
    }

    private <IPT> Map<IcfgLocation, IPredicate> executePreRoundWithEmptyPatterns(IInvariantPatternProcessor<IPT> iInvariantPatternProcessor, int n, Set<IProgramVar> set, Map<IcfgLocation, IPT> map, Map<IcfgLocation, Set<IProgramVar>> map2, Map<TermVariable, IProgramVar> map3, IcfgLocation icfgLocation, Set<IcfgLocation> set2, List<IcfgLocation> list, List<IcfgInternalTransition> list2, Set<IProgramVar> set3, Map<IcfgLocation, UnmodifiableTransFormula> map4, boolean bl) {
        Object object;
        IcfgLocation icfgLocation222;
        Object object2;
        n = 0;
        iInvariantPatternProcessor.startRound(n);
        this.mLogger.info((Object)"Pre-round with empty patterns for intermediate locations started...");
        map.clear();
        map2.clear();
        for (IcfgLocation object42 : list) {
            object2 = object42.equals((Object)icfgLocation) ? iInvariantPatternProcessor.getEntryInvariantPattern() : (set2.contains(object42) ? iInvariantPatternProcessor.getExitInvariantPattern() : iInvariantPatternProcessor.getEmptyInvariantPattern());
            map.put(object42, object2);
            map2.put(object42, Collections.emptySet());
        }
        this.mLogger.info((Object)"Built (empty) pattern map");
        if (bl && map4 != null) {
            this.addWP_PredicatesToInvariantPatterns(iInvariantPatternProcessor, map, map2, map4);
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (IcfgLocation icfgLocation222 : list) {
            IPT IPT = map.get(icfgLocation222);
            Object object3 = map2.get(icfgLocation222);
            object = new SuccessorConstraintIngredients<IPT>(icfgLocation222, (Set<IProgramVar>)object3, IPT);
            for (IcfgEdge icfgEdge : icfgLocation222.getOutgoingEdges()) {
                IPT IPT2 = map.get(icfgEdge.getTarget());
                Set<IProgramVar> set4 = map2.get(icfgEdge.getTarget());
                ((SuccessorConstraintIngredients)object).addTransition(icfgEdge, IPT2, set4);
            }
            arrayList.add(object);
        }
        icfgLocation222 = iInvariantPatternProcessor.checkForValidConfiguration(arrayList, n);
        if (icfgLocation222 == Script.LBool.SAT) {
            this.mLogger.info((Object)"Found valid configuration in pre-round.");
            object2 = new HashMap(list.size());
            iInvariantPatternProcessor.extractValuesForPatternCoefficients();
            for (IcfgLocation icfgLocation2 : list) {
                object = iInvariantPatternProcessor.applyConfiguration(map.get(icfgLocation2));
                object2.put(icfgLocation2, object);
            }
            return object2;
        }
        object2 = ((LinearInequalityInvariantPatternProcessor)iInvariantPatternProcessor).getVarsFromUnsatCore();
        Set<IcfgLocation> set5 = ((LinearInequalityInvariantPatternProcessor)iInvariantPatternProcessor).getLocationsInUnsatCore();
        if (object2 != null) {
            this.mLogger.info((Object)(object2.size() + " out of " + map3.size() + " SMT variables in unsat core"));
            for (Object object3 : object2) {
                if (map3.get(object3) == null) continue;
                set.add(map3.get(object3));
            }
            if (set5 != null) {
                set5.isEmpty();
            }
            this.mLogger.info((Object)(set.size() + " out of " + new HashSet<IProgramVar>(map3.values()).size() + " program variables in unsat core"));
            this.mLogger.info((Object)(set5.size() + " out of " + list.size() + " locations in unsat core"));
        } else {
            set = null;
        }
        this.mLogger.info((Object)"No valid configuration found in pre-round.");
        return null;
    }

    private int getNumOfPPLocations(IIcfg<IcfgLocation> iIcfg) {
        int n = 0;
        for (String string : iIcfg.getProgramPoints().keySet()) {
            n += ((Map)iIcfg.getProgramPoints().get(string)).size();
        }
        return n;
    }

    public Map<IcfgLocation, IPredicate> synthesizeInvariants() {
        IIcfg<IcfgLocation> iIcfg;
        int n = this.getNumOfPPLocations(this.mIcfg);
        LargeBlockEncodingIcfgTransformer largeBlockEncodingIcfgTransformer = null;
        if (this.mApplyLargeBlockEncoding) {
            largeBlockEncodingIcfgTransformer = new LargeBlockEncodingIcfgTransformer(this.mServices, this.mPredicateFactory, this.mPredicateUnifier);
            iIcfg = largeBlockEncodingIcfgTransformer.transform(this.mIcfg);
        } else {
            iIcfg = this.mIcfg;
        }
        int n2 = this.getNumOfPPLocations(iIcfg);
        this.mPathInvariantsStatistics.setNumOfPathProgramLocations(n, n2);
        Map<IcfgLocation, IPredicate> map = this.generateInvariantsForPathProgram(iIcfg, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, this.mCsToolKit, this.mInvariantSynthesisSettings);
        if (map != null) {
            if (this.mApplyLargeBlockEncoding) {
                map = largeBlockEncodingIcfgTransformer.transform(map);
            }
            return map;
        }
        return null;
    }
}

