/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.ListIterator;

public class CsvProviderRounding<T>
implements ICsvProviderTransformer<T> {
    private final int mPlaces;

    public CsvProviderRounding(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.mPlaces = n;
    }

    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> iCsvProvider) {
        List<String> list = iCsvProvider.getRowHeaders();
        int n = 0;
        while (n < list.size()) {
            ListIterator<T> listIterator = iCsvProvider.getRow(n).listIterator();
            while (listIterator.hasNext()) {
                T t = listIterator.next();
                if (t instanceof Double) {
                    this.replaceDouble(listIterator, t);
                    continue;
                }
                if (!(t instanceof String)) continue;
                this.replaceString(listIterator, t);
            }
            ++n;
        }
        return iCsvProvider;
    }

    private void replaceDouble(ListIterator<T> listIterator, T t) {
        listIterator.set(this.round(BigDecimal.valueOf((Double)t)));
    }

    private void replaceString(ListIterator<T> listIterator, T t) {
        try {
            String string = this.round(new BigDecimal((String)t)).toString();
            String string2 = this.mPlaces == 0 ? string.substring(0, string.length() - 2) : string;
            listIterator.set(string2);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private Double round(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.setScale(this.mPlaces, RoundingMode.HALF_UP);
        return bigDecimal2.doubleValue();
    }
}

